/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DeliveryException;
import ai.promoted.delivery.client.Metrics;
import ai.promoted.delivery.model.LogRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Logger;

public class ApiMetrics
implements Metrics {
    private static final Logger LOGGER = Logger.getLogger(ApiMetrics.class.getName());
    private final String endpoint;
    private final String apiKey;
    private final HttpClient httpClient;
    private final ObjectMapper mapper;
    private final Duration timeoutDuration;

    public ApiMetrics(String endpoint, String apiKey, long timeoutMillis) {
        this.endpoint = endpoint;
        this.apiKey = apiKey;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.timeoutDuration = Duration.of(timeoutMillis, ChronoUnit.MILLIS);
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    }

    @Override
    public void runMetricsLogging(LogRequest logRequest) throws DeliveryException {
        try {
            String requestBody = this.mapper.writeValueAsString((Object)logRequest);
            HttpRequest httpReq = HttpRequest.newBuilder().uri(URI.create(this.endpoint)).header("Content-Type", "application/json").header("x-api-key", this.apiKey).timeout(this.timeoutDuration).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
            HttpResponse<String> response = this.httpClient.send(httpReq, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200 || 300 <= response.statusCode()) {
                LOGGER.warning(() -> "Failure calling Metrics API; statusCode=" + response.statusCode() + ", body=" + (String)response.body());
            }
        }
        catch (Exception ex) {
            throw new DeliveryException("Error logging to metrics", ex);
        }
    }
}

