package ai.promoted.delivery.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * UserInfo
 */
@JsonPropertyOrder({UserInfo.JSON_PROPERTY_IS_INTERNAL_USER, UserInfo.JSON_PROPERTY_ANON_USER_ID,
    UserInfo.JSON_PROPERTY_USER_ID})
public class UserInfo {
  public static final String JSON_PROPERTY_IS_INTERNAL_USER = "isInternalUser";
  private Boolean isInternalUser;

  public static final String JSON_PROPERTY_IGNORE_USAGE = "ignoreUsage";
  private Boolean ignoreUsage;

  public static final String JSON_PROPERTY_ANON_USER_ID = "anonUserId";
  private String anonUserId;

  public static final String JSON_PROPERTY_USER_ID = "userId";
  private String userId;

  public UserInfo() {}

  public UserInfo isInternalUser(Boolean isInternalUser) {
    this.isInternalUser = isInternalUser;
    return this;
  }

  /**
   * Get isInternalUser
   * 
   * @return isInternalUser
   **/
  @JsonProperty(JSON_PROPERTY_IS_INTERNAL_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsInternalUser() {
    return isInternalUser;
  }


  @JsonProperty(JSON_PROPERTY_IS_INTERNAL_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsInternalUser(Boolean isInternalUser) {
    this.isInternalUser = isInternalUser;
  }

  /**
   * Get ignoreUsage
   * 
   * @return ignoreUsage
   **/
  @JsonProperty(JSON_PROPERTY_IGNORE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreUsage() {
    return ignoreUsage;
  }


  @JsonProperty(JSON_PROPERTY_IGNORE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoreUsage(Boolean ignoreUsage) {
    this.ignoreUsage = ignoreUsage;
  }


  public UserInfo anonUserId(String anonUserId) {
    this.anonUserId = anonUserId;
    return this;
  }

  /**
   * Get anonUserId
   * 
   * @return anonUserId
   **/
  @JsonProperty(JSON_PROPERTY_ANON_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAnonUserId() {
    return anonUserId;
  }


  @JsonProperty(JSON_PROPERTY_ANON_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnonUserId(String anonUserId) {
    this.anonUserId = anonUserId;
  }


  public UserInfo userId(String userId) {
    this.userId = userId;
    return this;
  }

  /**
   * Get userId
   * 
   * @return userId
   **/
  @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUserId() {
    return userId;
  }


  @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserId(String userId) {
    this.userId = userId;
  }


  /**
   * Return true if this UserInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserInfo userInfo = (UserInfo) o;
    return Objects.equals(this.isInternalUser, userInfo.isInternalUser)
        && Objects.equals(this.ignoreUsage, userInfo.ignoreUsage)
        && Objects.equals(this.anonUserId, userInfo.anonUserId)
        && Objects.equals(this.userId, userInfo.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isInternalUser, anonUserId, userId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserInfo {\n");
    sb.append("    isInternalUser: ").append(toIndentedString(isInternalUser)).append("\n");
    sb.append("    ignoreUsage: ").append(toIndentedString(ignoreUsage)).append("\n");
    sb.append("    anonUserId: ").append(toIndentedString(anonUserId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

