/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.DeliveryRequestValidator;
import ai.promoted.delivery.model.CohortMembership;
import ai.promoted.delivery.model.Insertion;
import ai.promoted.delivery.model.Request;
import java.util.ArrayList;
import java.util.List;

public class DefaultDeliveryRequestValidator
implements DeliveryRequestValidator {
    public static final DefaultDeliveryRequestValidator INSTANCE = new DefaultDeliveryRequestValidator();

    @Override
    public List<String> validate(DeliveryRequest request) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        Request req = request.getRequest();
        if (req == null) {
            validationErrors.add("Request must be set");
            return validationErrors;
        }
        validationErrors.addAll(this.validateIds(request.getRequest(), request.getExperiment()));
        if (request.getRetrievalInsertionOffset() < 0) {
            validationErrors.add("Insertion start must be greater or equal to 0");
        }
        return validationErrors;
    }

    private List<String> validateIds(Request request, CohortMembership experiment) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (request.getRequestId() != null) {
            validationErrors.add("Request.requestId should not be set");
        }
        if (request.getUserInfo() == null) {
            validationErrors.add("Request.userInfo should be set");
        } else if (request.getUserInfo().getAnonUserId() == null || request.getUserInfo().getAnonUserId().isBlank()) {
            validationErrors.add("Request.userInfo.anonUserId should be set");
        }
        if (request.getInsertion() == null) {
            validationErrors.add("Request.insertion should be set");
        } else {
            for (Insertion ins : request.getInsertion()) {
                if (ins.getContentId() != null && !ins.getContentId().isBlank()) continue;
                validationErrors.add("Insertion.contentId should be set");
            }
        }
        return validationErrors;
    }
}

