/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.Delivery;
import ai.promoted.delivery.client.DeliveryException;
import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.DeliveryRequestState;
import ai.promoted.proto.delivery.Response;
import ai.promoted.proto.delivery.grpc.DeliveryGrpc;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.TlsChannelCredentials;
import io.grpc.stub.MetadataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class ApiDelivery
implements Delivery {
    private static final Logger LOGGER = Logger.getLogger(ApiDelivery.class.getName());
    private static final String DELIVER_SUFFIX = "/deliver";
    private static final String HEALTHZ_SUFFIX = "/healthz";
    private final String deliverHttpEndpoint;
    private final String deliverGrpcEndpoint;
    private final String healthzEndpoint;
    private final String apiKey;
    private final HttpClient httpClient;
    private final DeliveryGrpc.DeliveryBlockingStub deliveryBlockingStub;
    private final Duration timeoutDuration;
    private final int maxRequestInsertions;
    private final boolean acceptGzip;

    public ApiDelivery(String endpoint, String apiKey, long timeoutMillis, boolean warmup, int maxRequestInsertions, boolean acceptGzip, boolean useGrpc) {
        URI uri = null;
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            LOGGER.log(Level.WARNING, "Error while parsing endpoint", ex);
        }
        if (uri == null) {
            this.deliverHttpEndpoint = endpoint;
            this.deliverGrpcEndpoint = endpoint;
            this.healthzEndpoint = endpoint;
        } else {
            this.deliverHttpEndpoint = uri.getScheme() + "://" + uri.getAuthority() + DELIVER_SUFFIX;
            this.deliverGrpcEndpoint = uri.getAuthority();
            this.healthzEndpoint = uri.getScheme() + "://" + uri.getAuthority() + HEALTHZ_SUFFIX;
        }
        this.apiKey = apiKey;
        this.timeoutDuration = Duration.of(timeoutMillis, ChronoUnit.MILLIS);
        this.maxRequestInsertions = maxRequestInsertions;
        this.acceptGzip = acceptGzip;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        if (warmup) {
            this.runWarmup();
        }
        if (useGrpc) {
            ManagedChannel channel = Grpc.newChannelBuilder((String)this.deliverGrpcEndpoint, (ChannelCredentials)TlsChannelCredentials.create()).build();
            Metadata headers = new Metadata();
            headers.put(Metadata.Key.of((String)"x-api-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)apiKey);
            this.deliveryBlockingStub = (DeliveryGrpc.DeliveryBlockingStub)DeliveryGrpc.newBlockingStub((Channel)channel).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
        } else {
            this.deliveryBlockingStub = null;
        }
    }

    @Override
    public Response runDelivery(DeliveryRequest deliveryRequest) throws DeliveryException {
        Response resp;
        DeliveryRequestState state = new DeliveryRequestState(deliveryRequest);
        if (this.deliveryBlockingStub == null) {
            try {
                String requestBody = JsonFormat.printer().print((MessageOrBuilder)state.getRequestToSend(this.maxRequestInsertions));
                HttpRequest.Builder httpReqBuilder = HttpRequest.newBuilder().uri(URI.create(this.deliverHttpEndpoint)).header("Content-Type", "application/json").header("x-api-key", this.apiKey);
                if (this.acceptGzip) {
                    httpReqBuilder.header("Accept-Encoding", "gzip");
                }
                httpReqBuilder.timeout(this.timeoutDuration).POST(HttpRequest.BodyPublishers.ofString(requestBody));
                HttpRequest httpReq = httpReqBuilder.build();
                HttpResponse<InputStream> response = this.httpClient.send(httpReq, HttpResponse.BodyHandlers.ofInputStream());
                String encoding = response.headers().firstValue("Content-Encoding").orElse("");
                if (encoding.equals("gzip")) {
                    resp = this.processCompressedResponse(response);
                }
                resp = this.processUncompressedResponse(response);
            }
            catch (Exception ex) {
                throw new DeliveryException("Error running delivery", ex);
            }
        } else {
            try {
                resp = this.deliveryBlockingStub.deliver(state.getRequestToSend(this.maxRequestInsertions));
            }
            catch (StatusRuntimeException ex) {
                throw new DeliveryException("Error running delivery", ex);
            }
        }
        ApiDelivery.validate(resp);
        return state.getResponseToReturn(resp);
    }

    private Response processUncompressedResponse(HttpResponse<InputStream> response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = response.body();
             ByteArrayOutputStream autoCloseOs = os;){
            is.transferTo(autoCloseOs);
        }
        String json = new String(os.toByteArray(), StandardCharsets.UTF_8);
        Response.Builder respBuilder = Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)respBuilder);
        return respBuilder.build();
    }

    private Response processCompressedResponse(HttpResponse<InputStream> response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (GZIPInputStream is = new GZIPInputStream(response.body());
             ByteArrayOutputStream autoCloseOs = os;){
            is.transferTo(autoCloseOs);
        }
        String json = new String(os.toByteArray(), StandardCharsets.UTF_8);
        Response.Builder respBuilder = Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(json, (Message.Builder)respBuilder);
        return respBuilder.build();
    }

    static void validate(Response response) throws DeliveryException {
        if (response.getRequestId().isBlank()) {
            throw new DeliveryException("Delivery Response should contain a requestId");
        }
    }

    private void runWarmup() {
        for (int i = 0; i < 20; ++i) {
            try {
                HttpRequest httpReq = HttpRequest.newBuilder().uri(URI.create(this.healthzEndpoint)).header("x-api-key", this.apiKey).GET().build();
                this.httpClient.send(httpReq, HttpResponse.BodyHandlers.ofString());
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error during warmup", ex);
            }
        }
    }
}

