/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.DeliveryRequestValidator;
import ai.promoted.proto.delivery.Insertion;
import ai.promoted.proto.delivery.Request;
import ai.promoted.proto.event.CohortMembership;
import java.util.ArrayList;
import java.util.List;

public class DefaultDeliveryRequestValidator
implements DeliveryRequestValidator {
    public static final DefaultDeliveryRequestValidator INSTANCE = new DefaultDeliveryRequestValidator();

    @Override
    public List<String> validate(DeliveryRequest request) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        Request.Builder reqBuilder = request.getRequestBuilder();
        if (reqBuilder == null) {
            validationErrors.add("Request builder must be set");
            return validationErrors;
        }
        validationErrors.addAll(this.validateIds(request.getRequestBuilder(), request.getExperiment()));
        if (request.getRetrievalInsertionOffset() < 0) {
            validationErrors.add("Insertion start must be greater or equal to 0");
        }
        return validationErrors;
    }

    private List<String> validateIds(Request.Builder reqBuilder, CohortMembership experiment) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!reqBuilder.getRequestId().isBlank()) {
            validationErrors.add("Request.requestId should not be set");
        }
        if (!reqBuilder.hasUserInfo()) {
            validationErrors.add("Request.userInfo should be set");
        } else if (reqBuilder.getUserInfo().getAnonUserId().isBlank()) {
            validationErrors.add("Request.userInfo.anonUserId should be set");
        }
        for (Insertion ins : reqBuilder.getInsertionList()) {
            if (!ins.getContentId().isBlank()) continue;
            validationErrors.add("Insertion.contentId should be set");
        }
        return validationErrors;
    }
}

