/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DefaultDeliveryRequestValidator;
import ai.promoted.delivery.client.DeliveryRequestValidator;
import ai.promoted.proto.delivery.Request;
import ai.promoted.proto.event.CohortMembership;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DeliveryRequest
implements Cloneable {
    private Request.Builder requestBuilder;
    private final boolean onlyLog;
    private final int retrievalInsertionOffset;
    @Nullable
    private final CohortMembership experiment;
    private final DeliveryRequestValidator validator;

    public DeliveryRequest(Request.Builder requestBuilder, CohortMembership experiment, boolean onlyLog, int retrievalInsertionOffset, DeliveryRequestValidator validator) {
        this.requestBuilder = requestBuilder;
        this.onlyLog = onlyLog;
        this.experiment = experiment;
        this.retrievalInsertionOffset = retrievalInsertionOffset;
        this.validator = validator;
    }

    public DeliveryRequest(Request.Builder requestBuilder, CohortMembership experiment, boolean onlyLog, int retrievalInsertionOffset) {
        this(requestBuilder, experiment, onlyLog, retrievalInsertionOffset, DefaultDeliveryRequestValidator.INSTANCE);
    }

    public DeliveryRequest(Request.Builder requestBuilder, CohortMembership experiment) {
        this(requestBuilder, experiment, false, 0);
    }

    public DeliveryRequest(Request.Builder requestBuilder) {
        this(requestBuilder, null);
    }

    public Request.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    public boolean isOnlyLog() {
        return this.onlyLog;
    }

    public int getRetrievalInsertionOffset() {
        return this.retrievalInsertionOffset;
    }

    public CohortMembership getExperiment() {
        return this.experiment;
    }

    public DeliveryRequest clone() throws CloneNotSupportedException {
        DeliveryRequest deliveryRequestCopy = (DeliveryRequest)super.clone();
        if (this.requestBuilder != null) {
            deliveryRequestCopy.requestBuilder = this.requestBuilder.clone();
        }
        return deliveryRequestCopy;
    }

    public List<String> validate() {
        if (this.validator != null) {
            return this.validator.validate(this);
        }
        return new ArrayList<String>();
    }
}

