/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.proto.delivery.Insertion;
import ai.promoted.proto.delivery.Request;
import ai.promoted.proto.delivery.Response;
import java.util.ArrayList;
import java.util.logging.Logger;

class DeliveryRequestState {
    private static final Logger LOGGER = Logger.getLogger(DeliveryRequestState.class.getName());
    private final DeliveryRequest deliveryRequest;

    public DeliveryRequestState(DeliveryRequest deliveryRequest) {
        this.deliveryRequest = deliveryRequest;
    }

    public Response getResponseToReturn(Response resp) {
        return resp;
    }

    public Request getRequestToSend(int maxRequestInsertions) {
        Request.Builder reqBuilder = this.deliveryRequest.getRequestBuilder();
        if (reqBuilder.getInsertionCount() > maxRequestInsertions) {
            LOGGER.warning("Too many request insertions, truncating at " + maxRequestInsertions);
            ArrayList<Insertion> truncatedList = new ArrayList<Insertion>(reqBuilder.getInsertionList().subList(0, maxRequestInsertions));
            reqBuilder.clearInsertion();
            reqBuilder.addAllInsertion(truncatedList);
        }
        return reqBuilder.build();
    }
}

