/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.proto.common.Properties;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.Values;
import java.util.Map;

public class PropertiesFactory {
    public static Properties.Builder createPropertiesBuilder(Map<String, Object> properties) {
        Properties.Builder propertiesBuilder = Properties.newBuilder();
        if (!properties.isEmpty()) {
            propertiesBuilder.setStruct(PropertiesFactory.convertMapToStruct(properties));
        }
        return propertiesBuilder;
    }

    public static Properties createProperties(Map<String, Object> properties) {
        return PropertiesFactory.createPropertiesBuilder(properties).build();
    }

    private static Struct convertMapToStruct(Map<String, Object> map) {
        Struct.Builder structBuilder = Struct.newBuilder();
        map.forEach((key, value) -> {
            Value protoValue = PropertiesFactory.convertObjectToValue(value);
            structBuilder.putFields(key, protoValue);
        });
        return structBuilder.build();
    }

    private static Value convertObjectToValue(Object object) {
        if (object instanceof Boolean) {
            return Values.of((boolean)((Boolean)object));
        }
        if (object instanceof Integer) {
            return Values.of((double)((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return Values.of((double)((Long)object).longValue());
        }
        if (object instanceof Float) {
            return Values.of((double)((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return Values.of((double)((Double)object));
        }
        if (object instanceof String) {
            return Values.of((String)((String)object));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return Values.of((Struct)PropertiesFactory.convertMapToStruct(map));
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : iterable) {
                listBuilder.addValues(PropertiesFactory.convertObjectToValue(item));
            }
            return Values.of((ListValue)listBuilder.build());
        }
        if (object == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        throw new UnsupportedOperationException("property value class=" + object.getClass());
    }
}

