/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.delivery.client.Delivery;
import ai.promoted.delivery.client.DeliveryException;
import ai.promoted.delivery.client.DeliveryRequest;
import ai.promoted.delivery.client.InsertionFactory;
import ai.promoted.proto.delivery.Insertion;
import ai.promoted.proto.delivery.Paging;
import ai.promoted.proto.delivery.Request;
import ai.promoted.proto.delivery.Response;
import java.util.UUID;

public class SdkDelivery
implements Delivery {
    @Override
    public Response runDelivery(DeliveryRequest deliveryRequest) throws DeliveryException {
        Request.Builder requestBuilder = deliveryRequest.getRequestBuilder();
        requestBuilder.setRequestId(UUID.randomUUID().toString());
        Paging paging = requestBuilder.getPaging();
        if (!requestBuilder.hasPaging()) {
            paging = Paging.newBuilder().setOffset(0).setSize(requestBuilder.getInsertionCount()).build();
        }
        int offset = Math.max(0, paging.getOffset());
        int index = offset - deliveryRequest.getRetrievalInsertionOffset();
        if (offset < deliveryRequest.getRetrievalInsertionOffset()) {
            throw new DeliveryException("offset should be >= insertion start (specifically, the global position)");
        }
        int size = paging.getSize();
        if (size <= 0) {
            size = requestBuilder.getInsertionCount();
        }
        int finalInsertionSize = Math.min(size, requestBuilder.getInsertionCount() - index);
        Response.Builder respBuilder = Response.newBuilder().setRequestId(requestBuilder.getRequestId());
        for (int i = 0; i < finalInsertionSize; ++i) {
            Insertion reqIns = requestBuilder.getInsertion(index);
            Insertion.Builder respInsBuilder = Insertion.newBuilder().setContentId(reqIns.getContentId()).setInsertionId(reqIns.getInsertionId());
            InsertionFactory.prepareResponseInsertionBuilder(respInsBuilder, offset);
            respBuilder.addInsertion(respInsBuilder);
            ++index;
            ++offset;
        }
        return respBuilder.build();
    }
}

