/*
 * Decompiled with CFR 0.152.
 */
package ai.promoted.delivery.client;

import ai.promoted.proto.event.CohortArm;
import ai.promoted.proto.event.CohortMembership;

public class TwoArmExperiment {
    private final String cohortId;
    private final int cohortIdHash;
    private final int numActiveControlBuckets;
    private final int numControlBuckets;
    private final int numActiveTreatmentBuckets;
    private final int numTreatmentBuckets;
    private final int numTotalBuckets;

    public static TwoArmExperiment create5050TwoArmExperimentConfig(String cohortId, int controlPercent, int treatmentPercent) {
        if (controlPercent < 0 || controlPercent > 50) {
            throw new IllegalArgumentException("Control percent must be in the range [0, 50]");
        }
        if (treatmentPercent < 0 || treatmentPercent > 50) {
            throw new IllegalArgumentException("Treatment percent must be in the range [0, 50]");
        }
        return new TwoArmExperiment(cohortId, controlPercent, 50, treatmentPercent, 50);
    }

    public TwoArmExperiment(String cohortId, int numActiveControlBuckets, int numControlBuckets, int numActiveTreatmentBuckets, int numTreatmentBuckets) {
        if (cohortId == null || cohortId.isBlank()) {
            throw new IllegalArgumentException("Cohort ID must be non-empty");
        }
        if (numControlBuckets < 0) {
            throw new IllegalArgumentException("Control buckets must be positive");
        }
        if (numTreatmentBuckets < 0) {
            throw new IllegalArgumentException("Treatment buckets must be positive");
        }
        if (numActiveControlBuckets < 0 || numActiveControlBuckets > numControlBuckets) {
            throw new IllegalArgumentException("Active control buckets must be between 0 and the total number of control buckets");
        }
        if (numActiveTreatmentBuckets < 0 || numActiveTreatmentBuckets > numTreatmentBuckets) {
            throw new IllegalArgumentException("Active treatment buckets must be between 0 and the total number of treatment buckets");
        }
        this.cohortId = cohortId;
        this.cohortIdHash = cohortId.hashCode();
        this.numActiveControlBuckets = numActiveControlBuckets;
        this.numControlBuckets = numControlBuckets;
        this.numActiveTreatmentBuckets = numActiveTreatmentBuckets;
        this.numTreatmentBuckets = numTreatmentBuckets;
        this.numTotalBuckets = numTreatmentBuckets + numControlBuckets;
    }

    public String getCohortId() {
        return this.cohortId;
    }

    public int getNumActiveControlBuckets() {
        return this.numActiveControlBuckets;
    }

    public int getNumControlBuckets() {
        return this.numControlBuckets;
    }

    public int getNumActiveTreatmentBuckets() {
        return this.numActiveTreatmentBuckets;
    }

    public int getNumTreatmentBuckets() {
        return this.numTreatmentBuckets;
    }

    public CohortMembership checkMembership(String userId) {
        int hash = this.combineHash(userId.hashCode(), this.cohortIdHash);
        int bucket = Math.abs(hash) % this.numTotalBuckets;
        if (bucket < this.numActiveControlBuckets) {
            return CohortMembership.newBuilder().setCohortId(this.cohortId).setArm(CohortArm.CONTROL).build();
        }
        if (this.numControlBuckets <= bucket && bucket < this.numControlBuckets + this.numActiveTreatmentBuckets) {
            return CohortMembership.newBuilder().setCohortId(this.cohortId).setArm(CohortArm.TREATMENT).build();
        }
        return null;
    }

    private int combineHash(int hash1, int hash2) {
        int hash = 17;
        hash = hash * 31 + hash1;
        hash = hash * 31 + hash2;
        return hash;
    }
}

