/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.AggregateOp;

public final class Aggregate {
    private final AggregateOp type;
    private final int index;

    private Aggregate(AggregateOp type, int index) {
        this.type = type;
        this.index = index;
    }

    static Aggregate count(int index, boolean include_nulls) {
        return new Aggregate(include_nulls ? AggregateOp.COUNT_ALL : AggregateOp.COUNT_VALID, index);
    }

    static Aggregate first(int index, boolean includeNulls) {
        return new Aggregate(includeNulls ? AggregateOp.FIRST_INCLUDE_NULLS : AggregateOp.FIRST_EXCLUDE_NULLS, index);
    }

    static Aggregate last(int index, boolean includeNulls) {
        return new Aggregate(includeNulls ? AggregateOp.LAST_INCLUDE_NULLS : AggregateOp.LAST_EXCLUDE_NULLS, index);
    }

    static Aggregate max(int index) {
        return new Aggregate(AggregateOp.MAX, index);
    }

    static Aggregate min(int index) {
        return new Aggregate(AggregateOp.MIN, index);
    }

    static Aggregate mean(int index) {
        return new Aggregate(AggregateOp.MEAN, index);
    }

    static Aggregate sum(int index) {
        return new Aggregate(AggregateOp.SUM, index);
    }

    static Aggregate median(int index) {
        return new Aggregate(AggregateOp.MEDIAN, index);
    }

    int getIndex() {
        return this.index;
    }

    int getNativeId() {
        return this.type.nativeId;
    }

    AggregateOp getOp() {
        return this.type;
    }
}

