/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;

public abstract class BaseDeviceMemoryBuffer
extends MemoryBuffer {
    protected BaseDeviceMemoryBuffer(long address, long length, MemoryBuffer parent) {
        super(address, length, parent);
    }

    protected BaseDeviceMemoryBuffer(long address, long length, MemoryBuffer.MemoryBufferCleaner cleaner) {
        super(address, length, cleaner);
    }

    public final void copyFromHostBuffer(long destOffset, HostMemoryBuffer src, long srcOffset, long length) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.memcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.HOST_TO_DEVICE);
    }

    public final void copyFromHostBuffer(long destOffset, HostMemoryBuffer src, long srcOffset, long length, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.memcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.HOST_TO_DEVICE, stream);
    }

    public final void copyFromHostBufferAsync(long destOffset, HostMemoryBuffer src, long srcOffset, long length, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.asyncMemcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.HOST_TO_DEVICE, stream);
    }

    public final void copyFromDeviceBufferAsync(long destOffset, BaseDeviceMemoryBuffer src, long srcOffset, long length, Cuda.Stream stream) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy range dest");
        src.addressOutOfBoundsCheck(src.address + srcOffset, length, "copy range src");
        Cuda.asyncMemcpy(this.address + destOffset, src.address + srcOffset, length, CudaMemcpyKind.DEVICE_TO_DEVICE, stream);
    }

    public final void copyFromHostBuffer(HostMemoryBuffer src, long srcOffset, long length) {
        this.copyFromHostBuffer(0L, src, srcOffset, length);
    }

    public final void copyFromHostBuffer(HostMemoryBuffer src) {
        this.copyFromHostBuffer(0L, src, 0L, src.length);
    }

    public final void copyFromHostBuffer(HostMemoryBuffer src, Cuda.Stream stream) {
        this.copyFromHostBuffer(0L, src, 0L, src.length, stream);
    }

    public final void copyFromHostBufferAsync(HostMemoryBuffer src, Cuda.Stream stream) {
        this.copyFromHostBufferAsync(0L, src, 0L, src.length, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DeviceMemoryBuffer sliceWithCopy(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        DeviceMemoryBuffer ret = null;
        boolean success = false;
        try {
            ret = DeviceMemoryBuffer.allocate(len);
            Cuda.memcpy(ret.getAddress(), this.getAddress() + offset, len, CudaMemcpyKind.DEVICE_TO_DEVICE);
            success = true;
            DeviceMemoryBuffer deviceMemoryBuffer = ret;
            return deviceMemoryBuffer;
        }
        finally {
            if (!success && ret != null) {
                ret.close();
            }
        }
    }
}

