/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.util.EnumSet;

public enum BinaryOp {
    ADD(0),
    SUB(1),
    MUL(2),
    DIV(3),
    TRUE_DIV(4),
    FLOOR_DIV(5),
    MOD(6),
    PYMOD(7),
    POW(8),
    EQUAL(9),
    NOT_EQUAL(10),
    LESS(11),
    GREATER(12),
    LESS_EQUAL(13),
    GREATER_EQUAL(14),
    BITWISE_AND(15),
    BITWISE_OR(16),
    BITWISE_XOR(17),
    LOGICAL_AND(18),
    LOGICAL_OR(19),
    SHIFT_LEFT(22),
    SHIFT_RIGHT(23),
    SHIFT_RIGHT_UNSIGNED(24),
    LOG_BASE(25),
    ATAN2(26),
    PMOD(27),
    NULL_EQUALS(28),
    NULL_MAX(29),
    NULL_MIN(30);

    static final EnumSet<BinaryOp> COMPARISON;
    static final EnumSet<BinaryOp> INEQUALITY_COMPARISON;
    private static final BinaryOp[] OPS;
    final int nativeId;

    private BinaryOp(int nativeId) {
        this.nativeId = nativeId;
    }

    static BinaryOp fromNative(int nativeId) {
        for (BinaryOp type : OPS) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a BinaryOp");
    }

    static {
        COMPARISON = EnumSet.of(EQUAL, new BinaryOp[]{NOT_EQUAL, LESS, GREATER, LESS_EQUAL, GREATER_EQUAL});
        INEQUALITY_COMPARISON = EnumSet.of(LESS, GREATER, LESS_EQUAL, GREATER_EQUAL);
        OPS = BinaryOp.values();
    }
}

