/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.HostMemoryBuffer;

final class BitVectorHelper {
    BitVectorHelper() {
    }

    static void append(HostMemoryBuffer src, HostMemoryBuffer dst, long dstOffset, long rows) {
        assert (dst.length * 8L - dstOffset >= rows) : "validity vector bigger then available space on dst: " + (dst.length * 8L - dstOffset) + " copying space needed: " + rows;
        long dstByteIndex = dstOffset / 8L;
        int shiftBits = (int)(dstOffset % 8L);
        if (shiftBits > 0) {
            BitVectorHelper.shiftSrcLeftAndWriteToDst(src, dst, dstByteIndex, shiftBits, rows);
        } else {
            dst.copyFromHostBuffer(dstByteIndex, src, 0L, BitVectorHelper.getValidityLengthInBytes(rows));
        }
    }

    private static void shiftSrcLeftAndWriteToDst(HostMemoryBuffer src, HostMemoryBuffer dst, long dstOffset, int shiftByBits, long length) {
        long i;
        assert (shiftByBits > 0 && shiftByBits < 8) : "shiftByBits out of range";
        int dstMask = 255 >> 8 - shiftByBits;
        int srcLeftMask = dstMask << 8 - shiftByBits;
        int valueFromTheLeftOfTheLastByte = dst.getByte(dstOffset) & dstMask;
        long byteLength = BitVectorHelper.getValidityLengthInBytes(length);
        for (i = 0L; i < byteLength; ++i) {
            int b = src.getByte(i);
            int fallingBitsOnTheLeft = b & srcLeftMask;
            b <<= shiftByBits;
            dst.setByte(dstOffset + i, (byte)(b |= valueFromTheLeftOfTheLastByte));
            valueFromTheLeftOfTheLastByte = fallingBitsOnTheLeft >>> 8 - shiftByBits;
        }
        if (length % 8L + (long)shiftByBits > 8L || length % 8L == 0L) {
            dst.setByte(dstOffset + i, (byte)(valueFromTheLeftOfTheLastByte | ~dstMask));
        }
    }

    static long getValidityLengthInBytes(long rows) {
        return (rows + 7L) / 8L;
    }

    static long getValidityAllocationSizeInBytes(long rows) {
        long numBytes = BitVectorHelper.getValidityLengthInBytes(rows);
        return (numBytes + 63L) / 64L * 64L;
    }

    static int setNullAt(HostMemoryBuffer valid, long index) {
        long bucket = index / 8L;
        byte currentByte = valid.getByte(bucket);
        int bitmask = ~(1 << (int)(index % 8L));
        int ret = currentByte >> (int)index & 1;
        currentByte = (byte)(currentByte & bitmask);
        valid.setByte(bucket, currentByte);
        return ret;
    }

    static boolean isNull(HostMemoryBuffer valid, long index) {
        byte b = valid.getByte(index / 8L);
        int i = b & 1 << (int)(index % 8L);
        return i == 0;
    }
}

