/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.AggregateOp;
import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.DeviceMemoryBufferView;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.QuantileMethod;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Table;
import ai.rapids.cudf.UnaryOp;
import ai.rapids.cudf.WindowOptions;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnVector
implements AutoCloseable,
BinaryOperable {
    private static final Logger log = LoggerFactory.getLogger(ColumnVector.class);
    private final DType type;
    private final OffHeapState offHeap;
    private final long rows;
    private Optional<Long> nullCount = Optional.empty();
    private int refCount;

    ColumnVector(long nativePointer) {
        assert (nativePointer != 0L);
        this.offHeap = new OffHeapState(nativePointer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.type = this.offHeap.getNativeType();
        this.rows = this.offHeap.getNativeRowCount();
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public ColumnVector(DType type, long rows, Optional<Long> nullCount, DeviceMemoryBuffer dataBuffer, DeviceMemoryBuffer validityBuffer, DeviceMemoryBuffer offsetBuffer) {
        if (type != DType.STRING) assert (offsetBuffer == null) : "offsets are only supported for STRING";
        this.offHeap = new OffHeapState(type, (int)rows, nullCount, dataBuffer, validityBuffer, offsetBuffer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.rows = rows;
        this.nullCount = nullCount;
        this.type = type;
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    private ColumnVector(long viewAddress, DeviceMemoryBuffer contiguousBuffer) {
        this.offHeap = new OffHeapState(viewAddress, contiguousBuffer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.type = this.offHeap.getNativeType();
        this.rows = this.offHeap.getNativeRowCount();
        this.nullCount = Optional.empty();
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    static ColumnVector fromViewWithContiguousAllocation(long columnViewAddress, DeviceMemoryBuffer buffer) {
        return new ColumnVector(columnViewAddress, buffer);
    }

    public ColumnVector toTitle() {
        assert (this.type == DType.STRING);
        return new ColumnVector(this.title(this.getNativeView()));
    }

    private native long title(long var1);

    public void noWarnLeakExpected() {
        this.offHeap.noWarnLeakExpected();
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    public String toString() {
        return "ColumnVector{rows=" + this.rows + ", type=" + (Object)((Object)this.type) + ", nullCount=" + this.nullCount + ", offHeap=" + this.offHeap + '}';
    }

    public ColumnVector incRefCount() {
        return this.incRefCountInternal(false);
    }

    private synchronized ColumnVector incRefCountInternal(boolean isFirstTime) {
        this.offHeap.addRef();
        if (this.refCount <= 0 && !isFirstTime) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Column is already closed");
        }
        ++this.refCount;
        return this;
    }

    public ColumnVector nansToNulls() {
        assert (this.type == DType.FLOAT32 || this.type == DType.FLOAT64);
        return new ColumnVector(ColumnVector.nansToNulls(this.getNativeView()));
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getDeviceMemorySize() {
        return this.offHeap != null ? this.offHeap.getDeviceMemorySize() : 0L;
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public long getNullCount() {
        if (!this.nullCount.isPresent()) {
            this.nullCount = Optional.of(this.offHeap.getNativeNullCount());
        }
        return this.nullCount.get();
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    public boolean hasValidityVector() {
        return this.offHeap.getValid() != null;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostColumnVector copyToHost() {
        Throwable throwable = null;
        try (NvtxRange toHost = new NvtxRange("ensureOnHost", NvtxColor.BLUE);){
            HostColumnVector hostColumnVector;
            block24: {
                HostMemoryBuffer hostValidityBuffer;
                MemoryBuffer hostDataBuffer;
                block25: {
                    hostDataBuffer = null;
                    hostValidityBuffer = null;
                    MemoryBuffer hostOffsetsBuffer = null;
                    BaseDeviceMemoryBuffer valid = this.offHeap.getValid();
                    BaseDeviceMemoryBuffer offsets = this.offHeap.getOffsets();
                    BaseDeviceMemoryBuffer data = this.offHeap.getData();
                    boolean needsCleanup = true;
                    try {
                        this.getNullCount();
                        if (valid != null) {
                            hostValidityBuffer = HostMemoryBuffer.allocate(valid.getLength());
                            hostValidityBuffer.copyFromDeviceBuffer(valid);
                        }
                        if (offsets != null) {
                            hostOffsetsBuffer = HostMemoryBuffer.allocate(offsets.length);
                            ((HostMemoryBuffer)hostOffsetsBuffer).copyFromDeviceBuffer(offsets);
                        }
                        if (data != null) {
                            hostDataBuffer = HostMemoryBuffer.allocate(data.length);
                            ((HostMemoryBuffer)hostDataBuffer).copyFromDeviceBuffer(data);
                        }
                        HostColumnVector ret = new HostColumnVector(this.type, this.rows, this.nullCount, (HostMemoryBuffer)hostDataBuffer, hostValidityBuffer, (HostMemoryBuffer)hostOffsetsBuffer);
                        needsCleanup = false;
                        hostColumnVector = ret;
                        if (!needsCleanup) break block24;
                        if (hostOffsetsBuffer == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (needsCleanup) {
                                if (hostOffsetsBuffer != null) {
                                    hostOffsetsBuffer.close();
                                }
                                if (hostDataBuffer != null) {
                                    hostDataBuffer.close();
                                }
                                if (hostValidityBuffer != null) {
                                    hostValidityBuffer.close();
                                }
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    hostOffsetsBuffer.close();
                }
                if (hostDataBuffer != null) {
                    hostDataBuffer.close();
                }
                if (hostValidityBuffer != null) {
                    hostValidityBuffer.close();
                }
            }
            return hostColumnVector;
        }
    }

    public BaseDeviceMemoryBuffer getDeviceBufferFor(BufferType type) {
        BaseDeviceMemoryBuffer srcBuffer;
        switch (type) {
            case VALIDITY: {
                srcBuffer = this.offHeap.getValid();
                break;
            }
            case DATA: {
                srcBuffer = this.offHeap.getData();
                break;
            }
            case OFFSET: {
                srcBuffer = this.offHeap.getOffsets();
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)type) + " is not a supported buffer type.");
            }
        }
        return srcBuffer;
    }

    public ColumnVector getCharLengths() {
        assert (DType.STRING == this.type) : "char length only available for String type";
        return new ColumnVector(ColumnVector.charLengths(this.getNativeView()));
    }

    public ColumnVector getByteCount() {
        assert (this.type == DType.STRING) : "type has to be a String";
        return new ColumnVector(ColumnVector.byteCount(this.getNativeView()));
    }

    public ColumnVector isNotNull() {
        return new ColumnVector(ColumnVector.isNotNullNative(this.getNativeView()));
    }

    public ColumnVector isNull() {
        return new ColumnVector(ColumnVector.isNullNative(this.getNativeView()));
    }

    public ColumnVector isInteger() {
        assert (this.type == DType.STRING);
        return new ColumnVector(ColumnVector.isInteger(this.getNativeView()));
    }

    public ColumnVector isFloat() {
        assert (this.type == DType.STRING);
        return new ColumnVector(ColumnVector.isFloat(this.getNativeView()));
    }

    public ColumnVector isNan() {
        return new ColumnVector(ColumnVector.isNanNative(this.getNativeView()));
    }

    public ColumnVector isNotNan() {
        return new ColumnVector(ColumnVector.isNotNanNative(this.getNativeView()));
    }

    public ColumnVector findAndReplaceAll(ColumnVector oldValues, ColumnVector newValues) {
        return new ColumnVector(ColumnVector.findAndReplaceAll(oldValues.getNativeView(), newValues.getNativeView(), this.getNativeView()));
    }

    public ColumnVector replaceNulls(Scalar scalar) {
        return new ColumnVector(ColumnVector.replaceNulls(this.getNativeView(), scalar.getScalarHandle()));
    }

    public ColumnVector ifElse(ColumnVector trueValues, ColumnVector falseValues) {
        if (this.type != DType.BOOL8) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + (Object)((Object)this.type));
        }
        long result = ColumnVector.ifElseVV(this.getNativeView(), trueValues.getNativeView(), falseValues.getNativeView());
        return new ColumnVector(result);
    }

    public ColumnVector ifElse(ColumnVector trueValues, Scalar falseValue) {
        if (this.type != DType.BOOL8) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + (Object)((Object)this.type));
        }
        long result = ColumnVector.ifElseVS(this.getNativeView(), trueValues.getNativeView(), falseValue.getScalarHandle());
        return new ColumnVector(result);
    }

    public ColumnVector ifElse(Scalar trueValue, ColumnVector falseValues) {
        if (this.type != DType.BOOL8) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + (Object)((Object)this.type));
        }
        long result = ColumnVector.ifElseSV(this.getNativeView(), trueValue.getScalarHandle(), falseValues.getNativeView());
        return new ColumnVector(result);
    }

    public ColumnVector ifElse(Scalar trueValue, Scalar falseValue) {
        if (this.type != DType.BOOL8) {
            throw new IllegalArgumentException("Cannot select with a predicate vector of type " + (Object)((Object)this.type));
        }
        long result = ColumnVector.ifElseSS(this.getNativeView(), trueValue.getScalarHandle(), falseValue.getScalarHandle());
        return new ColumnVector(result);
    }

    public ColumnVector[] slice(int ... indices) {
        long[] nativeHandles = ColumnVector.slice(this.getNativeView(), indices);
        ColumnVector[] columnVectors = new ColumnVector[nativeHandles.length];
        for (int i = 0; i < nativeHandles.length; ++i) {
            columnVectors[i] = new ColumnVector(nativeHandles[i]);
        }
        return columnVectors;
    }

    public ColumnVector subVector(int start) {
        return this.subVector(start, (int)this.rows);
    }

    public ColumnVector subVector(int start, int end) {
        ColumnVector[] tmp = this.slice(start, end);
        assert (tmp.length == 1);
        return tmp[0];
    }

    public ColumnVector[] split(int ... indices) {
        long[] nativeHandles = ColumnVector.split(this.getNativeView(), indices);
        ColumnVector[] columnVectors = new ColumnVector[nativeHandles.length];
        for (int i = 0; i < nativeHandles.length; ++i) {
            columnVectors[i] = new ColumnVector(nativeHandles[i]);
        }
        return columnVectors;
    }

    public static ColumnVector fromScalar(Scalar scalar, int rows) {
        long columnHandle = ColumnVector.fromScalar(scalar.getScalarHandle(), rows);
        return new ColumnVector(columnHandle);
    }

    public static ColumnVector sequence(Scalar initialValue, Scalar step, int rows) {
        if (!initialValue.isValid() || !step.isValid()) {
            throw new IllegalArgumentException("nulls are not supported in sequence");
        }
        return new ColumnVector(ColumnVector.sequence(initialValue.getScalarHandle(), step.getScalarHandle(), rows));
    }

    public static ColumnVector sequence(Scalar initialValue, int rows) {
        if (!initialValue.isValid()) {
            throw new IllegalArgumentException("nulls are not supported in sequence");
        }
        return new ColumnVector(ColumnVector.sequence(initialValue.getScalarHandle(), 0L, rows));
    }

    public static ColumnVector concatenate(ColumnVector ... columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Concatenate requires 2 or more columns");
        }
        long[] columnHandles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnHandles[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.concatenate(columnHandles));
    }

    public ColumnVector normalizeNANsAndZeros() {
        return new ColumnVector(ColumnVector.normalizeNANsAndZeros(this.getNativeView()));
    }

    public ColumnVector year() {
        assert (this.type.isTimestamp());
        return new ColumnVector(ColumnVector.year(this.getNativeView()));
    }

    public ColumnVector month() {
        assert (this.type.isTimestamp());
        return new ColumnVector(ColumnVector.month(this.getNativeView()));
    }

    public ColumnVector day() {
        assert (this.type.isTimestamp());
        return new ColumnVector(ColumnVector.day(this.getNativeView()));
    }

    public ColumnVector hour() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnVector.hour(this.getNativeView()));
    }

    public ColumnVector minute() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnVector.minute(this.getNativeView()));
    }

    public ColumnVector second() {
        assert (this.type.hasTimeResolution());
        return new ColumnVector(ColumnVector.second(this.getNativeView()));
    }

    public ColumnVector transform(String udf, boolean isPtx) {
        return new ColumnVector(ColumnVector.transform(this.getNativeView(), udf, isPtx));
    }

    public ColumnVector unaryOp(UnaryOp op) {
        return new ColumnVector(ColumnVector.unaryOperation(this.getNativeView(), op.nativeId));
    }

    public ColumnVector sin() {
        return this.unaryOp(UnaryOp.SIN);
    }

    public ColumnVector cos() {
        return this.unaryOp(UnaryOp.COS);
    }

    public ColumnVector tan() {
        return this.unaryOp(UnaryOp.TAN);
    }

    public ColumnVector arcsin() {
        return this.unaryOp(UnaryOp.ARCSIN);
    }

    public ColumnVector arccos() {
        return this.unaryOp(UnaryOp.ARCCOS);
    }

    public ColumnVector arctan() {
        return this.unaryOp(UnaryOp.ARCTAN);
    }

    public ColumnVector sinh() {
        return this.unaryOp(UnaryOp.SINH);
    }

    public ColumnVector cosh() {
        return this.unaryOp(UnaryOp.COSH);
    }

    public ColumnVector tanh() {
        return this.unaryOp(UnaryOp.TANH);
    }

    public ColumnVector arcsinh() {
        return this.unaryOp(UnaryOp.ARCSINH);
    }

    public ColumnVector arccosh() {
        return this.unaryOp(UnaryOp.ARCCOSH);
    }

    public ColumnVector arctanh() {
        return this.unaryOp(UnaryOp.ARCTANH);
    }

    public ColumnVector exp() {
        return this.unaryOp(UnaryOp.EXP);
    }

    public ColumnVector log() {
        return this.unaryOp(UnaryOp.LOG);
    }

    public ColumnVector log2() {
        try (Scalar base = Scalar.fromInt(2);){
            ColumnVector columnVector = this.binaryOp(BinaryOp.LOG_BASE, base, this.getType());
            return columnVector;
        }
    }

    public ColumnVector log10() {
        try (Scalar base = Scalar.fromInt(10);){
            ColumnVector columnVector = this.binaryOp(BinaryOp.LOG_BASE, base, this.getType());
            return columnVector;
        }
    }

    public ColumnVector sqrt() {
        return this.unaryOp(UnaryOp.SQRT);
    }

    public ColumnVector cbrt() {
        return this.unaryOp(UnaryOp.CBRT);
    }

    public ColumnVector ceil() {
        return this.unaryOp(UnaryOp.CEIL);
    }

    public ColumnVector floor() {
        return this.unaryOp(UnaryOp.FLOOR);
    }

    public ColumnVector abs() {
        return this.unaryOp(UnaryOp.ABS);
    }

    public ColumnVector rint() {
        return this.unaryOp(UnaryOp.RINT);
    }

    public ColumnVector bitInvert() {
        return this.unaryOp(UnaryOp.BIT_INVERT);
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnVector) {
            ColumnVector cvRhs = (ColumnVector)rhs;
            assert (this.rows == cvRhs.getRowCount());
            return new ColumnVector(ColumnVector.binaryOp(this, cvRhs, op, outType));
        }
        if (rhs instanceof Scalar) {
            Scalar sRhs = (Scalar)rhs;
            return new ColumnVector(ColumnVector.binaryOp(this, sRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with ColumnVector");
    }

    static long binaryOp(ColumnVector lhs, ColumnVector rhs, BinaryOp op, DType outputType) {
        return ColumnVector.binaryOpVV(lhs.getNativeView(), rhs.getNativeView(), op.nativeId, outputType.nativeId);
    }

    static long binaryOp(ColumnVector lhs, Scalar rhs, BinaryOp op, DType outputType) {
        return ColumnVector.binaryOpVS(lhs.getNativeView(), rhs.getScalarHandle(), op.nativeId, outputType.nativeId);
    }

    public Scalar sum() {
        return this.sum(this.type);
    }

    public Scalar sum(DType outType) {
        return this.reduce(AggregateOp.SUM, outType);
    }

    public Scalar min() {
        return this.min(this.type);
    }

    public Scalar min(DType outType) {
        return this.reduce(AggregateOp.MIN, outType);
    }

    public Scalar max() {
        return this.max(this.type);
    }

    public Scalar max(DType outType) {
        return this.reduce(AggregateOp.MAX, outType);
    }

    public Scalar product() {
        return this.product(this.type);
    }

    public Scalar product(DType outType) {
        return this.reduce(AggregateOp.PRODUCT, outType);
    }

    public Scalar sumOfSquares() {
        return this.sumOfSquares(this.type);
    }

    public Scalar sumOfSquares(DType outType) {
        return this.reduce(AggregateOp.SUMOFSQUARES, outType);
    }

    public Scalar mean() {
        DType outType = DType.FLOAT64;
        if (this.type == DType.FLOAT32) {
            outType = this.type;
        }
        return this.mean(outType);
    }

    public Scalar mean(DType outType) {
        return this.reduce(AggregateOp.MEAN, outType);
    }

    public Scalar variance() {
        DType outType = DType.FLOAT64;
        if (this.type == DType.FLOAT32) {
            outType = this.type;
        }
        return this.variance(outType);
    }

    public Scalar variance(DType outType) {
        return this.reduce(AggregateOp.VAR, outType);
    }

    public Scalar standardDeviation() {
        DType outType = DType.FLOAT64;
        if (this.type == DType.FLOAT32) {
            outType = this.type;
        }
        return this.standardDeviation(outType);
    }

    public Scalar standardDeviation(DType outType) {
        return this.reduce(AggregateOp.STD, outType);
    }

    public Scalar any() {
        return this.any(DType.BOOL8);
    }

    public Scalar any(DType outType) {
        return this.reduce(AggregateOp.ANY, outType);
    }

    public Scalar all() {
        return this.all(DType.BOOL8);
    }

    public Scalar all(DType outType) {
        return this.reduce(AggregateOp.ALL, outType);
    }

    public Scalar reduce(AggregateOp op) {
        return this.reduce(op, this.type);
    }

    public Scalar reduce(AggregateOp op, DType outType) {
        return new Scalar(outType, ColumnVector.reduce(this.getNativeView(), op.nativeId, outType.nativeId));
    }

    public ColumnVector quantile(QuantileMethod method, double[] quantiles) {
        return new ColumnVector(ColumnVector.quantile(this.getNativeView(), method.nativeId, quantiles));
    }

    public ColumnVector rollingWindow(AggregateOp op, WindowOptions options) {
        if (!options.getFrameType().equals((Object)WindowOptions.FrameType.ROWS)) {
            throw new IllegalArgumentException("Expected ROWS-based window specification. Unexpected window type: " + (Object)((Object)options.getFrameType()));
        }
        return new ColumnVector(ColumnVector.rollingWindow(this.getNativeView(), options.getMinPeriods(), op.nativeId, options.getPreceding(), options.getFollowing(), options.getPrecedingCol() == null ? 0L : options.getPrecedingCol().getNativeView(), options.getFollowingCol() == null ? 0L : options.getFollowingCol().getNativeView()));
    }

    public ColumnVector not() {
        return this.unaryOp(UnaryOp.NOT);
    }

    public boolean contains(Scalar needle) {
        return ColumnVector.containsScalar(this.getNativeView(), needle.getScalarHandle());
    }

    public ColumnVector contains(ColumnVector needles) {
        return new ColumnVector(ColumnVector.containsVector(this.getNativeView(), needles.getNativeView()));
    }

    public ColumnVector castTo(DType type) {
        if (this.type == type) {
            return this.incRefCount();
        }
        return new ColumnVector(ColumnVector.castTo(this.getNativeView(), type.nativeId));
    }

    public ColumnVector asBytes() {
        return this.castTo(DType.INT8);
    }

    public ColumnVector asShorts() {
        return this.castTo(DType.INT16);
    }

    public ColumnVector asInts() {
        return this.castTo(DType.INT32);
    }

    public ColumnVector asLongs() {
        return this.castTo(DType.INT64);
    }

    public ColumnVector asFloats() {
        return this.castTo(DType.FLOAT32);
    }

    public ColumnVector asDoubles() {
        return this.castTo(DType.FLOAT64);
    }

    public ColumnVector asTimestampDays() {
        if (this.type == DType.STRING) {
            return this.asTimestamp(DType.TIMESTAMP_DAYS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_DAYS);
    }

    public ColumnVector asTimestampDays(String format) {
        assert (this.type == DType.STRING) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_DAYS, format);
    }

    public ColumnVector asTimestampSeconds() {
        if (this.type == DType.STRING) {
            return this.asTimestamp(DType.TIMESTAMP_SECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_SECONDS);
    }

    public ColumnVector asTimestampSeconds(String format) {
        assert (this.type == DType.STRING) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_SECONDS, format);
    }

    public ColumnVector asTimestampMicroseconds() {
        if (this.type == DType.STRING) {
            return this.asTimestamp(DType.TIMESTAMP_MICROSECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_MICROSECONDS);
    }

    public ColumnVector asTimestampMicroseconds(String format) {
        assert (this.type == DType.STRING) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_MICROSECONDS, format);
    }

    public ColumnVector asTimestampMilliseconds() {
        if (this.type == DType.STRING) {
            return this.asTimestamp(DType.TIMESTAMP_MILLISECONDS, "%Y-%m-%dT%H:%M:%SZ%f");
        }
        return this.castTo(DType.TIMESTAMP_MILLISECONDS);
    }

    public ColumnVector asTimestampMilliseconds(String format) {
        assert (this.type == DType.STRING) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_MILLISECONDS, format);
    }

    public ColumnVector asTimestampNanoseconds() {
        if (this.type == DType.STRING) {
            return this.asTimestamp(DType.TIMESTAMP_NANOSECONDS, "%Y-%m-%dT%H:%M:%SZ%9f");
        }
        return this.castTo(DType.TIMESTAMP_NANOSECONDS);
    }

    public ColumnVector asTimestampNanoseconds(String format) {
        assert (this.type == DType.STRING) : "A column of type string is required when using a format string";
        return this.asTimestamp(DType.TIMESTAMP_NANOSECONDS, format);
    }

    public ColumnVector asTimestamp(DType timestampType, String format) {
        assert (this.type == DType.STRING) : "A column of type string is required for .to_timestamp() operation";
        assert (format != null) : "Format string may not be NULL";
        assert (timestampType.isTimestamp()) : "unsupported conversion to non-timestamp DType";
        return new ColumnVector(ColumnVector.stringTimestampToTimestamp(this.getNativeView(), timestampType.nativeId, format));
    }

    public ColumnVector asStrings() {
        switch (this.type) {
            case TIMESTAMP_SECONDS: {
                return this.asStrings("%Y-%m-%d %H:%M:%S");
            }
            case TIMESTAMP_DAYS: {
                return this.asStrings("%Y-%m-%d");
            }
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_NANOSECONDS: {
                return this.asStrings("%Y-%m-%d %H:%M:%S.%f");
            }
        }
        return this.castTo(DType.STRING);
    }

    public ColumnVector asStrings(String format) {
        assert (this.type.isTimestamp()) : "unsupported conversion from non-timestamp DType";
        assert (format != null || format.isEmpty()) : "Format string may not be NULL or empty";
        return new ColumnVector(ColumnVector.timestampToStringTimestamp(this.getNativeView(), format));
    }

    public ColumnVector upper() {
        assert (this.type == DType.STRING) : "A column of type string is required for .upper() operation";
        return new ColumnVector(ColumnVector.upperStrings(this.getNativeView()));
    }

    public ColumnVector lower() {
        assert (this.type == DType.STRING) : "A column of type string is required for .lower() operation";
        return new ColumnVector(ColumnVector.lowerStrings(this.getNativeView()));
    }

    /*
     * Exception decompiling
     */
    public ColumnVector stringConcatenate(ColumnVector[] columns) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ColumnVector stringConcatenate(Scalar separator, Scalar narep, ColumnVector[] columns) {
        assert (columns.length >= 2) : ".stringConcatenate() operation requires at least 2 columns";
        assert (separator != null) : "separator scalar provided may not be null";
        assert (separator.getType() == DType.STRING) : "separator scalar must be a string scalar";
        assert (separator.isValid()) : "separator string scalar may not contain a null value";
        assert (narep != null) : "narep scalar provided may not be null";
        assert (narep.getType() == DType.STRING) : "narep scalar must be a string scalar";
        long size = columns[0].getRowCount();
        long[] column_views = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            assert (columns[i] != null) : "Column vectors passed may not be null";
            assert (columns[i].getType() == DType.STRING) : "All columns must be of type string for .cat() operation";
            assert (columns[i].getRowCount() == size) : "Row count mismatch, all columns must have the same number of rows";
            column_views[i] = columns[i].getNativeView();
        }
        return new ColumnVector(ColumnVector.stringConcatenation(column_views, separator.getScalarHandle(), narep.getScalarHandle()));
    }

    public ColumnVector stringLocate(Scalar substring) {
        return this.stringLocate(substring, 0);
    }

    public ColumnVector stringLocate(Scalar substring, int start) {
        return this.stringLocate(substring, start, -1);
    }

    public ColumnVector stringLocate(Scalar substring, int start, int end) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (substring != null) : "target string may not be null";
        assert (substring.getType() == DType.STRING) : "substring scalar must be a string scalar";
        assert (substring.isValid()) : "substring string scalar may not contain a null value";
        assert (!substring.getJavaString().isEmpty()) : "substring string scalar may not be empty";
        assert (start >= 0) : "start index must be a positive value";
        assert (end >= start || end == -1) : "end index must be -1 or >= the start index";
        return new ColumnVector(ColumnVector.substringLocate(this.getNativeView(), substring.getScalarHandle(), start, end));
    }

    public Table stringSplit(Scalar delimiter) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (delimiter != null) : "delimiter may not be null";
        assert (delimiter.getType() == DType.STRING) : "delimiter must be a string scalar";
        assert (delimiter.isValid()) : "delimiter string scalar may not contain a null value";
        return new Table(ColumnVector.stringSplit(this.getNativeView(), delimiter.getScalarHandle()));
    }

    public Table stringSplit() {
        try (Scalar emptyString = Scalar.fromString("");){
            Table table = this.stringSplit(emptyString);
            return table;
        }
    }

    public ColumnVector substring(int start) {
        return this.substring(start, -1);
    }

    public ColumnVector substring(int start, int end) {
        assert (this.type == DType.STRING) : "column type must be a String";
        return new ColumnVector(ColumnVector.substring(this.getNativeView(), start, end));
    }

    public ColumnVector substring(ColumnVector start, ColumnVector end) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (this.rows == start.getRowCount() && this.rows == end.getRowCount()) : "Number of rows must be equal";
        assert (start.getType() == DType.INT32 && end.getType() == DType.INT32) : "start and end vectors must be of integer type";
        return new ColumnVector(ColumnVector.substringColumn(this.getNativeView(), start.getNativeView(), end.getNativeView()));
    }

    public ColumnVector stringReplace(Scalar target, Scalar replace) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (target != null) : "target string may not be null";
        assert (target.getType() == DType.STRING) : "target string must be a string scalar";
        assert (!target.getJavaString().isEmpty()) : "target scalar may not be empty";
        return new ColumnVector(ColumnVector.stringReplace(this.getNativeView(), target.getScalarHandle(), replace.getScalarHandle()));
    }

    public ColumnVector stringReplaceWithBackrefs(String pattern, String replace) {
        return new ColumnVector(ColumnVector.stringReplaceWithBackrefs(this.getNativeView(), pattern, replace));
    }

    public ColumnVector startsWith(Scalar pattern) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (pattern != null) : "pattern scalar may not be null";
        assert (pattern.getType() == DType.STRING) : "pattern scalar must be a string scalar";
        assert (pattern.isValid()) : "pattern string scalar may not contain a null value";
        assert (!pattern.getJavaString().isEmpty()) : "pattern string scalar may not be empty";
        return new ColumnVector(ColumnVector.stringStartWith(this.getNativeView(), pattern.getScalarHandle()));
    }

    public ColumnVector endsWith(Scalar pattern) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (pattern != null) : "pattern scalar may not be null";
        assert (pattern.getType() == DType.STRING) : "pattern scalar must be a string scalar";
        assert (pattern.isValid()) : "pattern string scalar may not contain a null value";
        assert (!pattern.getJavaString().isEmpty()) : "pattern string scalar may not be empty";
        return new ColumnVector(ColumnVector.stringEndWith(this.getNativeView(), pattern.getScalarHandle()));
    }

    public ColumnVector strip() {
        assert (this.type == DType.STRING) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.BOTH.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public ColumnVector strip(Scalar toStrip) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (toStrip != null) : "toStrip scalar may not be null";
        assert (toStrip.getType() == DType.STRING) : "toStrip must be a string scalar";
        assert (toStrip.isValid()) : "toStrip string scalar may not contain a null value";
        return new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.BOTH.nativeId, toStrip.getScalarHandle()));
    }

    public ColumnVector lstrip() {
        assert (this.type == DType.STRING) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.LEFT.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public ColumnVector lstrip(Scalar toStrip) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (toStrip != null) : "toStrip  Scalar may not be null";
        assert (toStrip.getType() == DType.STRING) : "toStrip must be a string scalar";
        assert (toStrip.isValid()) : "toStrip string scalar may not contain a null value";
        return new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.LEFT.nativeId, toStrip.getScalarHandle()));
    }

    public ColumnVector rstrip() {
        assert (this.type == DType.STRING) : "column type must be a String";
        try (Scalar emptyString = Scalar.fromString("");){
            ColumnVector columnVector = new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.RIGHT.nativeId, emptyString.getScalarHandle()));
            return columnVector;
        }
    }

    public ColumnVector rstrip(Scalar toStrip) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (toStrip != null) : "toStrip  Scalar may not be null";
        assert (toStrip.getType() == DType.STRING) : "toStrip must be a string scalar";
        assert (toStrip.isValid()) : "toStrip string scalar may not contain a null value";
        return new ColumnVector(ColumnVector.stringStrip(this.getNativeView(), StripType.RIGHT.nativeId, toStrip.getScalarHandle()));
    }

    public ColumnVector stringContains(Scalar compString) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (compString != null) : "compString scalar may not be null";
        assert (compString.getType() == DType.STRING) : "compString scalar must be a string scalar";
        assert (compString.isValid()) : "compString string scalar may not contain a null value";
        assert (!compString.getJavaString().isEmpty()) : "compString string scalar may not be empty";
        return new ColumnVector(ColumnVector.stringContains(this.getNativeView(), compString.getScalarHandle()));
    }

    public ColumnVector clamp(Scalar lo, Scalar hi) {
        return new ColumnVector(ColumnVector.clamper(this.getNativeView(), lo.getScalarHandle(), lo.getScalarHandle(), hi.getScalarHandle(), hi.getScalarHandle()));
    }

    public ColumnVector clamp(Scalar lo, Scalar loReplace, Scalar hi, Scalar hiReplace) {
        return new ColumnVector(ColumnVector.clamper(this.getNativeView(), lo.getScalarHandle(), loReplace.getScalarHandle(), hi.getScalarHandle(), hiReplace.getScalarHandle()));
    }

    private static native long clamper(long var0, long var2, long var4, long var6, long var8);

    public ColumnVector matchesRe(String pattern) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        assert (!pattern.isEmpty()) : "pattern string may not be empty";
        return new ColumnVector(ColumnVector.matchesRe(this.getNativeView(), pattern));
    }

    public ColumnVector containsRe(String pattern) {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        assert (!pattern.isEmpty()) : "pattern string may not be empty";
        return new ColumnVector(ColumnVector.containsRe(this.getNativeView(), pattern));
    }

    public Table extractRe(String pattern) throws CudfException {
        assert (this.type == DType.STRING) : "column type must be a String";
        assert (pattern != null) : "pattern may not be null";
        return new Table(ColumnVector.extractRe(this.getNativeView(), pattern));
    }

    static void closeBuffers(MemoryBuffer data, MemoryBuffer valid, MemoryBuffer offsets) {
        Throwable toThrow = null;
        if (data != null) {
            try {
                data.close();
            }
            catch (Throwable t) {
                toThrow = t;
            }
        }
        if (valid != null) {
            try {
                valid.close();
            }
            catch (Throwable t) {
                if (toThrow != null) {
                    toThrow.addSuppressed(t);
                }
                toThrow = t;
            }
        }
        if (offsets != null) {
            try {
                offsets.close();
            }
            catch (Throwable t) {
                if (toThrow != null) {
                    toThrow.addSuppressed(t);
                }
                toThrow = t;
            }
        }
        if (toThrow != null) {
            throw new RuntimeException(toThrow);
        }
    }

    public long getNativeView() {
        return this.offHeap.getViewHandle();
    }

    private static native long stringTimestampToTimestamp(long var0, int var2, String var3);

    private static native long timestampToStringTimestamp(long var0, String var2);

    private static native long substringLocate(long var0, long var2, int var4, int var5);

    private static native long[] stringSplit(long var0, long var2);

    private static native long substring(long var0, int var2, int var3) throws CudfException;

    private static native long substringColumn(long var0, long var2, long var4) throws CudfException;

    private static native long stringReplace(long var0, long var2, long var4) throws CudfException;

    private static native long stringReplaceWithBackrefs(long var0, String var2, String var3) throws CudfException;

    private static native long stringStartWith(long var0, long var2) throws CudfException;

    private static native long stringEndWith(long var0, long var2) throws CudfException;

    private static native long stringStrip(long var0, int var2, long var3) throws CudfException;

    private static native long matchesRe(long var0, String var2) throws CudfException;

    private static native long containsRe(long var0, String var2) throws CudfException;

    private static native long stringContains(long var0, long var2) throws CudfException;

    private static native long[] extractRe(long var0, String var2) throws CudfException;

    private static native long stringConcatenation(long[] var0, long var1, long var3);

    private static native long binaryOpVS(long var0, long var2, int var4, int var5);

    private static native long binaryOpVV(long var0, long var2, int var4, int var5);

    private static native long byteCount(long var0) throws CudfException;

    private static native long castTo(long var0, int var2);

    private static native long[] slice(long var0, int[] var2) throws CudfException;

    private static native long[] split(long var0, int[] var2) throws CudfException;

    private static native long findAndReplaceAll(long var0, long var2, long var4) throws CudfException;

    private static native long lowerStrings(long var0);

    private static native long upperStrings(long var0);

    private static native long quantile(long var0, int var2, double[] var3) throws CudfException;

    private static native long rollingWindow(long var0, int var2, int var3, int var4, int var5, long var6, long var8);

    private static native long nansToNulls(long var0) throws CudfException;

    private static native long charLengths(long var0) throws CudfException;

    private static native long concatenate(long[] var0) throws CudfException;

    private static native long sequence(long var0, long var2, int var4);

    private static native long fromScalar(long var0, int var2) throws CudfException;

    private static native long replaceNulls(long var0, long var2) throws CudfException;

    private static native long ifElseVV(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseVS(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseSV(long var0, long var2, long var4) throws CudfException;

    private static native long ifElseSS(long var0, long var2, long var4) throws CudfException;

    private static native long reduce(long var0, int var2, int var3) throws CudfException;

    private static native long isNullNative(long var0);

    private static native long isNanNative(long var0);

    private static native long isFloat(long var0);

    private static native long isInteger(long var0);

    private static native long isNotNanNative(long var0);

    private static native long isNotNullNative(long var0);

    private static native long unaryOperation(long var0, int var2);

    private static native long year(long var0) throws CudfException;

    private static native long month(long var0) throws CudfException;

    private static native long day(long var0) throws CudfException;

    private static native long hour(long var0) throws CudfException;

    private static native long minute(long var0) throws CudfException;

    private static native long second(long var0) throws CudfException;

    private static native boolean containsScalar(long var0, long var2) throws CudfException;

    private static native long containsVector(long var0, long var2) throws CudfException;

    private static native long transform(long var0, String var2, boolean var3);

    private static native long normalizeNANsAndZeros(long var0) throws CudfException;

    static native long getNativeValidPointerSize(int var0);

    private static native int getNativeTypeId(long var0) throws CudfException;

    private static native int getNativeRowCount(long var0) throws CudfException;

    private static native int getNativeNullCount(long var0) throws CudfException;

    private static native void deleteColumnView(long var0) throws CudfException;

    private static native long[] getNativeDataPointer(long var0) throws CudfException;

    private static native long[] getNativeOffsetsPointer(long var0) throws CudfException;

    private static native long[] getNativeValidPointer(long var0) throws CudfException;

    private static native long makeCudfColumnView(int var0, long var1, long var3, long var5, long var7, int var9, int var10);

    static native void deleteCudfColumn(long var0) throws CudfException;

    private static native int getNativeNullCountColumn(long var0) throws CudfException;

    private static native void setNativeNullCountColumn(long var0, int var2) throws CudfException;

    private static native long getNativeColumnView(long var0) throws CudfException;

    private static native long makeEmptyCudfColumn(int var0);

    public static ColumnVector build(DType type, int rows, Consumer<HostColumnVector.Builder> init) {
        try (HostColumnVector.Builder builder = HostColumnVector.builder(type, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildAndPutOnDevice();
            return columnVector;
        }
    }

    public static ColumnVector build(int rows, long stringBufferSize, Consumer<HostColumnVector.Builder> init) {
        try (HostColumnVector.Builder builder = HostColumnVector.builder(rows, stringBufferSize);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildAndPutOnDevice();
            return columnVector;
        }
    }

    public static ColumnVector boolFromBytes(byte ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromBytes(byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromShorts(short ... values) {
        return ColumnVector.build(DType.INT16, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromInts(int ... values) {
        return ColumnVector.build(DType.INT32, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromLongs(long ... values) {
        return ColumnVector.build(DType.INT64, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromFloats(float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromDoubles(double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector daysFromInts(int ... values) {
        return ColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampMilliSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampMicroSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector timestampNanoSecondsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendArray(values));
    }

    public static ColumnVector fromStrings(String ... values) {
        try (HostColumnVector host = HostColumnVector.fromStrings(values);){
            ColumnVector columnVector = host.copyToDevice();
            return columnVector;
        }
    }

    public static ColumnVector fromBoxedBooleans(Boolean ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedBytes(Byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedShorts(Short ... values) {
        return ColumnVector.build(DType.INT16, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.INT32, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.INT64, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedFloats(Float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedDoubles(Double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampDaysFromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampMilliSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampMicroSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    public static ColumnVector timestampNanoSecondsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (HostColumnVector.Builder b) -> b.appendBoxed(values));
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    protected static final class OffHeapState
    extends MemoryCleaner.Cleaner {
        public static final long UNKNOWN_NULL_COUNT = -1L;
        private long columnHandle;
        private long viewHandle = 0L;
        private BaseDeviceMemoryBuffer data;
        private BaseDeviceMemoryBuffer valid;
        private BaseDeviceMemoryBuffer offsets;

        public OffHeapState(long columnHandle) {
            this.columnHandle = columnHandle;
            this.data = this.getNativeDataPointer();
            this.valid = this.getNativeValidPointer();
            this.offsets = this.getNativeOffsetsPointer();
        }

        public OffHeapState(DType type, int rows, Optional<Long> nullCount, DeviceMemoryBuffer data, DeviceMemoryBuffer valid, DeviceMemoryBuffer offsets) {
            assert (nullCount.isPresent() && nullCount.get() <= Integer.MAX_VALUE || !nullCount.isPresent());
            int nc = nullCount.orElse(-1L).intValue();
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
            if (rows == 0) {
                this.columnHandle = ColumnVector.makeEmptyCudfColumn(type.nativeId);
            } else {
                long cd = data == null ? 0L : data.address;
                long cdSize = data == null ? 0L : data.length;
                long od = offsets == null ? 0L : offsets.address;
                long vd = valid == null ? 0L : valid.address;
                this.viewHandle = ColumnVector.makeCudfColumnView(type.nativeId, cd, cdSize, od, vd, nc, rows);
            }
        }

        public OffHeapState(long viewHandle, DeviceMemoryBuffer contiguousBuffer) {
            assert (viewHandle != 0L);
            this.viewHandle = viewHandle;
            this.data = contiguousBuffer.sliceFrom(this.getNativeDataPointer());
            this.valid = contiguousBuffer.sliceFrom(this.getNativeValidPointer());
            this.offsets = contiguousBuffer.sliceFrom(this.getNativeOffsetsPointer());
        }

        public long getViewHandle() {
            if (this.viewHandle == 0L) {
                this.viewHandle = ColumnVector.getNativeColumnView(this.columnHandle);
            }
            return this.viewHandle;
        }

        public long getNativeRowCount() {
            return ColumnVector.getNativeRowCount(this.getViewHandle());
        }

        public long getNativeNullCount() {
            if (this.viewHandle != 0L) {
                return ColumnVector.getNativeNullCount(this.getViewHandle());
            }
            return ColumnVector.getNativeNullCountColumn(this.columnHandle);
        }

        private void setNativeNullCount(int nullCount) throws CudfException {
            assert (this.viewHandle == 0L) : "Cannot set the null count if a view has already been created";
            assert (this.columnHandle != 0L);
            ColumnVector.setNativeNullCountColumn(this.columnHandle, nullCount);
        }

        private DeviceMemoryBufferView getNativeValidPointer() {
            long[] values = ColumnVector.getNativeValidPointer(this.getViewHandle());
            if (values[0] == 0L) {
                return null;
            }
            return new DeviceMemoryBufferView(values[0], values[1]);
        }

        private DeviceMemoryBufferView getNativeDataPointer() {
            long[] values = ColumnVector.getNativeDataPointer(this.getViewHandle());
            if (values[0] == 0L) {
                return null;
            }
            return new DeviceMemoryBufferView(values[0], values[1]);
        }

        private DeviceMemoryBufferView getNativeOffsetsPointer() {
            long[] values = ColumnVector.getNativeOffsetsPointer(this.getViewHandle());
            if (values[0] == 0L) {
                return null;
            }
            return new DeviceMemoryBufferView(values[0], values[1]);
        }

        public DType getNativeType() {
            return DType.fromNative(ColumnVector.getNativeTypeId(this.getViewHandle()));
        }

        public BaseDeviceMemoryBuffer getData() {
            return this.data;
        }

        public BaseDeviceMemoryBuffer getValid() {
            return this.valid;
        }

        public BaseDeviceMemoryBuffer getOffsets() {
            return this.offsets;
        }

        @Override
        public void noWarnLeakExpected() {
            super.noWarnLeakExpected();
            if (this.valid != null) {
                this.valid.noWarnLeakExpected();
            }
            if (this.data != null) {
                this.data.noWarnLeakExpected();
            }
            if (this.offsets != null) {
                this.offsets.noWarnLeakExpected();
            }
        }

        public String toString() {
            return "(ID: " + this.id + " " + Long.toHexString(this.columnHandle == 0L ? this.viewHandle : this.columnHandle) + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long address = 0L;
            Throwable toThrow = null;
            if (this.viewHandle != 0L) {
                address = this.viewHandle;
                try {
                    ColumnVector.deleteColumnView(this.viewHandle);
                }
                catch (Throwable t) {
                    toThrow = t;
                }
                finally {
                    this.viewHandle = 0L;
                }
                neededCleanup = true;
            }
            if (this.columnHandle != 0L) {
                if (address != 0L) {
                    address = this.columnHandle;
                }
                try {
                    ColumnVector.deleteCudfColumn(this.columnHandle);
                }
                catch (Throwable t) {
                    if (toThrow != null) {
                        toThrow.addSuppressed(t);
                    } else {
                        toThrow = t;
                    }
                }
                finally {
                    this.columnHandle = 0L;
                }
                neededCleanup = true;
            }
            if (this.data != null || this.valid != null || this.offsets != null) {
                try {
                    ColumnVector.closeBuffers(this.data, this.valid, this.offsets);
                }
                catch (Throwable t) {
                    if (toThrow != null) {
                        toThrow.addSuppressed(t);
                    } else {
                        toThrow = t;
                    }
                }
                finally {
                    this.data = null;
                    this.valid = null;
                    this.offsets = null;
                }
                neededCleanup = true;
            }
            if (toThrow != null) {
                throw new RuntimeException(toThrow);
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A DEVICE COLUMN VECTOR WAS LEAKED (ID: " + this.id + " " + Long.toHexString(address) + ")");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.viewHandle == 0L && this.columnHandle == 0L && this.data == null && this.valid == null && this.offsets == null;
        }

        public long getDeviceMemorySize() {
            long size = this.valid != null ? this.valid.getLength() : 0L;
            size += this.offsets != null ? this.offsets.getLength() : 0L;
            return size += this.data != null ? this.data.getLength() : 0L;
        }
    }

    private static enum StripType {
        LEFT(0),
        RIGHT(1),
        BOTH(2);

        final int nativeId;

        private StripType(int nativeId) {
            this.nativeId = nativeId;
        }
    }
}

