/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Table;

public final class ContiguousTable
implements AutoCloseable {
    private Table table;
    private DeviceMemoryBuffer buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContiguousTable fromContiguousColumnViews(long[] columnViewAddresses, long address, long lengthInBytes, long rmmBufferAddress) {
        Table table = null;
        ColumnVector[] vectors = new ColumnVector[columnViewAddresses.length];
        DeviceMemoryBuffer buffer = DeviceMemoryBuffer.fromRmm(address, lengthInBytes, rmmBufferAddress);
        try {
            for (int i = 0; i < vectors.length; ++i) {
                vectors[i] = ColumnVector.fromViewWithContiguousAllocation(columnViewAddresses[i], buffer);
            }
            table = new Table(vectors);
            ContiguousTable ret = new ContiguousTable(table, buffer);
            buffer = null;
            table = null;
            ContiguousTable contiguousTable = ret;
            return contiguousTable;
        }
        finally {
            if (buffer != null) {
                buffer.close();
            }
            for (int i = 0; i < vectors.length; ++i) {
                if (vectors[i] == null) continue;
                vectors[i].close();
            }
            if (table != null) {
                table.close();
            }
        }
    }

    ContiguousTable(Table table, DeviceMemoryBuffer buffer) {
        this.table = table;
        this.buffer = buffer;
    }

    public Table getTable() {
        return this.table;
    }

    public DeviceMemoryBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }
}

