/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.util.EnumSet;

public enum DType {
    EMPTY(0, 0, "NOT SUPPORTED"),
    INT8(1, 1, "byte"),
    INT16(2, 2, "short"),
    INT32(4, 3, "int"),
    INT64(8, 4, "long"),
    FLOAT32(4, 5, "float"),
    FLOAT64(8, 6, "double"),
    BOOL8(1, 7, "bool"),
    TIMESTAMP_DAYS(4, 8, "date32"),
    TIMESTAMP_SECONDS(8, 9, "timestamp[s]"),
    TIMESTAMP_MILLISECONDS(8, 10, "timestamp[ms]"),
    TIMESTAMP_MICROSECONDS(8, 11, "timestamp[us]"),
    TIMESTAMP_NANOSECONDS(8, 12, "timestamp[ns]"),
    STRING(0, 14, "str");

    private static final DType[] D_TYPES;
    final int sizeInBytes;
    final int nativeId;
    final String simpleName;
    private static final EnumSet<DType> TIMESTAMPS;
    private static final EnumSet<DType> TIME_RESOLUTION;

    private DType(int sizeInBytes, int nativeId, String simpleName) {
        this.sizeInBytes = sizeInBytes;
        this.nativeId = nativeId;
        this.simpleName = simpleName;
    }

    public boolean isTimestamp() {
        return TIMESTAMPS.contains((Object)this);
    }

    public boolean hasTimeResolution() {
        return TIME_RESOLUTION.contains((Object)this);
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public static DType fromNative(int nativeId) {
        for (DType type : D_TYPES) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a DType");
    }

    static {
        D_TYPES = DType.values();
        TIMESTAMPS = EnumSet.of(TIMESTAMP_DAYS, TIMESTAMP_SECONDS, TIMESTAMP_MILLISECONDS, TIMESTAMP_MICROSECONDS, TIMESTAMP_NANOSECONDS);
        TIME_RESOLUTION = EnumSet.of(TIMESTAMP_SECONDS, TIMESTAMP_MILLISECONDS, TIMESTAMP_MICROSECONDS, TIMESTAMP_NANOSECONDS);
    }
}

