/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBufferView;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.Rmm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceMemoryBuffer
extends BaseDeviceMemoryBuffer {
    private static final Logger log = LoggerFactory.getLogger(DeviceMemoryBuffer.class);

    static DeviceMemoryBuffer fromRmm(long address, long lengthInBytes, long rmmBufferAddress) {
        return new DeviceMemoryBuffer(address, lengthInBytes, rmmBufferAddress);
    }

    DeviceMemoryBuffer(long address, long lengthInBytes, long rmmBufferAddress) {
        super(address, lengthInBytes, new RmmDeviceBufferCleaner(rmmBufferAddress));
    }

    DeviceMemoryBuffer(long address, long lengthInBytes, Cuda.Stream stream) {
        super(address, lengthInBytes, new DeviceBufferCleaner(address, lengthInBytes, stream));
    }

    private DeviceMemoryBuffer(long address, long lengthInBytes, DeviceMemoryBuffer parent) {
        super(address, lengthInBytes, parent);
    }

    public static DeviceMemoryBuffer allocate(long bytes) {
        return Rmm.alloc(bytes);
    }

    @Override
    public final synchronized DeviceMemoryBuffer slice(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        ++this.refCount;
        this.cleaner.addRef();
        return new DeviceMemoryBuffer(this.getAddress() + offset, len, this);
    }

    final synchronized BaseDeviceMemoryBuffer sliceFrom(DeviceMemoryBufferView view) {
        if (view == null) {
            return null;
        }
        this.addressOutOfBoundsCheck(view.address, view.length, "sliceFrom");
        ++this.refCount;
        this.cleaner.addRef();
        return new DeviceMemoryBuffer(view.address, view.length, this);
    }

    private static final class RmmDeviceBufferCleaner
    extends MemoryBuffer.MemoryBufferCleaner {
        private long rmmBufferAddress;

        RmmDeviceBufferCleaner(long rmmBufferAddress) {
            this.rmmBufferAddress = rmmBufferAddress;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.rmmBufferAddress != 0L) {
                Rmm.freeDeviceBuffer(this.rmmBufferAddress);
                this.rmmBufferAddress = 0L;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("WE LEAKED A DEVICE BUFFER!!!!");
                this.logRefCountDebug("Leaked device buffer");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.rmmBufferAddress == 0L;
        }
    }

    private static final class DeviceBufferCleaner
    extends MemoryBuffer.MemoryBufferCleaner {
        private long address;
        private long lengthInBytes;
        private Cuda.Stream stream;

        DeviceBufferCleaner(long address, long lengthInBytes, Cuda.Stream stream) {
            this.address = address;
            this.lengthInBytes = lengthInBytes;
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            long origAddress = this.address;
            if (this.address != 0L) {
                long s = this.stream == null ? 0L : this.stream.getStream();
                try {
                    Rmm.free(this.address, this.lengthInBytes, s);
                }
                finally {
                    this.address = 0L;
                    this.lengthInBytes = 0L;
                    this.stream = null;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A DEVICE BUFFER WAS LEAKED (ID: " + this.id + " " + Long.toHexString(origAddress) + ")");
                this.logRefCountDebug("Leaked device buffer");
            }
            return neededCleanup;
        }

        @Override
        public boolean isClean() {
            return this.address == 0L;
        }
    }
}

