/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.UnsafeMemoryAccessor;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostColumnVector
implements AutoCloseable {
    static final int OFFSET_SIZE = DType.INT32.sizeInBytes;
    private static final Logger log = LoggerFactory.getLogger(HostColumnVector.class);
    private final OffHeapState offHeap;
    private final DType type;
    private long rows;
    private Optional<Long> nullCount = Optional.empty();
    private int refCount;

    HostColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer) {
        this(type, rows, nullCount, hostDataBuffer, hostValidityBuffer, null);
    }

    HostColumnVector(DType type, long rows, Optional<Long> nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer, HostMemoryBuffer offsetBuffer) {
        if (nullCount.isPresent() && nullCount.get() > 0L && hostValidityBuffer == null) {
            throw new IllegalStateException("Buffer cannot have a nullCount without a validity buffer");
        }
        if (type != DType.STRING) assert (offsetBuffer == null) : "offsets are only supported for STRING";
        this.offHeap = new OffHeapState(hostDataBuffer, hostValidityBuffer, offsetBuffer);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.rows = rows;
        this.nullCount = nullCount;
        this.type = type;
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public void noWarnLeakExpected() {
        this.offHeap.noWarnLeakExpected();
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    public String toString() {
        return "HostColumnVector{rows=" + this.rows + ", type=" + (Object)((Object)this.type) + ", nullCount=" + this.nullCount + ", offHeap=" + this.offHeap + '}';
    }

    public HostColumnVector incRefCount() {
        return this.incRefCountInternal(false);
    }

    private synchronized HostColumnVector incRefCountInternal(boolean isFirstTime) {
        this.offHeap.addRef();
        if (this.refCount <= 0 && !isFirstTime) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Column is already closed");
        }
        ++this.refCount;
        return this;
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getHostMemorySize() {
        return this.offHeap.getHostMemorySize();
    }

    public DType getType() {
        return this.type;
    }

    public long getNullCount() {
        if (!this.nullCount.isPresent()) {
            throw new IllegalStateException("Calculating an unknown null count on the host is not currently supported");
        }
        return this.nullCount.get();
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    public boolean hasValidityVector() {
        return this.offHeap.valid != null;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnVector copyToDevice() {
        if (this.rows == 0L) {
            return new ColumnVector(this.type, 0L, Optional.of(0L), null, null, null);
        }
        MemoryBuffer data = null;
        MemoryBuffer valid = null;
        MemoryBuffer offsets = null;
        try {
            HostMemoryBuffer hoff;
            HostMemoryBuffer hvalid;
            HostMemoryBuffer hdata = this.offHeap.data;
            if (hdata != null) {
                long dataLen = this.rows * (long)this.type.sizeInBytes;
                if (this.type == DType.STRING && (dataLen = this.getEndStringOffset(this.rows - 1L)) == 0L && this.getNullCount() == 0L) {
                    dataLen = 1L;
                }
                data = DeviceMemoryBuffer.allocate(dataLen);
                ((BaseDeviceMemoryBuffer)data).copyFromHostBuffer(hdata, 0L, dataLen);
            }
            if ((hvalid = this.offHeap.valid) != null) {
                long validLen = ColumnVector.getNativeValidPointerSize((int)this.rows);
                valid = DeviceMemoryBuffer.allocate(validLen);
                ((BaseDeviceMemoryBuffer)valid).copyFromHostBuffer(hvalid, 0L, validLen);
            }
            if ((hoff = this.offHeap.offsets) != null) {
                long offsetsLen = (long)OFFSET_SIZE * (this.rows + 1L);
                offsets = DeviceMemoryBuffer.allocate(offsetsLen);
                ((BaseDeviceMemoryBuffer)offsets).copyFromHostBuffer(hoff, 0L, offsetsLen);
            }
            ColumnVector ret = new ColumnVector(this.type, this.rows, this.nullCount, (DeviceMemoryBuffer)data, (DeviceMemoryBuffer)valid, (DeviceMemoryBuffer)offsets);
            data = null;
            valid = null;
            offsets = null;
            ColumnVector columnVector = ret;
            return columnVector;
        }
        finally {
            if (data != null) {
                data.close();
            }
            if (valid != null) {
                valid.close();
            }
            if (offsets != null) {
                offsets.close();
            }
        }
    }

    public boolean isNull(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        if (this.hasValidityVector()) {
            if (this.nullCount.isPresent() && !this.hasNulls()) {
                return false;
            }
            return BitVectorHelper.isNull(this.offHeap.valid, index);
        }
        return false;
    }

    boolean isNullExtendedRange(long index) {
        long maxNullRow = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows) * 8L;
        assert (index >= 0L && index < maxNullRow) : "TEST: index is out of range 0 <= " + index + " < " + maxNullRow;
        if (this.hasValidityVector()) {
            if (this.nullCount.isPresent() && !this.hasNulls()) {
                return false;
            }
            return BitVectorHelper.isNull(this.offHeap.valid, index);
        }
        return false;
    }

    public HostMemoryBuffer getHostBufferFor(BufferType type) {
        HostMemoryBuffer srcBuffer = null;
        switch (type) {
            case VALIDITY: {
                srcBuffer = this.offHeap.valid;
                break;
            }
            case OFFSET: {
                srcBuffer = this.offHeap.offsets;
                break;
            }
            case DATA: {
                srcBuffer = this.offHeap.data;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)type) + " is not a supported buffer type.");
            }
        }
        return srcBuffer;
    }

    void copyHostBufferBytes(byte[] dst, int dstOffset, BufferType src, long srcOffset, int length) {
        assert (dstOffset >= 0);
        assert (srcOffset >= 0L);
        assert (length >= 0);
        assert (dstOffset + length <= dst.length);
        HostMemoryBuffer srcBuffer = this.getHostBufferFor(src);
        assert (srcOffset + (long)length <= srcBuffer.length) : "would copy off end of buffer " + srcOffset + " + " + length + " > " + srcBuffer.length;
        UnsafeMemoryAccessor.getBytes(dst, dstOffset, srcBuffer.getAddress() + srcOffset, length);
    }

    private void assertsForGet(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (!this.isNull(index)) : " value at " + index + " is null";
    }

    public byte getByte(long index) {
        assert (this.type == DType.INT8 || this.type == DType.BOOL8);
        this.assertsForGet(index);
        return this.offHeap.data.getByte(index * (long)this.type.sizeInBytes);
    }

    public final short getShort(long index) {
        assert (this.type == DType.INT16);
        this.assertsForGet(index);
        return this.offHeap.data.getShort(index * (long)this.type.sizeInBytes);
    }

    public final int getInt(long index) {
        assert (this.type == DType.INT32 || this.type == DType.TIMESTAMP_DAYS);
        this.assertsForGet(index);
        return this.offHeap.data.getInt(index * (long)this.type.sizeInBytes);
    }

    long getStartStringOffset(long index) {
        assert (this.type == DType.STRING);
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        return this.offHeap.offsets.getInt(index * 4L);
    }

    long getEndStringOffset(long index) {
        assert (this.type == DType.STRING);
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        return this.offHeap.offsets.getInt((index + 1L) * 4L);
    }

    public final long getLong(long index) {
        assert (this.type == DType.INT64 || this.type.hasTimeResolution());
        this.assertsForGet(index);
        return this.offHeap.data.getLong(index * (long)this.type.sizeInBytes);
    }

    public final float getFloat(long index) {
        assert (this.type == DType.FLOAT32);
        this.assertsForGet(index);
        return this.offHeap.data.getFloat(index * (long)this.type.sizeInBytes);
    }

    public final double getDouble(long index) {
        assert (this.type == DType.FLOAT64);
        this.assertsForGet(index);
        return this.offHeap.data.getDouble(index * (long)this.type.sizeInBytes);
    }

    public final boolean getBoolean(long index) {
        assert (this.type == DType.BOOL8);
        this.assertsForGet(index);
        return this.offHeap.data.getBoolean(index * (long)this.type.sizeInBytes);
    }

    public byte[] getUTF8(long index) {
        assert (this.type == DType.STRING);
        this.assertsForGet(index);
        int start = this.offHeap.offsets.getInt(index * (long)OFFSET_SIZE);
        int size = this.offHeap.offsets.getInt((index + 1L) * (long)OFFSET_SIZE) - start;
        byte[] rawData = new byte[size];
        if (size > 0) {
            this.offHeap.data.getBytes(rawData, 0L, start, size);
        }
        return rawData;
    }

    public String getJavaString(long index) {
        byte[] rawData = this.getUTF8(index);
        return new String(rawData, StandardCharsets.UTF_8);
    }

    public static Builder builder(DType type, int rows) {
        return new Builder(type, rows, 0L);
    }

    public static Builder builder(int rows, long stringBufferSize) {
        return new Builder(DType.STRING, rows, stringBufferSize);
    }

    public static HostColumnVector build(DType type, int rows, Consumer<Builder> init) {
        try (Builder builder = HostColumnVector.builder(type, rows);){
            init.accept(builder);
            HostColumnVector hostColumnVector = builder.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector build(int rows, long stringBufferSize, Consumer<Builder> init) {
        try (Builder builder = HostColumnVector.builder(rows, stringBufferSize);){
            init.accept(builder);
            HostColumnVector hostColumnVector = builder.build();
            return hostColumnVector;
        }
    }

    public static HostColumnVector boolFromBytes(byte ... values) {
        return HostColumnVector.build(DType.BOOL8, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromBytes(byte ... values) {
        return HostColumnVector.build(DType.INT8, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromShorts(short ... values) {
        return HostColumnVector.build(DType.INT16, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromInts(int ... values) {
        return HostColumnVector.build(DType.INT32, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromLongs(long ... values) {
        return HostColumnVector.build(DType.INT64, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromFloats(float ... values) {
        return HostColumnVector.build(DType.FLOAT32, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromDoubles(double ... values) {
        return HostColumnVector.build(DType.FLOAT64, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector daysFromInts(int ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampMilliSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampMicroSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector timestampNanoSecondsFromLongs(long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (Builder b) -> b.appendArray(values));
    }

    public static HostColumnVector fromStrings(String ... values) {
        int rows = values.length;
        long nullCount = 0L;
        long bufferSize = 0L;
        for (String s : values) {
            if (s == null) {
                ++nullCount;
                continue;
            }
            bufferSize += (long)s.getBytes(StandardCharsets.UTF_8).length;
        }
        if (nullCount > 0L) {
            return HostColumnVector.build(rows, bufferSize, (Builder b) -> b.appendBoxed(values));
        }
        return HostColumnVector.build(rows, bufferSize, (Builder b) -> {
            for (String s : values) {
                b.append(s);
            }
        });
    }

    public static HostColumnVector fromBoxedBooleans(Boolean ... values) {
        return HostColumnVector.build(DType.BOOL8, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedBytes(Byte ... values) {
        return HostColumnVector.build(DType.INT8, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedShorts(Short ... values) {
        return HostColumnVector.build(DType.INT16, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedInts(Integer ... values) {
        return HostColumnVector.build(DType.INT32, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.INT64, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedFloats(Float ... values) {
        return HostColumnVector.build(DType.FLOAT32, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector fromBoxedDoubles(Double ... values) {
        return HostColumnVector.build(DType.FLOAT64, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampDaysFromBoxedInts(Integer ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_DAYS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_SECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampMilliSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MILLISECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampMicroSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_MICROSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    public static HostColumnVector timestampNanoSecondsFromBoxedLongs(Long ... values) {
        return HostColumnVector.build(DType.TIMESTAMP_NANOSECONDS, values.length, (Builder b) -> b.appendBoxed(values));
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class Builder
    implements AutoCloseable {
        private final long rows;
        private final DType type;
        private HostMemoryBuffer data;
        private HostMemoryBuffer valid;
        private HostMemoryBuffer offsets;
        private long currentIndex = 0L;
        private long nullCount;
        private int currentStringByteIndex = 0;
        private boolean built;

        Builder(DType type, long rows, long stringBufferSize) {
            this.type = type;
            this.rows = rows;
            if (type == DType.STRING) {
                if (stringBufferSize <= 0L) {
                    stringBufferSize = 1L;
                }
                this.data = HostMemoryBuffer.allocate(stringBufferSize);
                this.offsets = HostMemoryBuffer.allocate((rows + 1L) * (long)OFFSET_SIZE);
                this.offsets.setInt(0L, 0);
            } else {
                this.data = HostMemoryBuffer.allocate(rows * (long)type.sizeInBytes);
            }
        }

        Builder(DType type, long rows, HostMemoryBuffer testData, HostMemoryBuffer testValid, HostMemoryBuffer testOffsets) {
            this.type = type;
            this.rows = rows;
            this.data = testData;
            this.valid = testValid;
        }

        public final Builder append(boolean value) {
            assert (this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value ? (byte)1 : 0);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value) {
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value, long count) {
            assert (count + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setMemory(this.currentIndex * (long)this.type.sizeInBytes, count, value);
            this.currentIndex += count;
            return this;
        }

        public final Builder append(short value) {
            assert (this.type == DType.INT16);
            assert (this.currentIndex < this.rows);
            this.data.setShort(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(int value) {
            assert (this.type == DType.INT32 || this.type == DType.TIMESTAMP_DAYS);
            assert (this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(long value) {
            assert (this.type == DType.INT64 || this.type == DType.TIMESTAMP_MILLISECONDS || this.type == DType.TIMESTAMP_MICROSECONDS || this.type == DType.TIMESTAMP_NANOSECONDS || this.type == DType.TIMESTAMP_SECONDS);
            assert (this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(float value) {
            assert (this.type == DType.FLOAT32);
            assert (this.currentIndex < this.rows);
            this.data.setFloat(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(double value) {
            assert (this.type == DType.FLOAT64);
            assert (this.currentIndex < this.rows);
            this.data.setDouble(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public Builder append(String value) {
            assert (value != null) : "appendNull must be used to append null strings";
            return this.appendUTF8String(value.getBytes(StandardCharsets.UTF_8));
        }

        public Builder appendUTF8String(byte[] value) {
            return this.appendUTF8String(value, 0, value.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder appendUTF8String(byte[] value, int offset, int length) {
            long oldLen;
            long newLen;
            assert (value != null) : "appendNull must be used to append null strings";
            assert (offset >= 0);
            assert (length >= 0);
            assert (value.length + offset <= length);
            assert (this.type == DType.STRING);
            assert (this.currentIndex < this.rows);
            for (newLen = oldLen = this.data.getLength(); (long)(this.currentStringByteIndex + length) > newLen; newLen *= 2L) {
            }
            if (newLen > Integer.MAX_VALUE) {
                throw new IllegalStateException("A string buffer is not supported over 2GB in size");
            }
            if (newLen != oldLen) {
                try (HostMemoryBuffer newData = HostMemoryBuffer.allocate(newLen);){
                    newData.copyFromHostBuffer(0L, this.data, 0L, this.currentStringByteIndex);
                    this.data.close();
                    this.data = newData;
                    newData = null;
                }
            }
            if (length > 0) {
                this.data.setBytes(this.currentStringByteIndex, value, offset, length);
            }
            this.currentStringByteIndex += length;
            ++this.currentIndex;
            this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            return this;
        }

        public Builder appendArray(byte ... values) {
            assert ((long)values.length + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setBytes(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(short ... values) {
            assert (this.type == DType.INT16);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setShorts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(int ... values) {
            assert (this.type == DType.INT32 || this.type == DType.TIMESTAMP_DAYS);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setInts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(long ... values) {
            assert (this.type == DType.INT64 || this.type == DType.TIMESTAMP_MILLISECONDS || this.type == DType.TIMESTAMP_MICROSECONDS || this.type == DType.TIMESTAMP_NANOSECONDS || this.type == DType.TIMESTAMP_SECONDS);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setLongs(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(float ... values) {
            assert (this.type == DType.FLOAT32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setFloats(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(double ... values) {
            assert (this.type == DType.FLOAT64);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setDoubles(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendBoxed(Byte ... values) throws IndexOutOfBoundsException {
            for (Byte b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Boolean ... values) throws IndexOutOfBoundsException {
            for (Boolean b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b != false ? (byte)1 : 0);
            }
            return this;
        }

        public final Builder appendBoxed(Short ... values) throws IndexOutOfBoundsException {
            for (Short b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Integer ... values) throws IndexOutOfBoundsException {
            for (Integer b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Long ... values) throws IndexOutOfBoundsException {
            for (Long b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Float ... values) throws IndexOutOfBoundsException {
            for (Float b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b.floatValue());
            }
            return this;
        }

        public final Builder appendBoxed(Double ... values) throws IndexOutOfBoundsException {
            for (Double b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(String ... values) throws IndexOutOfBoundsException {
            for (String b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder append(HostColumnVector columnVector) {
            assert (columnVector.rows <= this.rows - this.currentIndex);
            assert (columnVector.type == this.type);
            if (this.type == DType.STRING) {
                throw new UnsupportedOperationException("Appending a string column vector client side is not currently supported");
            }
            this.data.copyFromHostBuffer(this.currentIndex * (long)this.type.sizeInBytes, ((HostColumnVector)columnVector).offHeap.data, 0L, columnVector.getRowCount() * (long)this.type.sizeInBytes);
            long otherNc = columnVector.getNullCount();
            if (otherNc != 0L) {
                if (this.valid == null) {
                    this.allocateBitmaskAndSetDefaultValues();
                }
                BitVectorHelper.append(((HostColumnVector)columnVector).offHeap.valid, this.valid, this.currentIndex, columnVector.rows);
                this.nullCount += otherNc;
            }
            this.currentIndex += columnVector.rows;
            return this;
        }

        private void allocateBitmaskAndSetDefaultValues() {
            long bitmaskSize = ColumnVector.getNativeValidPointerSize((int)this.rows);
            this.valid = HostMemoryBuffer.allocate(bitmaskSize);
            this.valid.setMemory(0L, bitmaskSize, (byte)-1);
        }

        public final Builder appendNull() {
            this.setNullAt(this.currentIndex);
            ++this.currentIndex;
            if (this.type == DType.STRING) {
                this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            }
            return this;
        }

        public final Builder setNullAt(long index) {
            assert (index < this.rows);
            if (this.valid == null) {
                this.allocateBitmaskAndSetDefaultValues();
            }
            this.nullCount += (long)BitVectorHelper.setNullAt(this.valid, index);
            return this;
        }

        public final HostColumnVector build() {
            if (this.built) {
                throw new IllegalStateException("Cannot reuse a builder.");
            }
            HostColumnVector cv = new HostColumnVector(this.type, this.currentIndex, Optional.of(this.nullCount), this.data, this.valid, this.offsets);
            this.built = true;
            return cv;
        }

        public final ColumnVector buildAndPutOnDevice() {
            try (HostColumnVector tmp = this.build();){
                ColumnVector columnVector = tmp.copyToDevice();
                return columnVector;
            }
        }

        @Override
        public final void close() {
            if (!this.built) {
                this.data.close();
                this.data = null;
                if (this.valid != null) {
                    this.valid.close();
                    this.valid = null;
                }
                if (this.offsets != null) {
                    this.offsets.close();
                    this.offsets = null;
                }
                this.built = true;
            }
        }

        public String toString() {
            return "Builder{data=" + this.data + "type=" + (Object)((Object)this.type) + ", valid=" + this.valid + ", currentIndex=" + this.currentIndex + ", nullCount=" + this.nullCount + ", rows=" + this.rows + ", built=" + this.built + '}';
        }
    }

    protected static final class OffHeapState
    extends MemoryCleaner.Cleaner {
        public HostMemoryBuffer data;
        public HostMemoryBuffer valid;
        public HostMemoryBuffer offsets;

        OffHeapState(HostMemoryBuffer data, HostMemoryBuffer valid, HostMemoryBuffer offsets) {
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.data != null || this.valid != null || this.offsets != null) {
                try {
                    ColumnVector.closeBuffers(this.data, this.valid, this.offsets);
                }
                finally {
                    this.data = null;
                    this.valid = null;
                    this.offsets = null;
                }
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("A HOST COLUMN VECTOR WAS LEAKED (ID: " + this.id + ")");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }

        @Override
        public void noWarnLeakExpected() {
            super.noWarnLeakExpected();
            if (this.data != null) {
                this.data.noWarnLeakExpected();
            }
            if (this.valid != null) {
                this.valid.noWarnLeakExpected();
            }
            if (this.offsets != null) {
                this.offsets.noWarnLeakExpected();
            }
        }

        @Override
        public boolean isClean() {
            return this.data == null && this.valid == null && this.offsets == null;
        }

        public long getHostMemorySize() {
            long total = 0L;
            if (this.valid != null) {
                total += this.valid.length;
            }
            if (this.data != null) {
                total += this.data.length;
            }
            if (this.offsets != null) {
                total += this.offsets.length;
            }
            return total;
        }

        public String toString() {
            return "(ID: " + this.id + ")";
        }
    }
}

