/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.BufferType;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.Table;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

public class JCudfSerialization {
    private static final int SER_FORMAT_MAGIC_NUMBER = 1129661510;
    private static final short VERSION_NUMBER = 0;

    private static long padFor64byteAlignment(long orig) {
        return (orig + 63L) / 64L * 64L;
    }

    private static long padFor64byteAlignment(DataWriter out, long bytes) throws IOException {
        long paddedBytes = JCudfSerialization.padFor64byteAlignment(bytes);
        while (paddedBytes > bytes) {
            out.writeByte((byte)0);
            ++bytes;
        }
        return paddedBytes;
    }

    private static long getRawStringDataLength(ColumnBufferProvider column, long rowOffset, long numRows) {
        if (numRows <= 0L) {
            return 0L;
        }
        long start = column.getStartStringOffset(rowOffset);
        long end = column.getEndStringOffset(rowOffset + numRows - 1L);
        return end - start;
    }

    private static long getSlicedSerializedDataSizeInBytes(ColumnBufferProvider[] columns, long rowOffset, long numRows) {
        long totalDataSize = 0L;
        for (ColumnBufferProvider column : columns) {
            DType type = column.getType();
            if (column.getNullCount() > 0L) {
                totalDataSize += JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
            }
            if (type == DType.STRING) {
                if (numRows <= 0L) continue;
                totalDataSize += JCudfSerialization.padFor64byteAlignment((numRows + 1L) * 4L);
                totalDataSize += JCudfSerialization.padFor64byteAlignment(JCudfSerialization.getRawStringDataLength(column, rowOffset, numRows));
                continue;
            }
            totalDataSize += JCudfSerialization.padFor64byteAlignment((long)column.getType().sizeInBytes * numRows);
        }
        return totalDataSize;
    }

    private static long getConcatedSerializedDataSizeInBytes(int numColumns, long[] nullCounts, int numRows, DType[] types, ColumnBufferProvider[][] columnsForEachBatch) {
        long totalDataSize = 0L;
        for (int col = 0; col < numColumns; ++col) {
            DType type = types[col];
            if (nullCounts[col] > 0L) {
                totalDataSize += JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
            }
            if (type == DType.STRING) {
                if (numRows > 0) {
                    totalDataSize += JCudfSerialization.padFor64byteAlignment((numRows + 1) * 4);
                }
                long stringDataLen = 0L;
                for (int batchNumber = 0; batchNumber < columnsForEachBatch.length; ++batchNumber) {
                    ColumnBufferProvider provider = columnsForEachBatch[batchNumber][col];
                    long numRowsInSubColumn = provider.getRowCount();
                    stringDataLen += JCudfSerialization.getRawStringDataLength(provider, 0L, numRowsInSubColumn);
                }
                totalDataSize += JCudfSerialization.padFor64byteAlignment(stringDataLen);
                continue;
            }
            totalDataSize += JCudfSerialization.padFor64byteAlignment(types[col].sizeInBytes * numRows);
        }
        return totalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSerializedSizeInBytes(HostColumnVector[] columns, long rowOffset, long numRows) {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns, false);
        try {
            long l = JCudfSerialization.getSlicedSerializedDataSizeInBytes(providers, rowOffset, numRows) + 12L + 2L;
            return l;
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    static ColumnOffsets[] buildIndex(SerializedTableHeader header, HostMemoryBuffer buffer) {
        long bufferOffset = 0L;
        DType[] dataTypes = header.types;
        int numColumns = dataTypes.length;
        long[] nullCounts = header.nullCounts;
        long numRows = header.getNumRows();
        ColumnOffsets[] ret = new ColumnOffsets[numColumns];
        for (int column = 0; column < numColumns; ++column) {
            DType type = dataTypes[column];
            long nullCount = nullCounts[column];
            long validity = 0L;
            long validityLen = 0L;
            long offsets = 0L;
            long offsetsLen = 0L;
            long data = 0L;
            long dataLen = 0L;
            if (nullCount > 0L) {
                validityLen = JCudfSerialization.padFor64byteAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
                validity = bufferOffset;
                bufferOffset += validityLen;
            }
            if (type == DType.STRING) {
                if (numRows > 0L) {
                    offsetsLen = (numRows + 1L) * 4L;
                    offsets = bufferOffset;
                    int startStringOffset = buffer.getInt(bufferOffset);
                    int endStringOffset = buffer.getInt(bufferOffset + numRows * 4L);
                    dataLen = endStringOffset - startStringOffset;
                    data = bufferOffset += JCudfSerialization.padFor64byteAlignment(offsetsLen);
                    bufferOffset += JCudfSerialization.padFor64byteAlignment(dataLen);
                }
            } else {
                dataLen = (long)type.sizeInBytes * numRows;
                data = bufferOffset;
                bufferOffset += JCudfSerialization.padFor64byteAlignment(dataLen);
            }
            ret[column] = new ColumnOffsets(validity, validityLen, offsets, offsetsLen, data, dataLen);
        }
        return ret;
    }

    private static void closeAll(ColumnBufferProvider[] providers) {
        for (int i = 0; i < providers.length; ++i) {
            providers[i].close();
        }
    }

    private static void closeAll(ColumnBufferProvider[][] providers) {
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i] == null) continue;
            JCudfSerialization.closeAll(providers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnBufferProvider[] providersFrom(ColumnVector[] columns) {
        ColumnBufferProvider[] columnBufferProviderArray;
        block6: {
            HostColumnVector[] onHost = new HostColumnVector[columns.length];
            boolean success = false;
            try {
                for (int i = 0; i < columns.length; ++i) {
                    onHost[i] = columns[i].copyToHost();
                }
                ColumnBufferProvider[] ret = JCudfSerialization.providersFrom(onHost, true);
                success = true;
                columnBufferProviderArray = ret;
                if (success) break block6;
            }
            catch (Throwable throwable) {
                if (!success) {
                    for (int i = 0; i < onHost.length; ++i) {
                        if (onHost[i] == null) continue;
                        onHost[i].close();
                        onHost[i] = null;
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < onHost.length; ++i) {
                if (onHost[i] == null) continue;
                onHost[i].close();
                onHost[i] = null;
            }
        }
        return columnBufferProviderArray;
    }

    private static ColumnBufferProvider[] providersFrom(HostColumnVector[] columns, boolean closeAtEnd) {
        ColumnBufferProvider[] providers = new ColumnBufferProvider[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            providers[i] = new ColumnProvider(columns[i], closeAtEnd);
        }
        return providers;
    }

    private static ColumnBufferProvider[][] providersFrom(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) {
        int validCount = 0;
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i].numRows > 0) {
                ++validCount;
                continue;
            }
            assert (headers[i].dataLen == 0L);
        }
        if (validCount > 0 && validCount < headers.length) {
            SerializedTableHeader[] filteredHeaders = new SerializedTableHeader[validCount];
            HostMemoryBuffer[] filteredBuffers = new HostMemoryBuffer[validCount];
            int at = 0;
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].numRows <= 0) continue;
                filteredHeaders[at] = headers[i];
                filteredBuffers[at] = dataBuffers[i];
                ++at;
            }
            headers = filteredHeaders;
            dataBuffers = filteredBuffers;
        }
        ColumnBufferProvider[][] ret = new ColumnBufferProvider[headers.length][];
        for (int batchNum = 0; batchNum < headers.length; ++batchNum) {
            SerializedTableHeader header = headers[batchNum];
            HostMemoryBuffer dataBuffer = dataBuffers[batchNum];
            ColumnOffsets[] offsets = JCudfSerialization.buildIndex(header, dataBuffer);
            ColumnBufferProvider[] parts = new ColumnBufferProvider[offsets.length];
            for (int columnIndex = 0; columnIndex < offsets.length; ++columnIndex) {
                parts[columnIndex] = new BufferOffsetProvider(header, columnIndex, offsets[columnIndex], dataBuffer);
            }
            ret[batchNum] = parts;
        }
        return ret;
    }

    private static SerializedTableHeader calcHeader(ColumnBufferProvider[] columns, long rowOffset, int numRows) {
        DType[] types = new DType[columns.length];
        long[] nullCount = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            types[i] = columns[i].getType();
            nullCount[i] = columns[i].getNullCount();
        }
        long dataLength = JCudfSerialization.getSlicedSerializedDataSizeInBytes(columns, rowOffset, numRows);
        return new SerializedTableHeader(numRows, types, nullCount, dataLength);
    }

    private static SerializedTableHeader calcEmptyHeader(int numRows) {
        return new SerializedTableHeader(numRows, null, null, 0L);
    }

    private static SerializedTableHeader calcConcatedHeader(ColumnBufferProvider[][] columnsForEachBatch) {
        long[] nullCounts;
        DType[] types;
        int numColumns = 0;
        long numRows = 0L;
        if (columnsForEachBatch.length > 0) {
            ColumnBufferProvider[] providers = columnsForEachBatch[0];
            numColumns = providers.length;
            types = new DType[numColumns];
            nullCounts = new long[numColumns];
            for (int i = 0; i < providers.length; ++i) {
                types[i] = providers[i].getType();
                nullCounts[i] = providers[i].getNullCount();
            }
            if (numColumns > 0) {
                numRows = providers[0].getRowCount();
            }
        } else {
            types = new DType[]{};
            nullCounts = new long[]{};
        }
        for (int batchNum = 1; batchNum < columnsForEachBatch.length; ++batchNum) {
            ColumnBufferProvider[] providers = columnsForEachBatch[batchNum];
            if (providers.length != numColumns) {
                throw new IllegalArgumentException("The number of columns did not match " + batchNum + " " + providers.length + " != " + numColumns);
            }
            for (int col = 0; col < numColumns; ++col) {
                if (providers[col].getType() != types[col]) {
                    throw new IllegalArgumentException("Type mismatch for column " + col);
                }
                int n = col;
                nullCounts[n] = nullCounts[n] + providers[col].getNullCount();
            }
            if (numColumns <= 0) continue;
            numRows += providers[0].getRowCount();
        }
        if (numRows > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("CANNOT BUILD A BATCH LARGER THAN 2147483647 rows");
        }
        long totalDataSize = JCudfSerialization.getConcatedSerializedDataSizeInBytes(numColumns, nullCounts, (int)numRows, types, columnsForEachBatch);
        return new SerializedTableHeader((int)numRows, types, nullCounts, totalDataSize);
    }

    private static DataWriter writerFrom(OutputStream out) {
        if (!(out instanceof DataOutputStream)) {
            out = new DataOutputStream(new BufferedOutputStream(out));
        }
        return new DataOutputStreamWriter((DataOutputStream)out);
    }

    private static DataWriter writerFrom(HostMemoryBuffer buffer) {
        return new HostDataWriter(buffer);
    }

    private static long copySlicedAndPad(DataWriter out, ColumnBufferProvider column, BufferType buffer, long offset, long length) throws IOException {
        out.copyDataFrom(column, buffer, offset, length);
        return JCudfSerialization.padFor64byteAlignment(out, length);
    }

    private static int copyPartialValidity(byte[] dest, int destBitOffset, ColumnBufferProvider provider, int srcBitOffset, int lengthBits) {
        HostMemoryBuffer src = provider.getHostBufferFor(BufferType.VALIDITY);
        long baseSrcByteOffset = provider.getBufferStartOffset(BufferType.VALIDITY);
        int destStartBytes = destBitOffset / 8;
        int destStartBitOffset = destBitOffset % 8;
        long srcStartBytes = baseSrcByteOffset + (long)(srcBitOffset / 8);
        int srcStartBitOffset = srcBitOffset % 8;
        int availableDestBits = dest.length * 8 - destBitOffset;
        int bitsToCopy = Math.min(lengthBits, availableDestBits);
        int lastIndex = (bitsToCopy + destStartBitOffset + 7) / 8;
        int allBitsSet = -1;
        byte firstSrcMask = (byte)(allBitsSet << destStartBitOffset);
        int srcShift = destStartBitOffset - srcStartBitOffset;
        if (srcShift > 0) {
            byte current = src.getByte(srcStartBytes);
            byte result = (byte)(current << srcShift);
            dest[destStartBytes] = result = (byte)(result | dest[destStartBytes] & ~firstSrcMask);
            byte previous = current;
            for (int index = 1; index < lastIndex; ++index) {
                current = src.getByte((long)index + srcStartBytes);
                result = (byte)(current << srcShift);
                dest[index + destStartBytes] = result = (byte)(result | (previous & 0xFF) >>> 8 - srcShift);
                previous = current;
            }
            return bitsToCopy;
        }
        if (srcShift < 0) {
            srcShift = -srcShift;
            byte result = src.getByte(srcStartBytes);
            result = (byte)((result & 0xFF) >>> srcShift);
            byte next = 0;
            if (srcStartBytes + 1L < src.length) {
                next = src.getByte(srcStartBytes + 1L);
            }
            result = (byte)(result | (byte)(next << 8 - srcShift));
            result = (byte)(result & firstSrcMask);
            dest[destStartBytes] = result = (byte)(result | dest[destStartBytes] & ~firstSrcMask);
            for (int index = 1; index < lastIndex - 1; ++index) {
                result = next;
                result = (byte)((result & 0xFF) >>> srcShift);
                next = src.getByte(srcStartBytes + (long)index + 1L);
                dest[index + destStartBytes] = result = (byte)(result | (byte)(next << 8 - srcShift));
            }
            int idx = lastIndex - 1;
            if (idx > 0) {
                result = next;
                result = (byte)((result & 0xFF) >>> srcShift);
                next = 0;
                if (srcStartBytes + (long)idx + 1L < src.length) {
                    next = src.getByte(srcStartBytes + (long)idx + 1L);
                }
                dest[idx + destStartBytes] = result = (byte)(result | (byte)(next << 8 - srcShift));
            }
            return bitsToCopy;
        }
        src.getBytes(dest, destStartBytes, srcStartBytes, (bitsToCopy + 7) / 8);
        return bitsToCopy;
    }

    static long copySlicedValidity(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        long validityLen = BitVectorHelper.getValidityLengthInBytes(numRows);
        long byteOffset = rowOffset / 8L;
        long bytesLeft = validityLen;
        int lshift = (int)rowOffset % 8;
        if (lshift == 0) {
            out.copyDataFrom(column, BufferType.VALIDITY, byteOffset, bytesLeft);
        } else {
            byte[] arrayBuffer = new byte[131072];
            int rowsStoredInArray = 0;
            int rowsLeftInBatch = (int)numRows;
            int validityBitOffset = (int)rowOffset;
            while (rowsLeftInBatch > 0) {
                int rowsStoredJustNow = JCudfSerialization.copyPartialValidity(arrayBuffer, rowsStoredInArray, column, validityBitOffset, rowsLeftInBatch);
                assert (rowsStoredJustNow > 0);
                rowsLeftInBatch -= rowsStoredJustNow;
                validityBitOffset += rowsStoredJustNow;
                if ((rowsStoredInArray += rowsStoredJustNow) != arrayBuffer.length * 8) continue;
                out.write(arrayBuffer, 0, arrayBuffer.length);
                rowsStoredInArray = 0;
            }
            if (rowsStoredInArray > 0) {
                out.write(arrayBuffer, 0, (rowsStoredInArray + 7) / 8);
            }
        }
        return JCudfSerialization.padFor64byteAlignment(out, validityLen);
    }

    static int fillValidity(byte[] dest, int destBitOffset, int lengthBits) {
        int destStartBytes = destBitOffset / 8;
        int destStartBits = destBitOffset % 8;
        long lengthBytes = BitVectorHelper.getValidityLengthInBytes(lengthBits);
        int rshift = destStartBits;
        int totalCopied = 0;
        if (rshift != 0) {
            int n = destStartBytes++;
            dest[n] = (byte)(dest[n] | 255 << destStartBits);
            totalCopied = 8 - destStartBits;
            destStartBits = 0;
        }
        int amountToCopyBytes = (int)Math.min(lengthBytes, (long)(dest.length - destStartBytes));
        for (int i = 0; i < amountToCopyBytes; ++i) {
            dest[i + destStartBytes] = -1;
        }
        return Math.min(totalCopied += amountToCopyBytes * 8, lengthBits);
    }

    private static long concatValidity(DataWriter out, int columnIndex, int numRows, ColumnBufferProvider[][] providers) throws IOException {
        long validityLen = BitVectorHelper.getValidityLengthInBytes(numRows);
        byte[] arrayBuffer = new byte[131072];
        int rowsStoredInArray = 0;
        for (int batchIndex = 0; batchIndex < providers.length; ++batchIndex) {
            ColumnBufferProvider provider = providers[batchIndex][columnIndex];
            int rowsLeftInBatch = (int)provider.getRowCount();
            int validityBitOffset = 0;
            while (rowsLeftInBatch > 0) {
                int rowsStoredJustNow = provider.getNullCount() > 0L ? JCudfSerialization.copyPartialValidity(arrayBuffer, rowsStoredInArray, provider, validityBitOffset, rowsLeftInBatch) : JCudfSerialization.fillValidity(arrayBuffer, rowsStoredInArray, rowsLeftInBatch);
                assert (rowsStoredJustNow > 0);
                assert (rowsStoredJustNow <= rowsLeftInBatch);
                rowsLeftInBatch -= rowsStoredJustNow;
                validityBitOffset += rowsStoredJustNow;
                if ((rowsStoredInArray += rowsStoredJustNow) != arrayBuffer.length * 8) continue;
                out.write(arrayBuffer, 0, arrayBuffer.length);
                rowsStoredInArray = 0;
            }
        }
        if (rowsStoredInArray > 0) {
            int len = (rowsStoredInArray + 7) / 8;
            out.write(arrayBuffer, 0, len);
        }
        return JCudfSerialization.padFor64byteAlignment(out, validityLen);
    }

    private static long copySlicedStringData(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        if (numRows > 0L) {
            long startByteOffset = column.getStartStringOffset(rowOffset);
            long endByteOffset = column.getEndStringOffset(rowOffset + numRows - 1L);
            long bytesToCopy = endByteOffset - startByteOffset;
            long srcOffset = startByteOffset;
            return JCudfSerialization.copySlicedAndPad(out, column, BufferType.DATA, srcOffset, bytesToCopy);
        }
        return 0L;
    }

    private static void copyConcateStringData(DataWriter out, int columnIndex, int[] dataLengths, ColumnBufferProvider[][] providers) throws IOException {
        long totalCopied = 0L;
        for (int batchIndex = 0; batchIndex < providers.length; ++batchIndex) {
            ColumnBufferProvider provider = providers[batchIndex][columnIndex];
            HostMemoryBuffer dataBuffer = provider.getHostBufferFor(BufferType.DATA);
            long currentOffset = provider.getBufferStartOffset(BufferType.DATA);
            int dataLeft = dataLengths[batchIndex];
            out.copyDataFrom(dataBuffer, currentOffset, dataLeft);
            totalCopied += (long)dataLeft;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
    }

    private static long copySlicedOffsets(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        if (numRows <= 0L) {
            return 0L;
        }
        long bytesToCopy = (numRows + 1L) * 4L;
        long srcOffset = rowOffset * 4L;
        if (rowOffset == 0L) {
            return JCudfSerialization.copySlicedAndPad(out, column, BufferType.OFFSET, srcOffset, bytesToCopy);
        }
        HostMemoryBuffer buff = column.getHostBufferFor(BufferType.OFFSET);
        long startOffset = column.getBufferStartOffset(BufferType.OFFSET) + srcOffset;
        if (bytesToCopy >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Copy is too large, need to do chunked copy");
        }
        ByteBuffer bb = buff.asByteBuffer(startOffset, (int)bytesToCopy);
        int start = bb.getInt();
        out.writeIntNativeOrder(0);
        long total = 4L;
        int i = 1;
        while ((long)i < numRows + 1L) {
            int offset = bb.getInt();
            out.writeIntNativeOrder(offset - start);
            total += 4L;
            ++i;
        }
        assert (total == bytesToCopy);
        long ret = JCudfSerialization.padFor64byteAlignment(out, total);
        return ret;
    }

    private static int[] copyConcatOffsets(DataWriter out, int columnIndex, ColumnBufferProvider[][] providers) throws IOException {
        int[] dataLens = new int[providers.length];
        long totalCopied = 0L;
        int offsetToAdd = 0;
        out.writeIntNativeOrder(0);
        totalCopied += 4L;
        for (int batchIndex = 0; batchIndex < providers.length; ++batchIndex) {
            ColumnBufferProvider provider = providers[batchIndex][columnIndex];
            HostMemoryBuffer dataBuffer = provider.getHostBufferFor(BufferType.OFFSET);
            long currentOffset = provider.getBufferStartOffset(BufferType.OFFSET);
            int numRowsForHeader = (int)provider.getRowCount();
            int dataLeft = numRowsForHeader * 4;
            int startStringOffset = dataBuffer.getInt(currentOffset);
            int endStringOffset = dataBuffer.getInt(currentOffset + (long)(numRowsForHeader * 4));
            dataLens[batchIndex] = endStringOffset - startStringOffset;
            dataBuffer.setInt(currentOffset, offsetToAdd);
            for (int i = 1; i < numRowsForHeader + 1; ++i) {
                long at = currentOffset + (long)(i * 4);
                int orig = dataBuffer.getInt(at);
                int o = orig + offsetToAdd - startStringOffset;
                dataBuffer.setInt(at, o);
            }
            offsetToAdd += dataLens[batchIndex];
            out.copyDataFrom(dataBuffer, currentOffset += 4L, dataLeft);
            totalCopied += (long)dataLeft;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
        return dataLens;
    }

    private static long sliceBasicData(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        DType type = column.getType();
        long bytesToCopy = numRows * (long)type.sizeInBytes;
        long srcOffset = rowOffset * (long)type.sizeInBytes;
        return JCudfSerialization.copySlicedAndPad(out, column, BufferType.DATA, srcOffset, bytesToCopy);
    }

    private static void concatBasicData(DataWriter out, int columnIndex, DType type, ColumnBufferProvider[][] providers) throws IOException {
        long totalCopied = 0L;
        for (int batchIndex = 0; batchIndex < providers.length; ++batchIndex) {
            ColumnBufferProvider provider = providers[batchIndex][columnIndex];
            HostMemoryBuffer dataBuffer = provider.getHostBufferFor(BufferType.DATA);
            long currentOffset = provider.getBufferStartOffset(BufferType.DATA);
            int numRowsForBatch = (int)provider.getRowCount();
            int dataLeft = numRowsForBatch * type.sizeInBytes;
            out.copyDataFrom(dataBuffer, currentOffset, dataLeft);
            totalCopied += (long)dataLeft;
        }
        JCudfSerialization.padFor64byteAlignment(out, totalCopied);
    }

    private static void writeConcat(DataWriter out, int columnIndex, SerializedTableHeader combinedHeader, ColumnBufferProvider[][] providers) throws IOException {
        long nullCount = combinedHeader.nullCounts[columnIndex];
        if (nullCount > 0L) {
            JCudfSerialization.concatValidity(out, columnIndex, combinedHeader.numRows, providers);
        }
        if (combinedHeader.numRows > 0) {
            DType type = combinedHeader.types[columnIndex];
            if (type == DType.STRING) {
                int[] dataLens = JCudfSerialization.copyConcatOffsets(out, columnIndex, providers);
                JCudfSerialization.copyConcateStringData(out, columnIndex, dataLens, providers);
            } else {
                JCudfSerialization.concatBasicData(out, columnIndex, type, providers);
            }
        }
    }

    private static void writeSliced(DataWriter out, ColumnBufferProvider column, long rowOffset, long numRows) throws IOException {
        NvtxRange range;
        DType type;
        if (column.getNullCount() > 0L) {
            try (NvtxRange range2 = new NvtxRange("Write Validity", NvtxColor.DARK_GREEN);){
                JCudfSerialization.copySlicedValidity(out, column, rowOffset, numRows);
            }
        }
        if ((type = column.getType()) == DType.STRING) {
            range = new NvtxRange("Write String Data", NvtxColor.RED);
            Throwable throwable = null;
            try {
                JCudfSerialization.copySlicedOffsets(out, column, rowOffset, numRows);
                JCudfSerialization.copySlicedStringData(out, column, rowOffset, numRows);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (range != null) {
                    if (throwable != null) {
                        try {
                            range.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        range.close();
                    }
                }
            }
        }
        range = new NvtxRange("Write Data", NvtxColor.BLUE);
        Throwable throwable = null;
        try {
            JCudfSerialization.sliceBasicData(out, column, rowOffset, numRows);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (range != null) {
                if (throwable != null) {
                    try {
                        range.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    range.close();
                }
            }
        }
    }

    private static void writeSliced(ColumnBufferProvider[] columns, DataWriter out, long rowOffset, long numRows) throws IOException {
        assert (rowOffset >= 0L);
        assert (numRows >= 0L);
        for (int i = 0; i < columns.length; ++i) {
            long rows = columns[i].getRowCount();
            assert (rowOffset + numRows <= rows);
            long nullCount = columns[i].getNullCount();
            assert (nullCount == (long)((int)nullCount)) : "can only support an int for indexes";
            assert (rows == (long)((int)rows)) : "can only support an int for indexes";
        }
        SerializedTableHeader header = JCudfSerialization.calcHeader(columns, rowOffset, (int)numRows);
        header.writeTo(out);
        try (NvtxRange range = new NvtxRange("Write Sliced", NvtxColor.GREEN);){
            for (int i = 0; i < columns.length; ++i) {
                JCudfSerialization.writeSliced(out, columns[i], rowOffset, numRows);
            }
        }
        out.flush();
    }

    public static void writeToStream(Table t, OutputStream out, long rowOffset, long numRows) throws IOException {
        JCudfSerialization.writeToStream(t.getColumns(), out, rowOffset, numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToStream(ColumnVector[] columns, OutputStream out, long rowOffset, long numRows) throws IOException {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns);
        try {
            DataWriter writer = JCudfSerialization.writerFrom(out);
            JCudfSerialization.writeSliced(providers, writer, rowOffset, numRows);
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToStream(HostColumnVector[] columns, OutputStream out, long rowOffset, long numRows) throws IOException {
        ColumnBufferProvider[] providers = JCudfSerialization.providersFrom(columns, false);
        try {
            DataWriter writer = JCudfSerialization.writerFrom(out);
            JCudfSerialization.writeSliced(providers, writer, rowOffset, numRows);
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    public static void writeRowsToStream(OutputStream out, long numRows) throws IOException {
        DataWriter writer = JCudfSerialization.writerFrom(out);
        SerializedTableHeader header = JCudfSerialization.calcEmptyHeader((int)numRows);
        header.writeTo(writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConcatedStream(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers, OutputStream out) throws IOException {
        ColumnBufferProvider[][] providers = JCudfSerialization.providersFrom(headers, dataBuffers);
        try {
            SerializedTableHeader combined = JCudfSerialization.calcConcatedHeader(providers);
            DataWriter writer = JCudfSerialization.writerFrom(out);
            combined.writeTo(writer);
            try (NvtxRange range = new NvtxRange("Concat Host Side", NvtxColor.GREEN);){
                for (int columnIndex = 0; columnIndex < combined.numColumns; ++columnIndex) {
                    JCudfSerialization.writeConcat(writer, columnIndex, combined, providers);
                }
            }
            writer.flush();
        }
        finally {
            JCudfSerialization.closeAll(providers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table sliceUpColumnVectors(SerializedTableHeader header, DeviceMemoryBuffer combinedBuffer, HostMemoryBuffer combinedBufferOnHost) {
        Throwable throwable = null;
        try (NvtxRange range = new NvtxRange("bufferToTable", NvtxColor.PURPLE);){
            Table table;
            MemoryBuffer offsets;
            MemoryBuffer data;
            ColumnVector[] vectors;
            block26: {
                ColumnOffsets[] columnOffsets = JCudfSerialization.buildIndex(header, combinedBufferOnHost);
                DType[] dataTypes = header.types;
                long[] nullCounts = header.nullCounts;
                long numRows = header.getNumRows();
                int numColumns = dataTypes.length;
                vectors = new ColumnVector[numColumns];
                MemoryBuffer validity = null;
                data = null;
                offsets = null;
                try {
                    for (int column = 0; column < numColumns; ++column) {
                        DType type = dataTypes[column];
                        long nullCount = nullCounts[column];
                        ColumnOffsets offsetInfo = columnOffsets[column];
                        if (nullCount > 0L) {
                            validity = combinedBuffer.slice(offsetInfo.validity, offsetInfo.validityLen);
                        }
                        if (type == DType.STRING) {
                            offsets = combinedBuffer.slice(offsetInfo.offsets, offsetInfo.offsetsLen);
                        }
                        if (offsetInfo.dataLen > 0L) {
                            data = combinedBuffer.slice(offsetInfo.data, offsetInfo.dataLen);
                        }
                        vectors[column] = new ColumnVector(type, numRows, Optional.of(nullCount), (DeviceMemoryBuffer)data, (DeviceMemoryBuffer)validity, (DeviceMemoryBuffer)offsets);
                        validity = null;
                        data = null;
                        offsets = null;
                    }
                    table = new Table(vectors);
                    if (validity == null) break block26;
                }
                catch (Throwable throwable2) {
                    try {
                        if (validity != null) {
                            validity.close();
                        }
                        if (data != null) {
                            data.close();
                        }
                        if (offsets != null) {
                            offsets.close();
                        }
                        for (ColumnVector cv : vectors) {
                            if (cv == null) continue;
                            cv.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                validity.close();
            }
            if (data != null) {
                data.close();
            }
            if (offsets != null) {
                offsets.close();
            }
            for (ColumnVector cv : vectors) {
                if (cv == null) continue;
                cv.close();
            }
            return table;
        }
    }

    /*
     * Exception decompiling
     */
    public static Table readAndConcat(SerializedTableHeader[] headers, HostMemoryBuffer[] dataBuffers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void readTableIntoBuffer(InputStream in, SerializedTableHeader header, HostMemoryBuffer buffer) throws IOException {
        if (header.initialized && buffer.length >= header.dataLen) {
            try (NvtxRange range = new NvtxRange("Read Data", NvtxColor.RED);){
                buffer.copyFromStream(0L, in, header.dataLen);
            }
            header.dataRead = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableAndRowCountPair readTableFrom(SerializedTableHeader header, HostMemoryBuffer hostBuffer) {
        ContiguousTable contigTable = null;
        DeviceMemoryBuffer devBuffer = DeviceMemoryBuffer.allocate(hostBuffer.length);
        try {
            if (hostBuffer.length > 0L) {
                try (NvtxRange range = new NvtxRange("Copy Data To Device", NvtxColor.WHITE);){
                    devBuffer.copyFromHostBuffer(hostBuffer);
                }
            }
            if (header.getNumColumns() > 0) {
                Table table = JCudfSerialization.sliceUpColumnVectors(header, devBuffer, hostBuffer);
                contigTable = new ContiguousTable(table, devBuffer);
            }
        }
        finally {
            if (contigTable == null) {
                devBuffer.close();
            }
        }
        return new TableAndRowCountPair(header.numRows, contigTable);
    }

    public static TableAndRowCountPair readTableFrom(InputStream in) throws IOException {
        DataInputStream din = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        SerializedTableHeader header = new SerializedTableHeader(din);
        if (!header.initialized) {
            return new TableAndRowCountPair(0, null);
        }
        try (HostMemoryBuffer hostBuffer = HostMemoryBuffer.allocate(header.dataLen);){
            if (header.dataLen > 0L) {
                JCudfSerialization.readTableIntoBuffer(din, header, hostBuffer);
            }
            TableAndRowCountPair tableAndRowCountPair = JCudfSerialization.readTableFrom(header, hostBuffer);
            return tableAndRowCountPair;
        }
    }

    public static final class TableAndRowCountPair
    implements Closeable {
        private final int numRows;
        private final ContiguousTable contigTable;

        public TableAndRowCountPair(int numRows, ContiguousTable table) {
            this.numRows = numRows;
            this.contigTable = table;
        }

        @Override
        public void close() {
            if (this.contigTable != null) {
                this.contigTable.close();
            }
        }

        public int getNumRows() {
            return this.numRows;
        }

        public Table getTable() {
            if (this.contigTable != null) {
                return this.contigTable.getTable();
            }
            return null;
        }

        public ContiguousTable getContiguousTable() {
            return this.contigTable;
        }
    }

    private static final class HostDataWriter
    extends DataWriter {
        private final HostMemoryBuffer buffer;
        private long offset = 0L;

        public HostDataWriter(HostMemoryBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeByte(byte b) {
            this.buffer.setByte(this.offset, b);
            ++this.offset;
        }

        @Override
        public void writeShort(short s) {
            this.buffer.setShort(this.offset, s);
            this.offset += 2L;
        }

        @Override
        public void writeInt(int i) {
            this.buffer.setInt(this.offset, i);
            this.offset += 4L;
        }

        @Override
        public void writeIntNativeOrder(int i) {
            this.writeInt(i);
        }

        @Override
        public void writeLong(long val) {
            this.buffer.setLong(this.offset, val);
            this.offset += 8L;
        }

        @Override
        public void copyDataFrom(HostMemoryBuffer src, long srcOffset, long len) {
            this.buffer.copyFromHostBuffer(this.offset, src, srcOffset, len);
            this.offset += len;
        }

        @Override
        public void write(byte[] arr, int srcOffset, int length) {
            this.buffer.setBytes(this.offset, arr, srcOffset, length);
            this.offset += (long)length;
        }
    }

    static final class DataOutputStreamWriter
    extends DataWriter {
        private final byte[] arrayBuffer = new byte[131072];
        private final DataOutputStream dout;

        public DataOutputStreamWriter(DataOutputStream dout) {
            this.dout = dout;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.dout.writeByte(b);
        }

        @Override
        public void writeShort(short s) throws IOException {
            this.dout.writeShort(s);
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.dout.writeInt(i);
        }

        @Override
        public void writeIntNativeOrder(int i) throws IOException {
            this.writeInt(Integer.reverseBytes(i));
        }

        @Override
        public void writeLong(long val) throws IOException {
            this.dout.writeLong(val);
        }

        @Override
        public void copyDataFrom(HostMemoryBuffer src, long srcOffset, long len) throws IOException {
            int amountToCopy;
            for (long dataLeft = len; dataLeft > 0L; dataLeft -= (long)amountToCopy) {
                amountToCopy = (int)Math.min((long)this.arrayBuffer.length, dataLeft);
                src.getBytes(this.arrayBuffer, 0L, srcOffset, amountToCopy);
                this.dout.write(this.arrayBuffer, 0, amountToCopy);
                srcOffset += (long)amountToCopy;
            }
        }

        @Override
        public void flush() throws IOException {
            this.dout.flush();
        }

        @Override
        public void write(byte[] arr, int offset, int length) throws IOException {
            this.dout.write(arr, offset, length);
        }
    }

    static abstract class DataWriter {
        DataWriter() {
        }

        public abstract void writeByte(byte var1) throws IOException;

        public abstract void writeShort(short var1) throws IOException;

        public abstract void writeInt(int var1) throws IOException;

        public abstract void writeIntNativeOrder(int var1) throws IOException;

        public abstract void writeLong(long var1) throws IOException;

        public abstract void copyDataFrom(HostMemoryBuffer var1, long var2, long var4) throws IOException;

        public void copyDataFrom(ColumnBufferProvider column, BufferType buffType, long offset, long length) throws IOException {
            HostMemoryBuffer buff = column.getHostBufferFor(buffType);
            long startOffset = column.getBufferStartOffset(buffType);
            this.copyDataFrom(buff, startOffset + offset, length);
        }

        public void flush() throws IOException {
        }

        public abstract void write(byte[] var1, int var2, int var3) throws IOException;
    }

    private static class BufferOffsetProvider
    extends ColumnBufferProvider {
        private final SerializedTableHeader header;
        private final int columnIndex;
        private final ColumnOffsets offsets;
        private final HostMemoryBuffer buffer;

        private BufferOffsetProvider(SerializedTableHeader header, int columnIndex, ColumnOffsets offsets, HostMemoryBuffer buffer) {
            this.header = header;
            this.columnIndex = columnIndex;
            this.offsets = offsets;
            this.buffer = buffer;
        }

        @Override
        public DType getType() {
            return this.header.types[this.columnIndex];
        }

        @Override
        public long getNullCount() {
            return this.header.nullCounts[this.columnIndex];
        }

        @Override
        public long getRowCount() {
            return this.header.numRows;
        }

        @Override
        public HostMemoryBuffer getHostBufferFor(BufferType buffType) {
            return this.buffer;
        }

        @Override
        public long getBufferStartOffset(BufferType buffType) {
            switch (buffType) {
                case DATA: {
                    return this.offsets.data;
                }
                case OFFSET: {
                    return this.offsets.offsets;
                }
                case VALIDITY: {
                    return this.offsets.validity;
                }
            }
            throw new IllegalArgumentException("Buffer type " + (Object)((Object)buffType) + " is not supported");
        }

        @Override
        public long getStartStringOffset(long index) {
            assert (this.getType() == DType.STRING);
            assert (index >= 0L && index < this.getRowCount()) : "index is out of range 0 <= " + index + " < " + this.getRowCount();
            return this.buffer.getInt(this.offsets.offsets + index * 4L);
        }

        @Override
        public long getEndStringOffset(long index) {
            assert (this.getType() == DType.STRING);
            assert (index >= 0L && index < this.getRowCount()) : "index is out of range 0 <= " + index + " < " + this.getRowCount();
            return this.buffer.getInt(this.offsets.offsets + (index + 1L) * 4L);
        }

        @Override
        public void close() {
        }
    }

    static class ColumnProvider
    extends ColumnBufferProvider {
        private final HostColumnVector column;
        private final boolean closeAtEnd;

        ColumnProvider(HostColumnVector column, boolean closeAtEnd) {
            this.column = column;
            this.closeAtEnd = closeAtEnd;
        }

        @Override
        public DType getType() {
            return this.column.getType();
        }

        @Override
        public long getNullCount() {
            return this.column.getNullCount();
        }

        @Override
        public long getStartStringOffset(long index) {
            return this.column.getStartStringOffset(index);
        }

        @Override
        public long getEndStringOffset(long index) {
            return this.column.getEndStringOffset(index);
        }

        @Override
        public long getRowCount() {
            return this.column.getRowCount();
        }

        @Override
        public HostMemoryBuffer getHostBufferFor(BufferType buffType) {
            return this.column.getHostBufferFor(buffType);
        }

        @Override
        public long getBufferStartOffset(BufferType buffType) {
            return 0L;
        }

        @Override
        public void close() {
            if (this.closeAtEnd) {
                this.column.close();
            }
        }
    }

    static abstract class ColumnBufferProvider
    implements AutoCloseable {
        ColumnBufferProvider() {
        }

        public abstract DType getType();

        public abstract long getNullCount();

        public abstract long getStartStringOffset(long var1);

        public abstract long getEndStringOffset(long var1);

        public abstract long getRowCount();

        public abstract HostMemoryBuffer getHostBufferFor(BufferType var1);

        public abstract long getBufferStartOffset(BufferType var1);

        public void copyBytesToArray(byte[] dest, int destOffset, BufferType srcType, long srcOffset, int length) {
            HostMemoryBuffer buff = this.getHostBufferFor(srcType);
            buff.getBytes(dest, destOffset, srcOffset += this.getBufferStartOffset(srcType), length);
        }

        @Override
        public abstract void close();
    }

    public static final class SerializedTableHeader {
        private int numColumns;
        int numRows;
        private DType[] types;
        private long[] nullCounts;
        long dataLen;
        private boolean initialized = false;
        private boolean dataRead = false;

        public SerializedTableHeader(DataInputStream din) throws IOException {
            this.readFrom(din);
        }

        SerializedTableHeader(int numRows, DType[] types, long[] nullCounts, long dataLen) {
            this.numRows = numRows;
            this.numColumns = types != null ? types.length : 0;
            this.types = types;
            this.nullCounts = nullCounts;
            this.dataLen = dataLen;
            this.initialized = true;
            this.dataRead = true;
        }

        public DType getColumnType(int columnIndex) {
            return this.types[columnIndex];
        }

        public boolean wasDataRead() {
            return this.dataRead;
        }

        public long getDataLen() {
            return this.dataLen;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getNumColumns() {
            return this.numColumns;
        }

        public boolean wasInitialized() {
            return this.initialized;
        }

        private void readFrom(DataInputStream din) throws IOException {
            try {
                int num = din.readInt();
                if (num != 1129661510) {
                    throw new IllegalStateException("THIS DOES NOT LOOK LIKE CUDF SERIALIZED DATA. Expected magic number 1129661510 Found " + num);
                }
            }
            catch (EOFException e) {
                return;
            }
            short version = din.readShort();
            if (version != 0) {
                throw new IllegalStateException("READING THE WRONG SERIALIZATION FORMAT VERSION FOUND " + version + " EXPECTED " + 0);
            }
            this.numColumns = din.readInt();
            this.numRows = din.readInt();
            this.types = new DType[this.numColumns];
            this.nullCounts = new long[this.numColumns];
            for (int i = 0; i < this.numColumns; ++i) {
                this.types[i] = DType.fromNative(din.readInt());
                this.nullCounts[i] = din.readInt();
            }
            this.dataLen = din.readLong();
            this.initialized = true;
        }

        public void writeTo(DataWriter dout) throws IOException {
            dout.writeInt(1129661510);
            dout.writeShort((short)0);
            dout.writeInt(this.numColumns);
            dout.writeInt(this.numRows);
            for (int i = 0; i < this.numColumns; ++i) {
                dout.writeInt(this.types[i].nativeId);
                dout.writeInt((int)this.nullCounts[i]);
            }
            dout.writeLong(this.dataLen);
        }
    }

    private static final class ColumnOffsets {
        private final long validity;
        private final long validityLen;
        private final long offsets;
        private final long offsetsLen;
        private final long data;
        private final long dataLen;

        public ColumnOffsets(long validity, long validityLen, long offsets, long offsetsLen, long data, long dataLen) {
            this.validity = validity;
            this.validityLen = validityLen;
            this.offsets = offsets;
            this.offsetsLen = offsetsLen;
            this.data = data;
            this.dataLen = dataLen;
        }
    }
}

