/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.WriterOptions;

public class ParquetWriterOptions
extends WriterOptions {
    public static final ParquetWriterOptions DEFAULT = new ParquetWriterOptions(new Builder());
    private final StatisticsFrequency statsGranularity;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(Builder builder) {
        super(builder);
        this.statsGranularity = builder.statsGranularity;
    }

    public StatisticsFrequency getStatisticsFrequency() {
        return this.statsGranularity;
    }

    public static class Builder
    extends WriterOptions.WriterBuilder<Builder> {
        private StatisticsFrequency statsGranularity = StatisticsFrequency.ROWGROUP;

        public Builder withStatisticsFrequency(StatisticsFrequency statsGranularity) {
            this.statsGranularity = statsGranularity;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this);
        }
    }

    public static enum StatisticsFrequency {
        NONE(0),
        ROWGROUP(1),
        PAGE(2);

        final int nativeId;

        private StatisticsFrequency(int nativeId) {
            this.nativeId = nativeId;
        }
    }
}

