/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.HostColumnVector;
import java.util.function.Consumer;

public final class Range {
    public static final Consumer<HostColumnVector.Builder> appendBytes(byte end) {
        return Range.appendBytes((byte)0, end, (byte)1);
    }

    public static final Consumer<HostColumnVector.Builder> appendBytes(byte start, byte end) {
        return Range.appendBytes(start, end, (byte)1);
    }

    public static final Consumer<HostColumnVector.Builder> appendBytes(byte start, byte end, byte step) {
        assert (step > 0);
        assert (start <= end);
        return b -> {
            byte i = start;
            while (i < end) {
                b.append(i);
                i = (byte)(i + step);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendShorts(short end) {
        return Range.appendShorts((short)0, end, (short)1);
    }

    public static final Consumer<HostColumnVector.Builder> appendShorts(short start, short end) {
        return Range.appendShorts(start, end, (short)1);
    }

    public static final Consumer<HostColumnVector.Builder> appendShorts(short start, short end, short step) {
        assert (step > 0);
        assert (start <= end);
        return b -> {
            short i = start;
            while (i < end) {
                b.append(i);
                i = (short)(i + step);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendInts(int end) {
        return Range.appendInts(0, end, 1);
    }

    public static final Consumer<HostColumnVector.Builder> appendInts(int start, int end) {
        return Range.appendInts(start, end, 1);
    }

    public static final Consumer<HostColumnVector.Builder> appendInts(int start, int end, int step) {
        assert (step > 0);
        assert (start <= end);
        return b -> {
            for (int i = start; i < end; i += step) {
                b.append(i);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendLongs(long start, long end, long step) {
        assert (step > 0L);
        assert (start <= end);
        return b -> {
            for (long i = start; i < end; i += step) {
                b.append(i);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendLongs(long end) {
        return Range.appendLongs(0L, end, 1L);
    }

    public static final Consumer<HostColumnVector.Builder> appendLongs(long start, long end) {
        return Range.appendLongs(start, end, 1L);
    }

    public static final Consumer<HostColumnVector.Builder> appendFloats(float start, float end, float step) {
        assert (step > 0.0f);
        assert (start <= end);
        return b -> {
            for (float i = start; i < end; i += step) {
                b.append(i);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendFloats(float end) {
        return Range.appendFloats(0.0f, end, 1.0f);
    }

    public static final Consumer<HostColumnVector.Builder> appendFloats(float start, float end) {
        return Range.appendFloats(start, end, 1.0f);
    }

    public static final Consumer<HostColumnVector.Builder> appendDoubles(double start, double end, double step) {
        assert (step > 0.0);
        assert (start <= end);
        return b -> {
            for (double i = start; i < end; i += step) {
                b.append(i);
            }
        };
    }

    public static final Consumer<HostColumnVector.Builder> appendDoubles(double end) {
        return Range.appendDoubles(0.0, end, 1.0);
    }

    public static final Consumer<HostColumnVector.Builder> appendDoubles(double start, double end) {
        return Range.appendDoubles(start, end, 1.0);
    }
}

