/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scalar
implements AutoCloseable,
BinaryOperable {
    private static final Logger LOG;
    private final DType type;
    private int refCount;
    private final OffHeapState offHeap;

    public static Scalar fromNull(DType type) {
        switch (type) {
            case EMPTY: 
            case BOOL8: {
                return new Scalar(type, Scalar.makeBool8Scalar(false, false));
            }
            case INT8: {
                return new Scalar(type, Scalar.makeInt8Scalar((byte)0, false));
            }
            case INT16: {
                return new Scalar(type, Scalar.makeInt16Scalar((short)0, false));
            }
            case INT32: {
                return new Scalar(type, Scalar.makeInt32Scalar(0, false));
            }
            case TIMESTAMP_DAYS: {
                return new Scalar(type, Scalar.makeTimestampDaysScalar(0, false));
            }
            case FLOAT32: {
                return new Scalar(type, Scalar.makeFloat32Scalar(0.0f, false));
            }
            case FLOAT64: {
                return new Scalar(type, Scalar.makeFloat64Scalar(0.0, false));
            }
            case INT64: {
                return new Scalar(type, Scalar.makeInt64Scalar(0L, false));
            }
            case TIMESTAMP_SECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_NANOSECONDS: {
                return new Scalar(type, Scalar.makeTimestampTimeScalar(type.nativeId, 0L, false));
            }
            case STRING: {
                return new Scalar(type, Scalar.makeStringScalar(null, false));
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)type));
    }

    public static Scalar fromBool(boolean value) {
        return new Scalar(DType.BOOL8, Scalar.makeBool8Scalar(value, true));
    }

    public static Scalar fromBool(Boolean value) {
        if (value == null) {
            return Scalar.fromNull(DType.BOOL8);
        }
        return Scalar.fromBool((boolean)value);
    }

    public static Scalar fromByte(byte value) {
        return new Scalar(DType.INT8, Scalar.makeInt8Scalar(value, true));
    }

    public static Scalar fromByte(Byte value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT8);
        }
        return Scalar.fromByte((byte)value);
    }

    public static Scalar fromShort(short value) {
        return new Scalar(DType.INT16, Scalar.makeInt16Scalar(value, true));
    }

    public static Scalar fromShort(Short value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT16);
        }
        return Scalar.fromShort((short)value);
    }

    public static Scalar fromInt(int value) {
        return new Scalar(DType.INT32, Scalar.makeInt32Scalar(value, true));
    }

    public static Scalar fromInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT32);
        }
        return Scalar.fromInt((int)value);
    }

    public static Scalar fromLong(long value) {
        return new Scalar(DType.INT64, Scalar.makeInt64Scalar(value, true));
    }

    public static Scalar fromLong(Long value) {
        if (value == null) {
            return Scalar.fromNull(DType.INT64);
        }
        return Scalar.fromLong((long)value);
    }

    public static Scalar fromFloat(float value) {
        return new Scalar(DType.FLOAT32, Scalar.makeFloat32Scalar(value, true));
    }

    public static Scalar fromFloat(Float value) {
        if (value == null) {
            return Scalar.fromNull(DType.FLOAT32);
        }
        return Scalar.fromFloat(value.floatValue());
    }

    public static Scalar fromDouble(double value) {
        return new Scalar(DType.FLOAT64, Scalar.makeFloat64Scalar(value, true));
    }

    public static Scalar fromDouble(Double value) {
        if (value == null) {
            return Scalar.fromNull(DType.FLOAT64);
        }
        return Scalar.fromDouble((double)value);
    }

    public static Scalar timestampDaysFromInt(int value) {
        return new Scalar(DType.TIMESTAMP_DAYS, Scalar.makeTimestampDaysScalar(value, true));
    }

    public static Scalar timestampDaysFromInt(Integer value) {
        if (value == null) {
            return Scalar.fromNull(DType.TIMESTAMP_DAYS);
        }
        return Scalar.timestampDaysFromInt((int)value);
    }

    public static Scalar timestampFromLong(DType type, long value) {
        if (type.isTimestamp()) {
            if (type == DType.TIMESTAMP_DAYS) {
                int intValue = (int)value;
                if (value != (long)intValue) {
                    throw new IllegalArgumentException("value too large for type " + (Object)((Object)type) + ": " + value);
                }
                return Scalar.timestampDaysFromInt(intValue);
            }
            return new Scalar(type, Scalar.makeTimestampTimeScalar(type.nativeId, value, true));
        }
        throw new IllegalArgumentException("type is not a timestamp: " + (Object)((Object)type));
    }

    public static Scalar timestampFromLong(DType type, Long value) {
        if (value == null) {
            return Scalar.fromNull(type);
        }
        return Scalar.timestampFromLong(type, (long)value);
    }

    public static Scalar fromString(String value) {
        if (value == null) {
            return Scalar.fromNull(DType.STRING);
        }
        return new Scalar(DType.STRING, Scalar.makeStringScalar(value.getBytes(StandardCharsets.UTF_8), true));
    }

    private static native void closeScalar(long var0);

    private static native boolean isScalarValid(long var0);

    private static native byte getByte(long var0);

    private static native short getShort(long var0);

    private static native int getInt(long var0);

    private static native long getLong(long var0);

    private static native float getFloat(long var0);

    private static native double getDouble(long var0);

    private static native byte[] getUTF8(long var0);

    private static native long makeBool8Scalar(boolean var0, boolean var1);

    private static native long makeInt8Scalar(byte var0, boolean var1);

    private static native long makeInt16Scalar(short var0, boolean var1);

    private static native long makeInt32Scalar(int var0, boolean var1);

    private static native long makeInt64Scalar(long var0, boolean var2);

    private static native long makeFloat32Scalar(float var0, boolean var1);

    private static native long makeFloat64Scalar(double var0, boolean var2);

    private static native long makeStringScalar(byte[] var0, boolean var1);

    private static native long makeTimestampDaysScalar(int var0, boolean var1);

    private static native long makeTimestampTimeScalar(int var0, long var1, boolean var3);

    Scalar(DType type, long scalarHandle) {
        this.type = type;
        this.offHeap = new OffHeapState(scalarHandle);
        this.incRefCount();
    }

    public synchronized Scalar incRefCount() {
        if (this.offHeap.scalarHandle == 0L) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Scalar is already closed");
        }
        ++this.refCount;
        return this;
    }

    long getScalarHandle() {
        return this.offHeap.scalarHandle;
    }

    @Override
    public synchronized void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times " + this);
        }
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public boolean isValid() {
        return Scalar.isScalarValid(this.getScalarHandle());
    }

    public boolean getBoolean() {
        return Scalar.getByte(this.getScalarHandle()) != 0;
    }

    public byte getByte() {
        return Scalar.getByte(this.getScalarHandle());
    }

    public short getShort() {
        return Scalar.getShort(this.getScalarHandle());
    }

    public int getInt() {
        return Scalar.getInt(this.getScalarHandle());
    }

    public long getLong() {
        return Scalar.getLong(this.getScalarHandle());
    }

    public float getFloat() {
        return Scalar.getFloat(this.getScalarHandle());
    }

    public double getDouble() {
        return Scalar.getDouble(this.getScalarHandle());
    }

    public String getJavaString() {
        return new String(Scalar.getUTF8(this.getScalarHandle()), StandardCharsets.UTF_8);
    }

    public byte[] getUTF8() {
        return Scalar.getUTF8(this.getScalarHandle());
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnVector) {
            ColumnVector cvRhs = (ColumnVector)rhs;
            return new ColumnVector(Scalar.binaryOp(this, cvRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with Scalar");
    }

    static long binaryOp(Scalar lhs, ColumnVector rhs, BinaryOp op, DType outputType) {
        return Scalar.binaryOpSV(lhs.getScalarHandle(), rhs.getNativeView(), op.nativeId, outputType.nativeId);
    }

    private static native long binaryOpSV(long var0, long var2, int var4, int var5);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scalar other = (Scalar)o;
        if (this.type != other.type) {
            return false;
        }
        boolean valid = this.isValid();
        if (valid != other.isValid()) {
            return false;
        }
        if (!valid) {
            return true;
        }
        switch (this.type) {
            case EMPTY: {
                return true;
            }
            case BOOL8: {
                return this.getBoolean() == other.getBoolean();
            }
            case INT8: {
                return this.getByte() == other.getByte();
            }
            case INT16: {
                return this.getShort() == other.getShort();
            }
            case INT32: 
            case TIMESTAMP_DAYS: {
                return this.getInt() == other.getInt();
            }
            case FLOAT32: {
                return this.getFloat() == other.getFloat();
            }
            case FLOAT64: {
                return this.getDouble() == other.getDouble();
            }
            case INT64: 
            case TIMESTAMP_SECONDS: 
            case TIMESTAMP_MILLISECONDS: 
            case TIMESTAMP_MICROSECONDS: 
            case TIMESTAMP_NANOSECONDS: {
                return this.getLong() == this.getLong();
            }
            case STRING: {
                return Arrays.equals(this.getUTF8(), other.getUTF8());
            }
        }
        throw new IllegalStateException("Unexpected type: " + (Object)((Object)this.type));
    }

    public int hashCode() {
        int valueHash = 0;
        if (this.isValid()) {
            switch (this.type) {
                case EMPTY: {
                    valueHash = 0;
                    break;
                }
                case BOOL8: {
                    valueHash = this.getBoolean() ? 1 : 0;
                    break;
                }
                case INT8: {
                    valueHash = this.getByte();
                    break;
                }
                case INT16: {
                    valueHash = this.getShort();
                    break;
                }
                case INT32: 
                case TIMESTAMP_DAYS: {
                    valueHash = this.getInt();
                    break;
                }
                case INT64: 
                case TIMESTAMP_SECONDS: 
                case TIMESTAMP_MILLISECONDS: 
                case TIMESTAMP_MICROSECONDS: 
                case TIMESTAMP_NANOSECONDS: {
                    valueHash = Long.hashCode(this.getLong());
                    break;
                }
                case FLOAT32: {
                    valueHash = Float.hashCode(this.getFloat());
                    break;
                }
                case FLOAT64: {
                    valueHash = Double.hashCode(this.getDouble());
                    break;
                }
                case STRING: {
                    valueHash = Arrays.hashCode(this.getUTF8());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown scalar type: " + (Object)((Object)this.type));
                }
            }
        }
        return Objects.hash(new Object[]{this.type, valueHash});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Scalar{type=");
        sb.append((Object)this.type);
        if (this.getScalarHandle() != 0L) {
            sb.append(" value=");
            switch (this.type) {
                case BOOL8: {
                    sb.append(this.getBoolean());
                    break;
                }
                case INT8: {
                    sb.append(this.getByte());
                    break;
                }
                case INT16: {
                    sb.append(this.getShort());
                    break;
                }
                case INT32: 
                case TIMESTAMP_DAYS: {
                    sb.append(this.getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP_SECONDS: 
                case TIMESTAMP_MILLISECONDS: 
                case TIMESTAMP_MICROSECONDS: 
                case TIMESTAMP_NANOSECONDS: {
                    sb.append(this.getLong());
                    break;
                }
                case FLOAT32: {
                    sb.append(this.getFloat());
                    break;
                }
                case FLOAT64: {
                    sb.append(this.getDouble());
                    break;
                }
                case STRING: {
                    sb.append('\"');
                    sb.append(this.getJavaString());
                    sb.append('\"');
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown scalar type: " + (Object)((Object)this.type));
                }
            }
        }
        sb.append("} (ID: ");
        sb.append(this.offHeap.id);
        sb.append(" ");
        sb.append(Long.toHexString(this.offHeap.scalarHandle));
        sb.append(")");
        return sb.toString();
    }

    static {
        NativeDepsLoader.loadNativeDeps();
        LOG = LoggerFactory.getLogger(Scalar.class);
    }

    private static class OffHeapState
    extends MemoryCleaner.Cleaner {
        private long scalarHandle;

        OffHeapState(long scalarHandle) {
            this.scalarHandle = scalarHandle;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            if (this.scalarHandle != 0L) {
                if (logErrorIfNotClean) {
                    LOG.error("A SCALAR WAS LEAKED(ID: " + this.id + " " + Long.toHexString(this.scalarHandle) + ")");
                    this.logRefCountDebug("Leaked scalar");
                }
                try {
                    Scalar.closeScalar(this.scalarHandle);
                }
                finally {
                    this.scalarHandle = 0L;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isClean() {
            return this.scalarHandle == 0L;
        }
    }
}

