/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregate;
import ai.rapids.cudf.AggregateOp;
import ai.rapids.cudf.CSVOptions;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.GroupByOptions;
import ai.rapids.cudf.HostBufferConsumer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.ORCOptions;
import ai.rapids.cudf.ORCWriterOptions;
import ai.rapids.cudf.ParquetOptions;
import ai.rapids.cudf.ParquetWriterOptions;
import ai.rapids.cudf.PartitionedTable;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.TableWriter;
import ai.rapids.cudf.WindowAggregate;
import ai.rapids.cudf.WindowAggregateOp;
import ai.rapids.cudf.WindowOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class Table
implements AutoCloseable {
    private final long rows;
    private long nativeHandle;
    private ColumnVector[] columns;

    public Table(ColumnVector ... columns) {
        assert (columns != null && columns.length > 0) : "ColumnVectors can't be null or empty";
        this.rows = columns[0].getRowCount();
        for (ColumnVector columnVector : columns) {
            assert (null != columnVector) : "ColumnVectors can't be null";
            assert (this.rows == columnVector.getRowCount()) : "All columns should have the same number of rows " + (Object)((Object)columnVector.getType());
        }
        this.columns = new ColumnVector[columns.length];
        long[] viewPointers = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns[i] = columns[i];
            columns[i].incRefCount();
            viewPointers[i] = columns[i].getNativeView();
        }
        this.nativeHandle = this.createCudfTableView(viewPointers);
    }

    Table(long[] cudfColumns) {
        assert (cudfColumns != null && cudfColumns.length > 0) : "CudfColumns can't be null or empty";
        this.columns = new ColumnVector[cudfColumns.length];
        try {
            for (int i = 0; i < cudfColumns.length; ++i) {
                this.columns[i] = new ColumnVector(cudfColumns[i]);
            }
            long[] views = new long[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                views[i] = this.columns[i].getNativeView();
            }
            this.nativeHandle = this.createCudfTableView(views);
            this.rows = this.columns[0].getRowCount();
        }
        catch (Throwable t) {
            for (int i = 0; i < cudfColumns.length; ++i) {
                if (this.columns[i] != null) {
                    this.columns[i].close();
                    continue;
                }
                ColumnVector.deleteCudfColumn(cudfColumns[i]);
            }
            throw t;
        }
    }

    ColumnVector[] getColumns() {
        return this.columns;
    }

    public ColumnVector getColumn(int index) {
        assert (index < this.columns.length);
        return this.columns[index];
    }

    public final long getRowCount() {
        return this.rows;
    }

    public final int getNumberOfColumns() {
        return this.columns.length;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Table.deleteCudfTable(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].close();
                this.columns[i] = null;
            }
            this.columns = null;
        }
    }

    public String toString() {
        return "Table{columns=" + Arrays.toString(this.columns) + ", cudfTable=" + this.nativeHandle + ", rows=" + this.rows + '}';
    }

    public long getDeviceMemorySize() {
        long total = 0L;
        for (ColumnVector cv : this.columns) {
            total += cv.getDeviceMemorySize();
        }
        return total;
    }

    private static native ContiguousTable[] contiguousSplit(long var0, int[] var2);

    private static native long[] hashPartition(long var0, int[] var2, int var3, int[] var4) throws CudfException;

    private static native long[] roundRobinPartition(long var0, int var2, int var3, int[] var4) throws CudfException;

    private static native void deleteCudfTable(long var0) throws CudfException;

    private static native long bound(long var0, long var2, boolean[] var4, boolean[] var5, boolean var6) throws CudfException;

    private static native long[] readCSV(String[] var0, String[] var1, String[] var2, String var3, long var4, long var6, int var8, byte var9, byte var10, byte var11, String[] var12, String[] var13, String[] var14) throws CudfException;

    private static native long[] readParquet(String[] var0, String var1, long var2, long var4, int var6) throws CudfException;

    private static native long writeParquetFileBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, int var5, String var6) throws CudfException;

    private static native long writeParquetBufferBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, int var5, HostBufferConsumer var6) throws CudfException;

    private static native void writeParquetChunk(long var0, long var2, long var4);

    private static native void writeParquetEnd(long var0);

    private static native long[] readORC(String[] var0, String var1, long var2, long var4, boolean var6, int var7) throws CudfException;

    private static native long writeORCFileBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, String var5) throws CudfException;

    private static native long writeORCBufferBegin(String[] var0, boolean[] var1, String[] var2, String[] var3, int var4, HostBufferConsumer var5) throws CudfException;

    private static native void writeORCChunk(long var0, long var2, long var4);

    private static native void writeORCEnd(long var0);

    private static native long[] groupByAggregate(long var0, int[] var2, int[] var3, int[] var4, boolean var5) throws CudfException;

    private static native long[] rollingWindowAggregate(long var0, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, boolean var8) throws CudfException;

    private static native long[] timeRangeRollingWindowAggregate(long var0, int[] var2, int[] var3, boolean[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, boolean var10) throws CudfException;

    private static native long[] orderBy(long var0, long[] var2, boolean[] var3, boolean[] var4) throws CudfException;

    private static native long[] leftJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] innerJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] leftSemiJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] leftAntiJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] concatenate(long[] var0) throws CudfException;

    private static native long interleaveColumns(long var0);

    private static native long[] filter(long var0, long var2);

    private native long createCudfTableView(long[] var1);

    public static Table readCSV(Schema schema, File path) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, path);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, File path) {
        return new Table(Table.readCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readCSV(Schema schema, byte[] buffer) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer) {
        return Table.readCSV(schema, opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readCSV(schema, opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readCSV(Schema schema, CSVOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readParquet(File path) {
        return Table.readParquet(ParquetOptions.DEFAULT, path);
    }

    public static Table readParquet(ParquetOptions opts, File path) {
        return new Table(Table.readParquet(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.timeUnit().nativeId));
    }

    public static Table readParquet(byte[] buffer) {
        return Table.readParquet(ParquetOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer) {
        return Table.readParquet(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readParquet(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readParquet(ParquetOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readParquet(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.timeUnit().nativeId));
    }

    public static Table readORC(File path) {
        return Table.readORC(ORCOptions.DEFAULT, path);
    }

    public static Table readORC(ORCOptions opts, File path) {
        return new Table(Table.readORC(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.usingNumPyTypes(), opts.timeUnit().nativeId));
    }

    public static Table readORC(byte[] buffer) {
        return Table.readORC(ORCOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer) {
        return Table.readORC(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readORC(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readORC(ORCOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.readORC(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.usingNumPyTypes(), opts.timeUnit().nativeId));
    }

    public static TableWriter writeParquetChunked(ParquetWriterOptions options, File outputFile) {
        return new ParquetTableWriter(options, outputFile);
    }

    public static TableWriter writeParquetChunked(ParquetWriterOptions options, HostBufferConsumer consumer) {
        return new ParquetTableWriter(options, consumer);
    }

    @Deprecated
    public void writeParquet(File outputFile) {
        this.writeParquet(ParquetWriterOptions.DEFAULT, outputFile);
    }

    @Deprecated
    public void writeParquet(ParquetWriterOptions options, File outputFile) {
        try (TableWriter writer = Table.writeParquetChunked(options, outputFile);){
            writer.write(this);
        }
    }

    public static TableWriter writeORCChunked(ORCWriterOptions options, File outputFile) {
        return new ORCTableWriter(options, outputFile);
    }

    public static TableWriter writeORCChunked(ORCWriterOptions options, HostBufferConsumer consumer) {
        return new ORCTableWriter(options, consumer);
    }

    @Deprecated
    public void writeORC(File outputFile) {
        this.writeORC(ORCWriterOptions.DEFAULT, outputFile);
    }

    @Deprecated
    public void writeORC(ORCWriterOptions options, File outputFile) {
        try (TableWriter writer = Table.writeORCChunked(options, outputFile);){
            writer.write(this);
        }
    }

    public static Table concatenate(Table ... tables) {
        if (tables.length < 2) {
            throw new IllegalArgumentException("concatenate requires 2 or more tables");
        }
        int numColumns = tables[0].getNumberOfColumns();
        long[] tableHandles = new long[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            tableHandles[i] = tables[i].nativeHandle;
            assert (tables[i].getNumberOfColumns() == numColumns) : "all tables must have the same schema";
        }
        return new Table(Table.concatenate(tableHandles));
    }

    public ColumnVector interleaveColumns() {
        assert (this.getNumberOfColumns() >= 2) : ".interleaveColumns() operation requires at least 2 columns";
        return new ColumnVector(Table.interleaveColumns(this.nativeHandle));
    }

    public ColumnVector lowerBound(boolean[] areNullsSmallest, Table valueTable, boolean[] descFlags) {
        this.assertForBounds(valueTable);
        return new ColumnVector(Table.bound(this.nativeHandle, valueTable.nativeHandle, descFlags, areNullsSmallest, false));
    }

    public ColumnVector upperBound(boolean[] areNullsSmallest, Table valueTable, boolean[] descFlags) {
        this.assertForBounds(valueTable);
        return new ColumnVector(Table.bound(this.nativeHandle, valueTable.nativeHandle, descFlags, areNullsSmallest, true));
    }

    private void assertForBounds(Table valueTable) {
        assert (this.getRowCount() != 0L) : "Input table cannot be empty";
        assert (valueTable.getRowCount() != 0L) : "Value table cannot be empty";
        for (int i = 0; i < Math.min(this.columns.length, valueTable.columns.length); ++i) {
            assert (valueTable.columns[i].getType() == this.getColumn(i).getType()) : "Input and values tables' data types do not match";
        }
    }

    public Table orderBy(OrderByArg ... args) {
        assert (args.length <= this.columns.length);
        long[] sortKeys = new long[args.length];
        boolean[] isDescending = new boolean[args.length];
        boolean[] areNullsSmallest = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].index;
            assert (index >= 0 && index < this.columns.length) : "index is out of range 0 <= " + index + " < " + this.columns.length;
            isDescending[i] = args[i].isDescending;
            areNullsSmallest[i] = args[i].isNullSmallest;
            sortKeys[i] = this.columns[index].getNativeView();
        }
        return new Table(Table.orderBy(this.nativeHandle, sortKeys, isDescending, areNullsSmallest));
    }

    public static OrderByArg asc(int index) {
        return new OrderByArg(index, false, false);
    }

    public static OrderByArg desc(int index) {
        return new OrderByArg(index, true, false);
    }

    public static OrderByArg asc(int index, boolean isNullSmallest) {
        return new OrderByArg(index, false, isNullSmallest);
    }

    public static OrderByArg desc(int index, boolean isNullSmallest) {
        return new OrderByArg(index, true, isNullSmallest);
    }

    public static Aggregate count(int index) {
        return Aggregate.count(index, false);
    }

    public static Aggregate count(int index, boolean include_nulls) {
        return Aggregate.count(index, include_nulls);
    }

    public static Aggregate max(int index) {
        return Aggregate.max(index);
    }

    public static Aggregate min(int index) {
        return Aggregate.min(index);
    }

    public static Aggregate sum(int index) {
        return Aggregate.sum(index);
    }

    public static Aggregate mean(int index) {
        return Aggregate.mean(index);
    }

    public static Aggregate median(int index) {
        return Aggregate.median(index);
    }

    public static Aggregate first(int index, boolean includeNulls) {
        return Aggregate.first(index, includeNulls);
    }

    public static Aggregate last(int index, boolean includeNulls) {
        return Aggregate.last(index, includeNulls);
    }

    public AggregateOperation groupBy(GroupByOptions groupByOptions, int ... indices) {
        return this.groupByInternal(groupByOptions, indices);
    }

    public AggregateOperation groupBy(int ... indices) {
        return this.groupByInternal(GroupByOptions.builder().withIgnoreNullKeys(false).build(), indices);
    }

    private AggregateOperation groupByInternal(GroupByOptions groupByOptions, int[] indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new AggregateOperation(this, groupByOptions, operationIndicesArray);
    }

    public PartitionedTable roundRobinPartition(int numberOfPartitions, int startPartition) {
        int[] partitionOffsets = new int[numberOfPartitions];
        return new PartitionedTable(new Table(Table.roundRobinPartition(this.nativeHandle, numberOfPartitions, startPartition, partitionOffsets)), partitionOffsets);
    }

    public TableOperation onColumns(int ... indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new TableOperation(this, operationIndicesArray);
    }

    private int[] copyAndValidate(int[] indices) {
        int[] operationIndicesArray = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            operationIndicesArray[i] = indices[i];
            assert (operationIndicesArray[i] >= 0 && operationIndicesArray[i] < this.columns.length) : "operation index is out of range 0 <= " + operationIndicesArray[i] + " < " + this.columns.length;
        }
        return operationIndicesArray;
    }

    public Table filter(ColumnVector mask) {
        assert (mask.getType() == DType.BOOL8) : "Mask column must be of type BOOL8";
        assert (this.getRowCount() == 0L || this.getRowCount() == mask.getRowCount()) : "Mask column has incorrect size";
        return new Table(Table.filter(this.nativeHandle, mask.getNativeView()));
    }

    public ContiguousTable[] contiguousSplit(int ... indices) {
        return Table.contiguousSplit(this.nativeHandle, indices);
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class TestBuilder {
        private final List<DType> types = new ArrayList<DType>();
        private final List<Object> typeErasedData = new ArrayList<Object>();

        public TestBuilder column(String ... values) {
            this.types.add(DType.STRING);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Boolean ... values) {
            this.types.add(DType.BOOL8);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Byte ... values) {
            this.types.add(DType.INT8);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Short ... values) {
            this.types.add(DType.INT16);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Integer ... values) {
            this.types.add(DType.INT32);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Long ... values) {
            this.types.add(DType.INT64);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Float ... values) {
            this.types.add(DType.FLOAT32);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Double ... values) {
            this.types.add(DType.FLOAT64);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampDayColumn(Integer ... values) {
            this.types.add(DType.TIMESTAMP_DAYS);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampNanosecondsColumn(Long ... values) {
            this.types.add(DType.TIMESTAMP_NANOSECONDS);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampMillisecondsColumn(Long ... values) {
            this.types.add(DType.TIMESTAMP_MILLISECONDS);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampMicrosecondsColumn(Long ... values) {
            this.types.add(DType.TIMESTAMP_MICROSECONDS);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampSecondsColumn(Long ... values) {
            this.types.add(DType.TIMESTAMP_SECONDS);
            this.typeErasedData.add(values);
            return this;
        }

        private static ColumnVector from(DType type, Object dataArray) {
            ColumnVector ret = null;
            switch (type) {
                case STRING: {
                    ret = ColumnVector.fromStrings((String[])dataArray);
                    break;
                }
                case BOOL8: {
                    ret = ColumnVector.fromBoxedBooleans((Boolean[])dataArray);
                    break;
                }
                case INT8: {
                    ret = ColumnVector.fromBoxedBytes((Byte[])dataArray);
                    break;
                }
                case INT16: {
                    ret = ColumnVector.fromBoxedShorts((Short[])dataArray);
                    break;
                }
                case INT32: {
                    ret = ColumnVector.fromBoxedInts((Integer[])dataArray);
                    break;
                }
                case INT64: {
                    ret = ColumnVector.fromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_DAYS: {
                    ret = ColumnVector.timestampDaysFromBoxedInts((Integer[])dataArray);
                    break;
                }
                case TIMESTAMP_SECONDS: {
                    ret = ColumnVector.timestampSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_MILLISECONDS: {
                    ret = ColumnVector.timestampMilliSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_MICROSECONDS: {
                    ret = ColumnVector.timestampMicroSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP_NANOSECONDS: {
                    ret = ColumnVector.timestampNanoSecondsFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case FLOAT32: {
                    ret = ColumnVector.fromBoxedFloats((Float[])dataArray);
                    break;
                }
                case FLOAT64: {
                    ret = ColumnVector.fromBoxedDoubles((Double[])dataArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)type) + " is not supported yet");
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table build() {
            ArrayList<ColumnVector> columns = new ArrayList<ColumnVector>(this.types.size());
            try {
                for (int i = 0; i < this.types.size(); ++i) {
                    columns.add(TestBuilder.from(this.types.get(i), this.typeErasedData.get(i)));
                }
                Table table = new Table(columns.toArray(new ColumnVector[columns.size()]));
                return table;
            }
            finally {
                for (ColumnVector cv : columns) {
                    cv.close();
                }
            }
        }
    }

    public static final class TableOperation {
        private final Operation operation;

        TableOperation(Table table, int ... indices) {
            this.operation = new Operation(table, indices);
        }

        public Table leftJoin(TableOperation rightJoinIndices) {
            return new Table(Table.leftJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public Table innerJoin(TableOperation rightJoinIndices) {
            return new Table(Table.innerJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public Table leftSemiJoin(TableOperation rightJoinIndices) {
            return new Table(Table.leftSemiJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public Table leftAntiJoin(TableOperation rightJoinIndices) {
            return new Table(Table.leftAntiJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public PartitionedTable hashPartition(int numberOfPartitions) {
            int[] partitionOffsets = new int[numberOfPartitions];
            return new PartitionedTable(new Table(Table.hashPartition(this.operation.table.nativeHandle, this.operation.indices, partitionOffsets.length, partitionOffsets)), partitionOffsets);
        }

        @Deprecated
        public PartitionedTable partition(int numberOfPartitions) {
            return this.hashPartition(numberOfPartitions);
        }
    }

    public static final class AggregateOperation {
        private final Operation operation;
        private final GroupByOptions groupByOptions;

        AggregateOperation(Table table, GroupByOptions groupByOptions, int ... indices) {
            this.operation = new Operation(table, indices);
            this.groupByOptions = groupByOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table aggregate(Aggregate ... aggregates) {
            assert (aggregates != null);
            TreeMap<Integer, ColumnOps> groupedOps = new TreeMap<Integer, ColumnOps>();
            int keysLength = this.operation.indices.length;
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < aggregates.length; ++outputIndex) {
                Aggregate agg = aggregates[outputIndex];
                ColumnOps ops = groupedOps.computeIfAbsent(agg.getIndex(), idx -> new ColumnOps());
                totalOps += ops.add(agg.getOp(), outputIndex + keysLength);
            }
            int[] aggColumnIndexes = new int[totalOps];
            int[] aggOperationIds = new int[totalOps];
            int opIndex = 0;
            for (Map.Entry entry : groupedOps.entrySet()) {
                int columnIndex = (Integer)entry.getKey();
                for (AggregateOp operation : ((ColumnOps)entry.getValue()).operations()) {
                    aggColumnIndexes[opIndex] = columnIndex;
                    aggOperationIds[opIndex] = operation.nativeId;
                    ++opIndex;
                }
            }
            assert (opIndex == totalOps) : opIndex + " == " + totalOps;
            try (Table aggregate = new Table(Table.groupByAggregate(this.operation.table.nativeHandle, this.operation.indices, aggColumnIndexes, aggOperationIds, this.groupByOptions.getIgnoreNullKeys()));){
                ColumnVector[] finalCols = new ColumnVector[keysLength + aggregates.length];
                for (int aggIndex = 0; aggIndex < keysLength; ++aggIndex) {
                    finalCols[aggIndex] = aggregate.getColumn(aggIndex);
                }
                int inputColumn = keysLength;
                for (ColumnOps ops : groupedOps.values()) {
                    for (List<Integer> indices : ops.outputIndices()) {
                        for (int outIndex : indices) {
                            finalCols[outIndex] = aggregate.getColumn(inputColumn);
                        }
                        ++inputColumn;
                    }
                }
                Table table = new Table(finalCols);
                return table;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table aggregateWindows(WindowAggregate ... windowAggregates) {
            TreeMap<Integer, ColumnWindowOps> groupedOps = new TreeMap<Integer, ColumnWindowOps>();
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < windowAggregates.length; ++outputIndex) {
                WindowAggregate agg = windowAggregates[outputIndex];
                if (agg.getOp().getWindowOptions().getFrameType() != WindowOptions.FrameType.ROWS) {
                    throw new IllegalArgumentException("Expected ROWS-based window specification. Unexpected window type: " + (Object)((Object)agg.getOp().getWindowOptions().getFrameType()));
                }
                ColumnWindowOps ops = groupedOps.computeIfAbsent(agg.getColumnIndex(), idx -> new ColumnWindowOps());
                totalOps += ops.add(agg.getOp(), outputIndex);
            }
            int[] aggColumnIndexes = new int[totalOps];
            int[] aggOperationIds = new int[totalOps];
            int[] aggPrecedingWindows = new int[totalOps];
            int[] aggFollowingWindows = new int[totalOps];
            int[] aggMinPeriods = new int[totalOps];
            int opIndex = 0;
            for (Map.Entry entry : groupedOps.entrySet()) {
                int columnIndex = (Integer)entry.getKey();
                for (WindowAggregateOp operation : ((ColumnWindowOps)entry.getValue()).operations()) {
                    aggColumnIndexes[opIndex] = columnIndex;
                    aggOperationIds[opIndex] = operation.getAggregateOp().nativeId;
                    aggPrecedingWindows[opIndex] = operation.getWindowOptions().getPreceding();
                    aggFollowingWindows[opIndex] = operation.getWindowOptions().getFollowing();
                    aggMinPeriods[opIndex] = operation.getWindowOptions().getMinPeriods();
                    ++opIndex;
                }
            }
            assert (opIndex == totalOps) : opIndex + " == " + totalOps;
            try (Table aggregate = new Table(Table.rollingWindowAggregate(this.operation.table.nativeHandle, this.operation.indices, aggColumnIndexes, aggOperationIds, aggMinPeriods, aggPrecedingWindows, aggFollowingWindows, this.groupByOptions.getIgnoreNullKeys()));){
                ColumnVector[] finalCols = new ColumnVector[windowAggregates.length];
                int inputColumn = 0;
                for (ColumnWindowOps ops : groupedOps.values()) {
                    for (List<Integer> indices : ops.outputIndices()) {
                        for (int outIndex : indices) {
                            finalCols[outIndex] = aggregate.getColumn(inputColumn);
                        }
                        ++inputColumn;
                    }
                }
                Table table = new Table(finalCols);
                return table;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table aggregateWindowsOverTimeRanges(WindowAggregate ... windowAggregates) {
            TreeMap<Integer, ColumnWindowOps> groupedOps = new TreeMap<Integer, ColumnWindowOps>();
            int totalOps = 0;
            for (int outputIndex = 0; outputIndex < windowAggregates.length; ++outputIndex) {
                WindowAggregate agg = windowAggregates[outputIndex];
                if (agg.getOp().getWindowOptions().getFrameType() != WindowOptions.FrameType.RANGE) {
                    throw new IllegalArgumentException("Expected time-range-based window specification. Unexpected window type: " + (Object)((Object)agg.getOp().getWindowOptions().getFrameType()));
                }
                ColumnWindowOps ops = groupedOps.computeIfAbsent(agg.getColumnIndex(), idx -> new ColumnWindowOps());
                totalOps += ops.add(agg.getOp(), outputIndex);
            }
            int[] aggColumnIndexes = new int[totalOps];
            int[] timestampColumnIndexes = new int[totalOps];
            boolean[] isTimestampOrderAscending = new boolean[totalOps];
            int[] aggOperationIds = new int[totalOps];
            int[] aggPrecedingWindows = new int[totalOps];
            int[] aggFollowingWindows = new int[totalOps];
            int[] aggMinPeriods = new int[totalOps];
            int opIndex = 0;
            for (Map.Entry entry : groupedOps.entrySet()) {
                int columnIndex = (Integer)entry.getKey();
                for (WindowAggregateOp operation : ((ColumnWindowOps)entry.getValue()).operations()) {
                    aggColumnIndexes[opIndex] = columnIndex;
                    aggOperationIds[opIndex] = operation.getAggregateOp().nativeId;
                    aggPrecedingWindows[opIndex] = operation.getWindowOptions().getPreceding();
                    aggFollowingWindows[opIndex] = operation.getWindowOptions().getFollowing();
                    aggMinPeriods[opIndex] = operation.getWindowOptions().getMinPeriods();
                    assert (operation.getWindowOptions().getFrameType() == WindowOptions.FrameType.RANGE);
                    timestampColumnIndexes[opIndex] = operation.getWindowOptions().getTimestampColumnIndex();
                    isTimestampOrderAscending[opIndex] = operation.getWindowOptions().isTimestampOrderAscending();
                    ++opIndex;
                }
            }
            assert (opIndex == totalOps) : opIndex + " == " + totalOps;
            try (Table aggregate = new Table(Table.timeRangeRollingWindowAggregate(this.operation.table.nativeHandle, this.operation.indices, timestampColumnIndexes, isTimestampOrderAscending, aggColumnIndexes, aggOperationIds, aggMinPeriods, aggPrecedingWindows, aggFollowingWindows, this.groupByOptions.getIgnoreNullKeys()));){
                ColumnVector[] finalCols = new ColumnVector[windowAggregates.length];
                int inputColumn = 0;
                for (ColumnWindowOps ops : groupedOps.values()) {
                    for (List<Integer> indices : ops.outputIndices()) {
                        for (int outIndex : indices) {
                            finalCols[outIndex] = aggregate.getColumn(inputColumn);
                        }
                        ++inputColumn;
                    }
                }
                Table table = new Table(finalCols);
                return table;
            }
        }
    }

    private static final class ColumnWindowOps {
        private final TreeMap<WindowAggregateOp, List<Integer>> ops = new TreeMap();

        private ColumnWindowOps() {
        }

        public int add(WindowAggregateOp op, int index) {
            int ret = 0;
            List<Integer> indexes = this.ops.get(op);
            if (indexes == null) {
                ++ret;
                indexes = new ArrayList<Integer>();
                this.ops.put(op, indexes);
            }
            indexes.add(index);
            return ret;
        }

        public Set<WindowAggregateOp> operations() {
            return this.ops.keySet();
        }

        public Collection<List<Integer>> outputIndices() {
            return this.ops.values();
        }
    }

    private static final class ColumnOps {
        private final TreeMap<AggregateOp, List<Integer>> ops = new TreeMap();

        private ColumnOps() {
        }

        public int add(AggregateOp op, int index) {
            int ret = 0;
            List<Integer> indexes = this.ops.get((Object)op);
            if (indexes == null) {
                ++ret;
                indexes = new ArrayList<Integer>();
                this.ops.put(op, indexes);
            }
            indexes.add(index);
            return ret;
        }

        public Set<AggregateOp> operations() {
            return this.ops.keySet();
        }

        public Collection<List<Integer>> outputIndices() {
            return this.ops.values();
        }
    }

    private static final class Operation {
        final int[] indices;
        final Table table;

        Operation(Table table, int ... indices) {
            this.indices = indices;
            this.table = table;
        }
    }

    public static final class OrderByArg {
        final int index;
        final boolean isDescending;
        final boolean isNullSmallest;

        OrderByArg(int index, boolean isDescending, boolean isNullSmallest) {
            this.index = index;
            this.isDescending = isDescending;
            this.isNullSmallest = isNullSmallest;
        }
    }

    private static class ORCTableWriter
    implements TableWriter {
        private long handle;
        HostBufferConsumer consumer;

        private ORCTableWriter(ORCWriterOptions options, File outputFile) {
            this.handle = Table.writeORCFileBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, outputFile.getAbsolutePath());
            this.consumer = null;
        }

        private ORCTableWriter(ORCWriterOptions options, HostBufferConsumer consumer) {
            this.handle = Table.writeORCBufferBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, consumer);
            this.consumer = consumer;
        }

        @Override
        public void write(Table table) {
            if (this.handle == 0L) {
                throw new IllegalStateException("Writer was already closed");
            }
            Table.writeORCChunk(this.handle, table.nativeHandle, table.getDeviceMemorySize());
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.writeORCEnd(this.handle);
            }
            this.handle = 0L;
            if (this.consumer != null) {
                this.consumer.done();
                this.consumer = null;
            }
        }
    }

    private static class ParquetTableWriter
    implements TableWriter {
        private long handle;
        HostBufferConsumer consumer;

        private ParquetTableWriter(ParquetWriterOptions options, File outputFile) {
            this.consumer = null;
            this.handle = Table.writeParquetFileBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, options.getStatisticsFrequency().nativeId, outputFile.getAbsolutePath());
        }

        private ParquetTableWriter(ParquetWriterOptions options, HostBufferConsumer consumer) {
            this.handle = Table.writeParquetBufferBegin(options.getColumnNames(), options.getColumnNullability(), options.getMetadataKeys(), options.getMetadataValues(), options.getCompressionType().nativeId, options.getStatisticsFrequency().nativeId, consumer);
            this.consumer = consumer;
        }

        @Override
        public void write(Table table) {
            if (this.handle == 0L) {
                throw new IllegalStateException("Writer was already closed");
            }
            Table.writeParquetChunk(this.handle, table.nativeHandle, table.getDeviceMemorySize());
        }

        @Override
        public void close() throws CudfException {
            if (this.handle != 0L) {
                Table.writeParquetEnd(this.handle);
            }
            this.handle = 0L;
            if (this.consumer != null) {
                this.consumer.done();
                this.consumer = null;
            }
        }
    }
}

