/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

class UnsafeMemoryAccessor {
    public static final long BYTE_ARRAY_OFFSET;
    public static final long SHORT_ARRAY_OFFSET;
    public static final long INT_ARRAY_OFFSET;
    public static final long LONG_ARRAY_OFFSET;
    public static final long FLOAT_ARRAY_OFFSET;
    public static final long DOUBLE_ARRAY_OFFSET;
    private static final Unsafe UNSAFE;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static Logger log;

    UnsafeMemoryAccessor() {
    }

    public static int pageSize() {
        return UNSAFE.pageSize();
    }

    public static long allocate(long bytes) {
        return UNSAFE.allocateMemory(bytes);
    }

    public static void free(long address) {
        UNSAFE.freeMemory(address);
    }

    public static void setMemory(long address, long size, byte value) {
        UNSAFE.setMemory(address, size, value);
    }

    public static void setByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    public static void setBytes(long address, byte[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, BYTE_ARRAY_OFFSET + offset, null, address, len);
    }

    public static byte getByte(long address) {
        return UNSAFE.getByte(address);
    }

    public static void getBytes(byte[] dst, long dstOffset, long address, long len) {
        UnsafeMemoryAccessor.copyMemory(null, address, dst, BYTE_ARRAY_OFFSET + dstOffset, len);
    }

    public static int getInt(long address) {
        return UNSAFE.getInt(address);
    }

    public static void setInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    public static void setInts(long address, int[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, INT_ARRAY_OFFSET + offset * 4L, null, address, len * 4L);
    }

    public static void setLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    public static void setLongs(long address, long[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, LONG_ARRAY_OFFSET + offset * 8L, null, address, len * 8L);
    }

    public static long getLong(long address) {
        return UNSAFE.getLong(address);
    }

    public static short getShort(long address) {
        return UNSAFE.getShort(address);
    }

    public static void setShort(long address, short value) {
        UNSAFE.putShort(address, value);
    }

    public static void setShorts(long address, short[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, SHORT_ARRAY_OFFSET + offset * 2L, null, address, len * 2L);
    }

    public static void setDouble(long address, double value) {
        UNSAFE.putDouble(address, value);
    }

    public static void setDoubles(long address, double[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, DOUBLE_ARRAY_OFFSET + offset * 8L, null, address, len * 8L);
    }

    public static double getDouble(long address) {
        return UNSAFE.getDouble(address);
    }

    public static float getFloat(long address) {
        return UNSAFE.getFloat(address);
    }

    public static void setFloat(long address, float value) {
        UNSAFE.putFloat(address, value);
    }

    public static void setFloats(long address, float[] values, long offset, long len) {
        UnsafeMemoryAccessor.copyMemory(values, FLOAT_ARRAY_OFFSET + offset * 4L, null, address, len * 4L);
    }

    public static boolean getBoolean(long address) {
        return UnsafeMemoryAccessor.getByte(address) != 0;
    }

    public static void setBoolean(long address, boolean value) {
        UnsafeMemoryAccessor.setByte(address, (byte)(value ? 1 : 0));
    }

    public static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        if (dstOffset < srcOffset) {
            while (length > 0L) {
                long size = Math.min(length, 0x100000L);
                UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, size);
                length -= size;
                srcOffset += size;
                dstOffset += size;
            }
        } else {
            srcOffset += length;
            dstOffset += length;
            while (length > 0L) {
                long size = Math.min(length, 0x100000L);
                UNSAFE.copyMemory(src, srcOffset -= size, dst, dstOffset -= size, size);
                length -= size;
            }
        }
    }

    static {
        log = LoggerFactory.getLogger(UnsafeMemoryAccessor.class);
        Unsafe unsafe = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
            BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
            SHORT_ARRAY_OFFSET = unsafe.arrayBaseOffset(short[].class);
            INT_ARRAY_OFFSET = unsafe.arrayBaseOffset(int[].class);
            LONG_ARRAY_OFFSET = unsafe.arrayBaseOffset(long[].class);
            FLOAT_ARRAY_OFFSET = unsafe.arrayBaseOffset(float[].class);
            DOUBLE_ARRAY_OFFSET = unsafe.arrayBaseOffset(double[].class);
        }
        catch (Throwable t) {
            log.error("Failed to get unsafe object, got this error: ", t);
            UNSAFE = null;
            throw new NullPointerException("Failed to get unsafe object, got this error: " + t.getMessage());
        }
        UNSAFE = unsafe;
    }
}

