/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.AggregateOp;
import ai.rapids.cudf.WindowAggregateOp;
import ai.rapids.cudf.WindowOptions;

public class WindowAggregate {
    private final int columnIndex;
    private final WindowAggregateOp windowAggregateOp;

    private WindowAggregate(AggregateOp op, int columnIndex, WindowOptions windowOptions) {
        this.columnIndex = columnIndex;
        this.windowAggregateOp = new WindowAggregateOp(op, windowOptions);
    }

    public static WindowAggregate count(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.COUNT_ALL, columnIndex, windowOptions);
    }

    public static WindowAggregate min(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.MIN, columnIndex, windowOptions);
    }

    public static WindowAggregate max(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.MAX, columnIndex, windowOptions);
    }

    public static WindowAggregate sum(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.SUM, columnIndex, windowOptions);
    }

    public static WindowAggregate mean(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.MEAN, columnIndex, windowOptions);
    }

    public static WindowAggregate median(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.MEDIAN, columnIndex, windowOptions);
    }

    public static WindowAggregate row_number(int columnIndex, WindowOptions windowOptions) {
        return new WindowAggregate(AggregateOp.ROW_NUMBER, columnIndex, windowOptions);
    }

    int getColumnIndex() {
        return this.columnIndex;
    }

    WindowAggregateOp getOp() {
        return this.windowAggregateOp;
    }
}

