/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.AggregateOp;
import ai.rapids.cudf.WindowOptions;

public class WindowAggregateOp
implements Comparable<WindowAggregateOp> {
    private AggregateOp aggregateOp;
    private WindowOptions windowOptions;

    public WindowAggregateOp(AggregateOp aggregateOp, WindowOptions windowOptions) {
        this.aggregateOp = aggregateOp;
        this.windowOptions = windowOptions;
        this.assertIsValid();
    }

    public AggregateOp getAggregateOp() {
        return this.aggregateOp;
    }

    public WindowOptions getWindowOptions() {
        return this.windowOptions;
    }

    private void assertIsValid() {
        if (this.aggregateOp == null) {
            throw new IllegalArgumentException("Aggregation-operation cannot be null!");
        }
        if (this.windowOptions == null) {
            throw new IllegalArgumentException("WindowOptions cannot be null!");
        }
        if (this.windowOptions.getPrecedingCol() != null || this.windowOptions.getFollowingCol() != null) {
            throw new UnsupportedOperationException("Dynamic windows (via columns) are currently unsupported!");
        }
    }

    @Override
    public int compareTo(WindowAggregateOp rhs) {
        int compareAggOps = this.aggregateOp.compareTo(rhs.aggregateOp);
        if (compareAggOps != 0) {
            return compareAggOps;
        }
        int comparePreceding = Integer.compare(this.windowOptions.getPreceding(), rhs.windowOptions.getPreceding());
        if (comparePreceding != 0) {
            return comparePreceding;
        }
        int compareFollowing = Integer.compare(this.windowOptions.getFollowing(), rhs.windowOptions.getFollowing());
        if (compareFollowing != 0) {
            return compareFollowing;
        }
        int compareTimestampColumnIndex = Integer.compare(this.windowOptions.getTimestampColumnIndex(), rhs.windowOptions.getTimestampColumnIndex());
        return compareTimestampColumnIndex != 0 ? compareTimestampColumnIndex : Integer.compare(this.windowOptions.getMinPeriods(), rhs.windowOptions.getMinPeriods());
    }
}

