/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;

public class WindowOptions {
    private final int preceding;
    private final int minPeriods;
    private final int following;
    private final ColumnVector precedingCol;
    private final ColumnVector followingCol;
    private final int timestampColumnIndex;
    private final boolean timestampOrderAscending;
    private FrameType frameType = FrameType.ROWS;

    private WindowOptions(Builder builder) {
        this.preceding = builder.preceding;
        this.minPeriods = builder.minPeriods;
        this.following = builder.following;
        this.precedingCol = builder.precedingCol;
        this.followingCol = builder.followingCol;
        this.timestampColumnIndex = builder.timestampColumnIndex;
        this.timestampOrderAscending = builder.timestampOrderAscending;
        this.frameType = this.timestampColumnIndex == -1 ? FrameType.ROWS : FrameType.RANGE;
    }

    public static Builder builder() {
        return new Builder();
    }

    int getMinPeriods() {
        return this.minPeriods;
    }

    int getPreceding() {
        return this.preceding;
    }

    int getFollowing() {
        return this.following;
    }

    ColumnVector getPrecedingCol() {
        return this.precedingCol;
    }

    ColumnVector getFollowingCol() {
        return this.followingCol;
    }

    int getTimestampColumnIndex() {
        return this.timestampColumnIndex;
    }

    boolean isTimestampOrderAscending() {
        return this.timestampOrderAscending;
    }

    FrameType getFrameType() {
        return this.frameType;
    }

    public static class Builder {
        private int minPeriods = 1;
        private int preceding = 0;
        private int following = 1;
        boolean staticSet = false;
        private ColumnVector precedingCol = null;
        private ColumnVector followingCol = null;
        private int timestampColumnIndex = -1;
        private boolean timestampOrderAscending = true;

        public Builder minPeriods(int minPeriods) {
            if (minPeriods < 0) {
                throw new IllegalArgumentException("Minimum observations must be non negative");
            }
            this.minPeriods = minPeriods;
            return this;
        }

        public Builder window(ColumnVector precedingCol, ColumnVector followingCol) {
            assert (precedingCol != null && precedingCol.getNullCount() == 0L);
            assert (followingCol != null && followingCol.getNullCount() == 0L);
            this.precedingCol = precedingCol;
            this.followingCol = followingCol;
            return this;
        }

        public Builder timestampColumnIndex(int index) {
            this.timestampColumnIndex = index;
            return this;
        }

        public Builder timestampAscending() {
            this.timestampOrderAscending = true;
            return this;
        }

        public Builder timestampDescending() {
            this.timestampOrderAscending = false;
            return this;
        }

        public Builder window(int preceding, int following) {
            this.preceding = preceding;
            this.following = following;
            this.staticSet = true;
            return this;
        }

        public WindowOptions build() {
            if (this.staticSet && this.precedingCol != null) {
                throw new IllegalArgumentException("Cannot set both a static window and a non-static window");
            }
            return new WindowOptions(this);
        }
    }

    static enum FrameType {
        ROWS,
        RANGE;

    }
}

