/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CompressionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class WriterOptions {
    private final CompressionType compressionType;
    private final String[] columnNames;
    private final boolean[] columnNullability;
    private final Map<String, String> metadata;

    <T extends WriterBuilder> WriterOptions(T builder) {
        this.compressionType = builder.compressionType;
        this.columnNames = builder.columnNames.toArray(new String[builder.columnNames.size()]);
        this.columnNullability = new boolean[builder.columnNullability.size()];
        for (int i = 0; i < builder.columnNullability.size(); ++i) {
            this.columnNullability[i] = builder.columnNullability.get(i);
        }
        this.metadata = Collections.unmodifiableMap(builder.metadata);
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    String[] getMetadataKeys() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    String[] getMetadataValues() {
        return this.metadata.values().toArray(new String[this.metadata.size()]);
    }

    public boolean[] getColumnNullability() {
        return this.columnNullability;
    }

    protected static class WriterBuilder<T extends WriterBuilder> {
        final List<String> columnNames = new ArrayList<String>();
        final List<Boolean> columnNullability = new ArrayList<Boolean>();
        final Map<String, String> metadata = new LinkedHashMap<String, String>();
        CompressionType compressionType = CompressionType.AUTO;

        protected WriterBuilder() {
        }

        public T withColumnNames(String ... columnNames) {
            this.columnNames.addAll(Arrays.asList(columnNames));
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNullability.add(true);
            }
            return (T)this;
        }

        public T withNotNullableColumnNames(String ... columnNames) {
            this.columnNames.addAll(Arrays.asList(columnNames));
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNullability.add(false);
            }
            return (T)this;
        }

        public T withMetadata(String key, String value) {
            this.metadata.put(key, value);
            return (T)this;
        }

        public T withMetadata(Map<String, String> metadata) {
            this.metadata.putAll(metadata);
            return (T)this;
        }

        public T withCompressionType(CompressionType compression) {
            this.compressionType = compression;
            return (T)this;
        }
    }
}

