/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;

public interface BinaryOperable {
    public static DType implicitConversion(BinaryOperable lhs, BinaryOperable rhs) {
        DType a = lhs.getType();
        DType b = rhs.getType();
        if (a == DType.FLOAT64 || b == DType.FLOAT64) {
            return DType.FLOAT64;
        }
        if (a == DType.FLOAT32 || b == DType.FLOAT32) {
            return DType.FLOAT32;
        }
        if (a == DType.INT64 || b == DType.INT64 || a == DType.DATE64 || b == DType.DATE64 || a == DType.TIMESTAMP || b == DType.TIMESTAMP) {
            return DType.INT64;
        }
        if (a == DType.INT32 || b == DType.INT32 || a == DType.DATE32 || b == DType.DATE32) {
            return DType.INT32;
        }
        if (a == DType.INT16 || b == DType.INT16) {
            return DType.INT16;
        }
        if (a == DType.INT8 || b == DType.INT8) {
            return DType.INT8;
        }
        if (a == DType.BOOL8 || b == DType.BOOL8) {
            return DType.BOOL8;
        }
        throw new IllegalArgumentException("Unsupported types " + (Object)((Object)a) + " and " + (Object)((Object)b));
    }

    public DType getType();

    public ColumnVector binaryOp(BinaryOp var1, BinaryOperable var2, DType var3);

    default public ColumnVector add(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.ADD, rhs, outType);
    }

    default public ColumnVector add(BinaryOperable rhs) {
        return this.add(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector sub(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.SUB, rhs, outType);
    }

    default public ColumnVector sub(BinaryOperable rhs) {
        return this.sub(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector mul(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.MUL, rhs, outType);
    }

    default public ColumnVector mul(BinaryOperable rhs) {
        return this.mul(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector div(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.DIV, rhs, outType);
    }

    default public ColumnVector div(BinaryOperable rhs) {
        return this.div(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector trueDiv(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.TRUE_DIV, rhs, outType);
    }

    default public ColumnVector trueDiv(BinaryOperable rhs) {
        return this.trueDiv(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector floorDiv(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.FLOOR_DIV, rhs, outType);
    }

    default public ColumnVector floorDiv(BinaryOperable rhs) {
        return this.floorDiv(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector mod(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.MOD, rhs, outType);
    }

    default public ColumnVector mod(BinaryOperable rhs) {
        return this.mod(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector pow(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.POW, rhs, outType);
    }

    default public ColumnVector pow(BinaryOperable rhs) {
        return this.pow(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector equalTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.EQUAL, rhs, outType);
    }

    default public ColumnVector equalTo(BinaryOperable rhs) {
        return this.equalTo(rhs, DType.BOOL8);
    }

    default public ColumnVector notEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.NOT_EQUAL, rhs, outType);
    }

    default public ColumnVector notEqualTo(BinaryOperable rhs) {
        return this.notEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector lessThan(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LESS, rhs, outType);
    }

    default public ColumnVector lessThan(BinaryOperable rhs) {
        return this.lessThan(rhs, DType.BOOL8);
    }

    default public ColumnVector greaterThan(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.GREATER, rhs, outType);
    }

    default public ColumnVector greaterThan(BinaryOperable rhs) {
        return this.greaterThan(rhs, DType.BOOL8);
    }

    default public ColumnVector lessOrEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LESS_EQUAL, rhs, outType);
    }

    default public ColumnVector lessOrEqualTo(BinaryOperable rhs) {
        return this.lessOrEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector greaterOrEqualTo(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.GREATER_EQUAL, rhs, outType);
    }

    default public ColumnVector greaterOrEqualTo(BinaryOperable rhs) {
        return this.greaterOrEqualTo(rhs, DType.BOOL8);
    }

    default public ColumnVector bitAnd(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_AND, rhs, outType);
    }

    default public ColumnVector bitAnd(BinaryOperable rhs) {
        return this.bitAnd(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector bitOr(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_OR, rhs, outType);
    }

    default public ColumnVector bitOr(BinaryOperable rhs) {
        return this.bitOr(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector bitXor(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.BITWISE_XOR, rhs, outType);
    }

    default public ColumnVector bitXor(BinaryOperable rhs) {
        return this.bitXor(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector and(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LOGICAL_AND, rhs, outType);
    }

    default public ColumnVector and(BinaryOperable rhs) {
        return this.and(rhs, BinaryOperable.implicitConversion(this, rhs));
    }

    default public ColumnVector or(BinaryOperable rhs, DType outType) {
        return this.binaryOp(BinaryOp.LOGICAL_OR, rhs, outType);
    }

    default public ColumnVector or(BinaryOperable rhs) {
        return this.or(rhs, BinaryOperable.implicitConversion(this, rhs));
    }
}

