/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.ColumnVectorCleaner;
import ai.rapids.cudf.Cudf;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.ReductionOp;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.TimeUnit;
import ai.rapids.cudf.UnaryOp;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnVector
implements AutoCloseable,
BinaryOperable {
    static final boolean REF_COUNT_DEBUG = Boolean.getBoolean("ai.rapids.refcount.debug");
    private static final Logger log = LoggerFactory.getLogger(ColumnVector.class);
    private final DType type;
    private final OffHeapState offHeap = new OffHeapState();
    private TimeUnit tsTimeUnit;
    private long rows;
    private long nullCount;
    private int refCount;

    private static <T> String stringJoin(String delim, Iterable<T> it) {
        return String.join((CharSequence)delim, StreamSupport.stream(it.spliterator(), false).map(i -> i.toString()).collect(Collectors.toList()));
    }

    ColumnVector(long nativePointer) {
        assert (nativePointer != 0L);
        ColumnVectorCleaner.register(this, this.offHeap);
        this.offHeap.nativeCudfColumnHandle = nativePointer;
        this.type = ColumnVector.getDType(nativePointer);
        this.offHeap.hostData = null;
        this.rows = ColumnVector.getRowCount(nativePointer);
        this.nullCount = ColumnVector.getNullCount(nativePointer);
        this.tsTimeUnit = ColumnVector.getTimeUnit(nativePointer);
        DeviceMemoryBuffer data = null;
        if (this.type != DType.STRING) {
            data = new DeviceMemoryBuffer(ColumnVector.getDataPtr(nativePointer), this.rows * (long)this.type.sizeInBytes);
        }
        DeviceMemoryBuffer valid = null;
        long validPtr = ColumnVector.getValidPtr(nativePointer);
        if (validPtr != 0L) {
            valid = new DeviceMemoryBuffer(validPtr, BitVectorHelper.getValidityLengthInBytes(this.rows));
        }
        this.offHeap.deviceData = new BufferEncapsulator<Object>(data, valid, null);
        this.refCount = 0;
        this.incRefCount();
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, long nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer) {
        this(type, tsTimeUnit, rows, nullCount, hostDataBuffer, hostValidityBuffer, null);
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, long nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer, HostMemoryBuffer offsetBuffer) {
        if (nullCount > 0L && hostValidityBuffer == null) {
            throw new IllegalStateException("Buffer cannot have a nullCount without a validity buffer");
        }
        if (type == DType.STRING_CATEGORY || type == DType.STRING) {
            assert (offsetBuffer != null) : "offsets must be provided for STRING and STRING_CATEGORY";
        } else assert (offsetBuffer == null) : "offsets are only supported for STRING and STRING_CATEGORY";
        this.tsTimeUnit = type == DType.TIMESTAMP ? (tsTimeUnit == TimeUnit.NONE ? TimeUnit.MILLISECONDS : tsTimeUnit) : TimeUnit.NONE;
        ColumnVectorCleaner.register(this, this.offHeap);
        this.offHeap.hostData = new BufferEncapsulator<HostMemoryBuffer>(hostDataBuffer, hostValidityBuffer, offsetBuffer);
        this.offHeap.deviceData = null;
        this.rows = rows;
        this.nullCount = nullCount;
        this.type = type;
        this.refCount = 0;
        this.incRefCount();
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, DeviceMemoryBuffer dataBuffer, DeviceMemoryBuffer validityBuffer) {
        assert (type != DType.STRING && type != DType.STRING_CATEGORY) : "STRING AND STRING_CATEGORY NOT SUPPORTED BY THIS CONSTRUCTOR";
        ColumnVectorCleaner.register(this, this.offHeap);
        this.tsTimeUnit = type == DType.TIMESTAMP ? (tsTimeUnit == TimeUnit.NONE ? TimeUnit.MILLISECONDS : tsTimeUnit) : TimeUnit.NONE;
        this.offHeap.deviceData = new BufferEncapsulator<Object>(dataBuffer, validityBuffer, null);
        this.offHeap.hostData = null;
        this.rows = rows;
        this.nullCount = 0L;
        this.type = type;
        this.refCount = 0;
        this.incRefCount();
    }

    @Override
    public final void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            log.error("Close called too many times on {}", (Object)this);
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times");
        }
    }

    public String toString() {
        return "ColumnVector{rows=" + this.rows + ", type=" + (Object)((Object)this.type) + ", hostData=" + this.offHeap.hostData + ", deviceData=" + this.offHeap.deviceData + ", nullCount=" + this.nullCount + ", cudfColumn=" + this.offHeap.nativeCudfColumnHandle + '}';
    }

    public ColumnVector incRefCount() {
        ++this.refCount;
        this.offHeap.addRef();
        return this;
    }

    public long getRowCount() {
        return this.rows;
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public boolean hasValidityVector() {
        boolean ret = this.offHeap.hostData != null ? this.offHeap.hostData.valid != null : this.offHeap.deviceData.valid != null;
        return ret;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    public TimeUnit getTimeUnit() {
        return this.tsTimeUnit;
    }

    private void checkHasDeviceData() {
        if (this.offHeap.deviceData == null && this.rows != 0L) {
            throw new IllegalStateException("Vector not on Device");
        }
    }

    private void checkHasHostData() {
        if (this.offHeap.hostData == null && this.rows != 0L) {
            throw new IllegalStateException("Vector not on Host");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureOnDevice() {
        if (this.offHeap.deviceData == null && this.rows != 0L) {
            this.checkHasHostData();
            if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) assert (this.offHeap.hostData.offsets != null);
            DeviceMemoryBuffer deviceDataBuffer = null;
            MemoryBuffer deviceValidityBuffer = null;
            if (this.type == DType.STRING_CATEGORY) {
                deviceDataBuffer = DeviceMemoryBuffer.allocate(this.rows * (long)this.type.sizeInBytes);
            } else if (this.type != DType.STRING) {
                deviceDataBuffer = DeviceMemoryBuffer.allocate(((HostMemoryBuffer)this.offHeap.hostData.data).getLength());
            }
            boolean needsCleanup = true;
            try {
                if (this.hasNulls()) {
                    deviceValidityBuffer = DeviceMemoryBuffer.allocate(((HostMemoryBuffer)this.offHeap.hostData.valid).getLength());
                }
                this.offHeap.deviceData = new BufferEncapsulator<Object>(deviceDataBuffer, deviceValidityBuffer, null);
                needsCleanup = false;
            }
            finally {
                if (needsCleanup) {
                    if (deviceDataBuffer != null) {
                        deviceDataBuffer.close();
                    }
                    if (deviceValidityBuffer != null) {
                        deviceValidityBuffer.close();
                    }
                }
            }
            if (this.offHeap.deviceData.valid != null) {
                ((DeviceMemoryBuffer)this.offHeap.deviceData.valid).copyFromHostBuffer((HostMemoryBuffer)this.offHeap.hostData.valid);
            }
            if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) {
                this.offHeap.nativeCudfColumnHandle = ColumnVector.allocateCudfColumn();
                ColumnVector.cudfColumnViewStrings(this.offHeap.nativeCudfColumnHandle, ((HostMemoryBuffer)this.offHeap.hostData.data).getAddress(), ((HostMemoryBuffer)this.offHeap.hostData.offsets).getAddress(), this.offHeap.hostData.valid == null ? 0L : ((DeviceMemoryBuffer)this.offHeap.deviceData.valid).getAddress(), this.offHeap.deviceData.data == null ? 0L : ((DeviceMemoryBuffer)this.offHeap.deviceData.data).getAddress(), (int)this.rows, this.type.nativeId, (int)this.getNullCount());
            } else {
                ((DeviceMemoryBuffer)this.offHeap.deviceData.data).copyFromHostBuffer((HostMemoryBuffer)this.offHeap.hostData.data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureOnHost() {
        if (this.offHeap.hostData == null && this.rows != 0L) {
            this.checkHasDeviceData();
            MemoryBuffer hostDataBuffer = null;
            MemoryBuffer hostValidityBuffer = null;
            HostMemoryBuffer hostOffsetsBuffer = null;
            boolean needsCleanup = true;
            try {
                if (this.offHeap.deviceData.valid != null) {
                    hostValidityBuffer = HostMemoryBuffer.allocate(((DeviceMemoryBuffer)this.offHeap.deviceData.valid).getLength());
                }
                if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) {
                    long[] vals = ColumnVector.getStringDataAndOffsetsBack(this.getNativeCudfColumnAddress());
                    hostDataBuffer = new HostMemoryBuffer(vals[0], vals[1]);
                    hostOffsetsBuffer = new HostMemoryBuffer(vals[2], vals[3]);
                } else {
                    hostDataBuffer = HostMemoryBuffer.allocate(((DeviceMemoryBuffer)this.offHeap.deviceData.data).getLength());
                }
                this.offHeap.hostData = new BufferEncapsulator<Object>(hostDataBuffer, hostValidityBuffer, hostOffsetsBuffer);
                needsCleanup = false;
            }
            finally {
                if (needsCleanup) {
                    if (hostDataBuffer != null) {
                        hostDataBuffer.close();
                    }
                    if (hostValidityBuffer != null) {
                        hostValidityBuffer.close();
                    }
                }
            }
            if (this.type != DType.STRING && this.type != DType.STRING_CATEGORY) {
                ((HostMemoryBuffer)this.offHeap.hostData.data).copyFromDeviceBuffer((DeviceMemoryBuffer)this.offHeap.deviceData.data);
            }
            if (this.offHeap.hostData.valid != null) {
                ((HostMemoryBuffer)this.offHeap.hostData.valid).copyFromDeviceBuffer((DeviceMemoryBuffer)this.offHeap.deviceData.valid);
            }
        }
    }

    public boolean isNull(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        if (this.hasNulls()) {
            this.checkHasHostData();
            return BitVectorHelper.isNull((HostMemoryBuffer)this.offHeap.hostData.valid, index);
        }
        return false;
    }

    boolean isNullExtendedRange(long index) {
        long maxNullRow = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows) * 8L;
        assert (index >= 0L && index < maxNullRow) : "TEST: index is out of range 0 <= " + index + " < " + maxNullRow;
        if (this.hasNulls()) {
            this.checkHasHostData();
            return BitVectorHelper.isNull((HostMemoryBuffer)this.offHeap.hostData.valid, index);
        }
        return false;
    }

    private void assertsForGet(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (this.offHeap.hostData != null) : "data is not on the host";
        assert (!this.isNull(index)) : " value at " + index + " is null";
    }

    public byte getByte(long index) {
        assert (this.type == DType.INT8 || this.type == DType.BOOL8);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getByte(index * (long)this.type.sizeInBytes);
    }

    public final short getShort(long index) {
        assert (this.type == DType.INT16);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getShort(index * (long)this.type.sizeInBytes);
    }

    public final int getInt(long index) {
        assert (this.type == DType.INT32 || this.type == DType.DATE32);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getInt(index * (long)this.type.sizeInBytes);
    }

    public final long getLong(long index) {
        assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getLong(index * (long)this.type.sizeInBytes);
    }

    public final float getFloat(long index) {
        assert (this.type == DType.FLOAT32);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getFloat(index * (long)this.type.sizeInBytes);
    }

    public final double getDouble(long index) {
        assert (this.type == DType.FLOAT64);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getDouble(index * (long)this.type.sizeInBytes);
    }

    public final boolean getBoolean(long index) {
        assert (this.type == DType.BOOL8);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.hostData.data).getBoolean(index * (long)this.type.sizeInBytes);
    }

    public String getJavaString(long index) {
        assert (this.type == DType.STRING || this.type == DType.STRING_CATEGORY);
        this.assertsForGet(index);
        int start = ((HostMemoryBuffer)this.offHeap.hostData.offsets).getInt(index * 4L);
        int size = ((HostMemoryBuffer)this.offHeap.hostData.offsets).getInt((index + 1L) * 4L) - start;
        byte[] rawData = new byte[size];
        ((HostMemoryBuffer)this.offHeap.hostData.data).getBytes(rawData, 0L, start, size);
        return new String(rawData, StandardCharsets.UTF_8);
    }

    public ColumnVector year() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeYear(this));
    }

    public ColumnVector month() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeMonth(this));
    }

    public ColumnVector day() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeDay(this));
    }

    public ColumnVector hour() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeHour(this));
    }

    public ColumnVector minute() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeMinute(this));
    }

    public ColumnVector second() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeSecond(this));
    }

    public ColumnVector unaryOp(UnaryOp op) {
        return new ColumnVector(Cudf.gdfUnaryMath(this, op, this.type));
    }

    public ColumnVector sin() {
        return this.unaryOp(UnaryOp.SIN);
    }

    public ColumnVector cos() {
        return this.unaryOp(UnaryOp.COS);
    }

    public ColumnVector tan() {
        return this.unaryOp(UnaryOp.TAN);
    }

    public ColumnVector arcsin() {
        return this.unaryOp(UnaryOp.ARCSIN);
    }

    public ColumnVector arccos() {
        return this.unaryOp(UnaryOp.ARCCOS);
    }

    public ColumnVector arctan() {
        return this.unaryOp(UnaryOp.ARCTAN);
    }

    public ColumnVector exp() {
        return this.unaryOp(UnaryOp.EXP);
    }

    public ColumnVector log() {
        return this.unaryOp(UnaryOp.LOG);
    }

    public ColumnVector sqrt() {
        return this.unaryOp(UnaryOp.SQRT);
    }

    public ColumnVector ceil() {
        return this.unaryOp(UnaryOp.CEIL);
    }

    public ColumnVector floor() {
        return this.unaryOp(UnaryOp.FLOOR);
    }

    public ColumnVector abs() {
        return this.unaryOp(UnaryOp.ABS);
    }

    public ColumnVector bitInvert() {
        return this.unaryOp(UnaryOp.BIT_INVERT);
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnVector) {
            ColumnVector cvRhs = (ColumnVector)rhs;
            assert (this.rows == cvRhs.getRowCount());
            return new ColumnVector(Cudf.gdfBinaryOp(this, cvRhs, op, outType));
        }
        if (rhs instanceof Scalar) {
            Scalar sRhs = (Scalar)rhs;
            return new ColumnVector(Cudf.gdfBinaryOp(this, sRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with ColumnVector");
    }

    public ColumnVector filter(ColumnVector mask) {
        assert (mask.getType() == DType.BOOL8);
        assert (this.rows == 0L || this.rows == mask.getRowCount());
        return new ColumnVector(Cudf.filter(this, mask));
    }

    public Scalar sum() {
        return this.sum(this.type);
    }

    public Scalar sum(DType outType) {
        return this.reduction(ReductionOp.SUM, outType);
    }

    public Scalar min() {
        return this.min(this.type);
    }

    public Scalar min(DType outType) {
        return this.reduction(ReductionOp.MIN, outType);
    }

    public Scalar max() {
        return this.max(this.type);
    }

    public Scalar max(DType outType) {
        return this.reduction(ReductionOp.MAX, outType);
    }

    public Scalar product() {
        return this.product(this.type);
    }

    public Scalar product(DType outType) {
        return this.reduction(ReductionOp.PRODUCT, outType);
    }

    public Scalar sumOfSquares() {
        return this.sumOfSquares(this.type);
    }

    public Scalar sumOfSquares(DType outType) {
        return this.reduction(ReductionOp.SUMOFSQUARES, outType);
    }

    public Scalar reduction(ReductionOp op) {
        return this.reduction(op, this.type);
    }

    public Scalar reduction(ReductionOp op, DType outType) {
        return Cudf.reduction(this, op, outType);
    }

    public ColumnVector not() {
        return this.unaryOp(UnaryOp.NOT);
    }

    public ColumnVector castTo(DType type, TimeUnit unit) {
        if (this.type == type && this.tsTimeUnit == unit) {
            return this.incRefCount();
        }
        return new ColumnVector(Cudf.gdfCast(this, type, unit));
    }

    public ColumnVector asBytes() {
        return this.castTo(DType.INT8, TimeUnit.NONE);
    }

    public ColumnVector asShorts() {
        return this.castTo(DType.INT16, TimeUnit.NONE);
    }

    public ColumnVector asInts() {
        return this.castTo(DType.INT32, TimeUnit.NONE);
    }

    public ColumnVector asLongs() {
        return this.castTo(DType.INT64, TimeUnit.NONE);
    }

    public ColumnVector asFloats() {
        return this.castTo(DType.FLOAT32, TimeUnit.NONE);
    }

    public ColumnVector asDoubles() {
        return this.castTo(DType.FLOAT64, TimeUnit.NONE);
    }

    public ColumnVector asDate32() {
        return this.castTo(DType.DATE32, TimeUnit.NONE);
    }

    public ColumnVector asDate64() {
        return this.castTo(DType.DATE64, TimeUnit.NONE);
    }

    public ColumnVector asTimestamp(TimeUnit unit) {
        return this.castTo(DType.TIMESTAMP, unit);
    }

    public ColumnVector asStrings() {
        return this.castTo(DType.STRING, TimeUnit.NONE);
    }

    public ColumnVector asStringCategories() {
        return this.castTo(DType.STRING_CATEGORY, TimeUnit.NONE);
    }

    public Scalar getCategoryIndex(Scalar s) {
        if (s.getType() != DType.STRING) {
            throw new IllegalArgumentException("scalar must be a string type");
        }
        return Scalar.fromInt(Cudf.getCategoryIndex(this, s));
    }

    public final long getNativeCudfColumnAddress() {
        if (this.offHeap.nativeCudfColumnHandle == 0L) {
            assert (this.rows <= Integer.MAX_VALUE);
            assert (this.getNullCount() <= Integer.MAX_VALUE);
            this.checkHasDeviceData();
            this.offHeap.nativeCudfColumnHandle = ColumnVector.allocateCudfColumn();
            long dataAddr = 0L;
            long validAddr = 0L;
            if (this.rows != 0L) {
                dataAddr = ((DeviceMemoryBuffer)this.offHeap.deviceData.data).getAddress();
                if (this.offHeap.deviceData.valid != null) {
                    validAddr = ((DeviceMemoryBuffer)this.offHeap.deviceData.valid).getAddress();
                }
            }
            ColumnVector.cudfColumnViewAugmented(this.offHeap.nativeCudfColumnHandle, dataAddr, validAddr, (int)this.rows, this.type.nativeId, (int)this.getNullCount(), this.tsTimeUnit.getNativeId());
        }
        return this.offHeap.nativeCudfColumnHandle;
    }

    private static native long allocateCudfColumn() throws CudfException;

    private static native void cudfColumnViewAugmented(long var0, long var2, long var4, int var6, int var7, int var8, int var9) throws CudfException;

    private static native void cudfColumnViewStrings(long var0, long var2, long var4, long var6, long var8, int var10, int var11, int var12);

    private static native long[] getStringDataAndOffsetsBack(long var0);

    static native void freeCudfColumn(long var0, boolean var2) throws CudfException;

    private static native long getDataPtr(long var0) throws CudfException;

    private static native long getValidPtr(long var0) throws CudfException;

    private static native int getRowCount(long var0) throws CudfException;

    private static DType getDType(long cudfColumnHandle) throws CudfException {
        return DType.fromNative(ColumnVector.getDTypeInternal(cudfColumnHandle));
    }

    private static native int getDTypeInternal(long var0) throws CudfException;

    private static TimeUnit getTimeUnit(long cudfColumnHandle) throws CudfException {
        return TimeUnit.fromNative(ColumnVector.getTimeUnitInternal(cudfColumnHandle));
    }

    private static native int getTimeUnitInternal(long var0) throws CudfException;

    private static native int getNullCount(long var0) throws CudfException;

    private static native long concatenate(long[] var0) throws CudfException;

    public static Builder builder(DType type, int rows) {
        return new Builder(type, TimeUnit.NONE, rows);
    }

    public static Builder builder(DType type, TimeUnit tsTimeUnit, int rows) {
        return new Builder(type, tsTimeUnit, rows);
    }

    public static ColumnVector build(DType type, int rows, Consumer<Builder> init) {
        return ColumnVector.build(type, TimeUnit.NONE, rows, init);
    }

    public static ColumnVector build(DType type, TimeUnit tsTimeUnit, int rows, Consumer<Builder> init) {
        try (Builder builder = ColumnVector.builder(type, tsTimeUnit, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.build();
            return columnVector;
        }
    }

    public static ColumnVector buildOnHost(DType type, int rows, Consumer<Builder> init) {
        return ColumnVector.buildOnHost(type, TimeUnit.NONE, rows, init);
    }

    public static ColumnVector buildOnHost(DType type, TimeUnit tsTimeUnit, int rows, Consumer<Builder> init) {
        try (Builder builder = ColumnVector.builder(type, tsTimeUnit, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildOnHost();
            return columnVector;
        }
    }

    public static ColumnVector boolFromBytes(byte ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromBytes(byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromShorts(short ... values) {
        return ColumnVector.build(DType.INT16, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromInts(int ... values) {
        return ColumnVector.build(DType.INT32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromLongs(long ... values) {
        return ColumnVector.build(DType.INT64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromFloats(float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromDoubles(double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector datesFromInts(int ... values) {
        return ColumnVector.build(DType.DATE32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector datesFromLongs(long ... values) {
        return ColumnVector.build(DType.DATE64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector timestampsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector timestampsFromLongs(TimeUnit tsTimeUnit, long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, tsTimeUnit, values.length, b -> b.appendArray(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnVector fromStrings(DType type, String ... values) {
        MemoryBuffer data = null;
        MemoryBuffer offsets = null;
        MemoryBuffer valid = null;
        ColumnVector ret = null;
        boolean needsCleanup = true;
        try {
            int rows = values.length;
            long nullCount = 0L;
            long bufferSize = 0L;
            for (String s : values) {
                if (s == null) {
                    ++nullCount;
                    continue;
                }
                bufferSize += (long)s.getBytes(StandardCharsets.UTF_8).length;
            }
            data = HostMemoryBuffer.allocate(bufferSize);
            if (nullCount > 0L) {
                long bitmaskSize = BitVectorHelper.getValidityAllocationSizeInBytes(rows);
                valid = HostMemoryBuffer.allocate(bitmaskSize);
                ((HostMemoryBuffer)valid).setMemory(0L, bitmaskSize, (byte)-1);
            }
            offsets = HostMemoryBuffer.allocate((rows + 1) * 4);
            int offset = 0;
            ((HostMemoryBuffer)offsets).setInt(0L, offset);
            for (int i = 0; i < values.length; ++i) {
                String s = values[i];
                if (s == null) {
                    BitVectorHelper.setNullAt((HostMemoryBuffer)valid, i);
                } else {
                    byte[] utf8 = s.getBytes(StandardCharsets.UTF_8);
                    ((HostMemoryBuffer)data).setBytes(offset, utf8, 0L, utf8.length);
                    offset += utf8.length;
                }
                ((HostMemoryBuffer)offsets).setInt(((long)i + 1L) * 4L, offset);
            }
            ret = new ColumnVector(type, TimeUnit.NONE, rows, nullCount, (HostMemoryBuffer)data, (HostMemoryBuffer)valid, (HostMemoryBuffer)offsets);
            ret.ensureOnDevice();
            needsCleanup = false;
            ColumnVector columnVector = ret;
            return columnVector;
        }
        finally {
            if (needsCleanup) {
                if (ret != null) {
                    ret.close();
                } else {
                    if (data != null) {
                        data.close();
                    }
                    if (offsets != null) {
                        offsets.close();
                    }
                    if (valid != null) {
                        valid.close();
                    }
                }
            }
        }
    }

    public static ColumnVector categoryFromStrings(String ... values) {
        return ColumnVector.fromStrings(DType.STRING_CATEGORY, values);
    }

    public static ColumnVector fromStrings(String ... values) {
        return ColumnVector.fromStrings(DType.STRING, values);
    }

    public static ColumnVector fromBoxedBooleans(Boolean ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedBytes(Byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedShorts(Short ... values) {
        return ColumnVector.build(DType.INT16, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.INT32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.INT64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedFloats(Float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedDoubles(Double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector datesFromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.DATE32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector datesFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DATE64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector timestampsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector timestampsFromBoxedLongs(TimeUnit tsTimeUnit, Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, tsTimeUnit, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector concatenate(ColumnVector ... columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Concatenate requires 2 or more columns");
        }
        long[] columnHandles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnHandles[i] = columns[i].getNativeCudfColumnAddress();
        }
        return new ColumnVector(ColumnVector.concatenate(columnHandles));
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class Builder
    implements AutoCloseable {
        private final long rows;
        private final DType type;
        private final TimeUnit tsTimeUnit;
        private HostMemoryBuffer data;
        private HostMemoryBuffer valid;
        private long currentIndex = 0L;
        private long nullCount;
        private boolean built;

        Builder(DType type, TimeUnit tsTimeUnit, long rows) {
            this.type = type;
            this.tsTimeUnit = tsTimeUnit;
            this.rows = rows;
            this.data = HostMemoryBuffer.allocate(rows * (long)type.sizeInBytes);
        }

        Builder(DType type, TimeUnit tsTimeUnit, long rows, HostMemoryBuffer testData, HostMemoryBuffer testValid) {
            this.type = type;
            this.tsTimeUnit = tsTimeUnit;
            this.rows = rows;
            this.data = testData;
            this.valid = testValid;
        }

        public final Builder append(boolean value) {
            assert (this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value ? (byte)1 : 0);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value) {
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value, long count) {
            assert (count + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setMemory(this.currentIndex * (long)this.type.sizeInBytes, count, value);
            this.currentIndex += count;
            return this;
        }

        public final Builder append(short value) {
            assert (this.type == DType.INT16);
            assert (this.currentIndex < this.rows);
            this.data.setShort(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(int value) {
            assert (this.type == DType.INT32 || this.type == DType.DATE32);
            assert (this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(long value) {
            assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
            assert (this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(float value) {
            assert (this.type == DType.FLOAT32);
            assert (this.currentIndex < this.rows);
            this.data.setFloat(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(double value) {
            assert (this.type == DType.FLOAT64);
            assert (this.currentIndex < this.rows);
            this.data.setDouble(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder appendArray(byte ... values) {
            assert ((long)values.length + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setBytes(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendArray(short ... values) {
            assert (this.type == DType.INT16);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setShorts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendArray(int ... values) {
            assert (this.type == DType.INT32 || this.type == DType.DATE32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setInts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendArray(long ... values) {
            assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setLongs(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendArray(float ... values) {
            assert (this.type == DType.FLOAT32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setFloats(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendArray(double ... values) {
            assert (this.type == DType.FLOAT64);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setDoubles(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendBoxed(Byte ... values) throws IndexOutOfBoundsException {
            for (Byte b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Boolean ... values) throws IndexOutOfBoundsException {
            for (Boolean b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b != false ? (byte)1 : 0);
            }
            return this;
        }

        public final Builder appendBoxed(Short ... values) throws IndexOutOfBoundsException {
            for (Short b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Integer ... values) throws IndexOutOfBoundsException {
            for (Integer b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Long ... values) throws IndexOutOfBoundsException {
            for (Long b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Float ... values) throws IndexOutOfBoundsException {
            for (Float b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b.floatValue());
            }
            return this;
        }

        public final Builder appendBoxed(Double ... values) throws IndexOutOfBoundsException {
            for (Double b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder append(ColumnVector columnVector) {
            assert (columnVector.rows <= this.rows - this.currentIndex);
            assert (columnVector.type == this.type);
            assert (((ColumnVector)columnVector).offHeap.hostData != null);
            this.data.copyFromHostBuffer(this.currentIndex * (long)this.type.sizeInBytes, (HostMemoryBuffer)((ColumnVector)columnVector).offHeap.hostData.data, 0L, columnVector.getRowCount() * (long)this.type.sizeInBytes);
            if (columnVector.nullCount != 0L) {
                if (this.valid == null) {
                    this.allocateBitmaskAndSetDefaultValues();
                }
                BitVectorHelper.append((HostMemoryBuffer)((ColumnVector)columnVector).offHeap.hostData.valid, this.valid, this.currentIndex, columnVector.rows);
                this.nullCount += columnVector.nullCount;
            }
            this.currentIndex += columnVector.rows;
            return this;
        }

        private void allocateBitmaskAndSetDefaultValues() {
            long bitmaskSize = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows);
            this.valid = HostMemoryBuffer.allocate(bitmaskSize);
            this.valid.setMemory(0L, bitmaskSize, (byte)-1);
        }

        public final Builder appendNull() {
            this.setNullAt(this.currentIndex);
            ++this.currentIndex;
            return this;
        }

        public final Builder setNullAt(long index) {
            assert (index < this.rows);
            if (this.valid == null) {
                this.allocateBitmaskAndSetDefaultValues();
            }
            this.nullCount += (long)BitVectorHelper.setNullAt(this.valid, index);
            return this;
        }

        public final ColumnVector build() {
            if (this.built) {
                throw new IllegalStateException("Cannot reuse a builder.");
            }
            ColumnVector cv = new ColumnVector(this.type, this.tsTimeUnit, this.currentIndex, this.nullCount, this.data, this.valid);
            try {
                cv.ensureOnDevice();
                this.built = true;
            }
            finally {
                if (!this.built) {
                    cv.close();
                }
            }
            return cv;
        }

        public final ColumnVector buildOnHost() {
            if (this.built) {
                throw new IllegalStateException("Cannot reuse a builder.");
            }
            ColumnVector cv = new ColumnVector(this.type, this.tsTimeUnit, this.currentIndex, this.nullCount, this.data, this.valid);
            this.built = true;
            return cv;
        }

        @Override
        public final void close() {
            if (!this.built) {
                this.data.close();
                this.data = null;
                if (this.valid != null) {
                    this.valid.close();
                    this.valid = null;
                }
                this.built = true;
            }
        }

        public String toString() {
            return "Builder{data=" + this.data + "type=" + (Object)((Object)this.type) + ", valid=" + this.valid + ", currentIndex=" + this.currentIndex + ", nullCount=" + this.nullCount + ", rows=" + this.rows + ", built=" + this.built + '}';
        }
    }

    protected static final class OffHeapState
    implements ColumnVectorCleaner.Cleaner {
        private final List<RefCountDebugItem> refCountDebug = REF_COUNT_DEBUG ? new LinkedList<RefCountDebugItem>() : null;
        public BufferEncapsulator<HostMemoryBuffer> hostData;
        public BufferEncapsulator<DeviceMemoryBuffer> deviceData;
        private long nativeCudfColumnHandle = 0L;

        public final void addRef() {
            if (REF_COUNT_DEBUG) {
                this.refCountDebug.add(new RefCountDebugItem("INC"));
            }
        }

        public final void delRef() {
            if (REF_COUNT_DEBUG) {
                this.refCountDebug.add(new RefCountDebugItem("DEC"));
            }
        }

        public final void logRefCountDebug(String message) {
            if (REF_COUNT_DEBUG) {
                log.error("{}: {}", (Object)message, (Object)ColumnVector.stringJoin("\n", this.refCountDebug));
            }
        }

        @Override
        public boolean clean(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.hostData != null) {
                this.hostData.close();
                this.hostData = null;
                neededCleanup = true;
            }
            if (this.deviceData != null) {
                this.deviceData.close();
                this.deviceData = null;
                neededCleanup = true;
            }
            if (this.nativeCudfColumnHandle != 0L) {
                ColumnVector.freeCudfColumn(this.nativeCudfColumnHandle, false);
                this.nativeCudfColumnHandle = 0L;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("YOU LEAKED A COLUMN VECTOR!!!!");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }
    }

    private static final class RefCountDebugItem {
        final StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        final long timeMs = System.currentTimeMillis();
        final String op;

        public RefCountDebugItem(String op) {
            this.op = op;
        }

        public String toString() {
            Date date = new Date(this.timeMs);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS z");
            return dateFormat.format(date) + ": " + this.op + "\n" + ColumnVector.stringJoin("\n", Arrays.asList(this.stackTrace)) + "\n";
        }
    }

    private static final class BufferEncapsulator<T extends MemoryBuffer>
    implements AutoCloseable {
        public final T data;
        public final T valid;
        public final T offsets;

        BufferEncapsulator(T data, T valid, T offsets) {
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
        }

        public String toString() {
            T type = this.data == null ? this.valid : this.data;
            type = type == null ? this.offsets : type;
            String t = "UNKNOWN";
            if (type != null) {
                t = type.getClass().getSimpleName();
            }
            return "BufferEncapsulator{type= " + t + ", data= " + this.data + ", valid= " + this.valid + ", offsets= " + this.offsets + "}";
        }

        @Override
        public void close() {
            if (this.data != null) {
                ((MemoryBuffer)this.data).close();
            }
            if (this.valid != null) {
                ((MemoryBuffer)this.valid).close();
            }
            if (this.offsets != null) {
                ((MemoryBuffer)this.offsets).close();
            }
        }
    }
}

