/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnVectorCleaner {
    private static Logger log = LoggerFactory.getLogger(ColumnVectorCleaner.class);
    static final AtomicLong leakCount = new AtomicLong();
    private static final Set<CleanerWeakReference> all = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Thread t = new Thread(() -> {
        try {
            while (true) {
                Thread.sleep(100L);
                ColumnVectorCleaner.doCleanup();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }, "Cleaner Thread");

    ColumnVectorCleaner() {
    }

    private static synchronized void doCleanup() {
        Iterator<CleanerWeakReference> it = all.iterator();
        while (it.hasNext()) {
            CleanerWeakReference ref = it.next();
            if (ref.get() != null) continue;
            ref.clean();
            it.remove();
        }
    }

    public static synchronized void register(ColumnVector vec, Cleaner cleaner) {
        all.add(new CleanerWeakReference(vec, cleaner));
    }

    static {
        t.setDaemon(true);
        t.start();
        if (ColumnVector.REF_COUNT_DEBUG) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.gc();
                Class<ColumnVectorCleaner> clazz = ColumnVectorCleaner.class;
                synchronized (ColumnVectorCleaner.class) {
                    ColumnVectorCleaner.doCleanup();
                    for (CleanerWeakReference cwr : all) {
                        cwr.clean();
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            }));
        }
    }

    private static class CleanerWeakReference
    extends WeakReference<ColumnVector> {
        private final Cleaner cleaner;

        public CleanerWeakReference(ColumnVector columnVector, Cleaner cleaner) {
            super(columnVector);
            this.cleaner = cleaner;
        }

        public void clean() {
            if (this.cleaner.clean(true)) {
                leakCount.incrementAndGet();
            }
        }
    }

    public static interface Cleaner {
        public boolean clean(boolean var1);
    }
}

