/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum DType {
    INVALID(0, 0, "invalid"),
    INT8(1, 1, "int"),
    INT16(2, 2, "short"),
    INT32(4, 3, "int32"),
    INT64(8, 4, "int64"),
    FLOAT32(4, 5, "float32"),
    FLOAT64(8, 6, "float64"),
    BOOL8(1, 7, "bool"),
    DATE32(4, 8, "date32"),
    DATE64(8, 9, "date64"),
    TIMESTAMP(8, 10, "timestamp"),
    STRING(0, 12, "str"),
    STRING_CATEGORY(4, 13, "not-supported");

    private static final DType[] D_TYPES;
    final int sizeInBytes;
    final int nativeId;
    final String simpleName;

    private DType(int sizeInBytes, int nativeId, String simpleName) {
        this.sizeInBytes = sizeInBytes;
        this.nativeId = nativeId;
        this.simpleName = simpleName;
    }

    static DType fromNative(int nativeId) {
        for (DType type : D_TYPES) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a DType");
    }

    static {
        D_TYPES = DType.values();
    }
}

