/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.Rmm;

class DeviceMemoryBuffer
extends MemoryBuffer {
    DeviceMemoryBuffer(long address, long lengthInBytes) {
        super(address, lengthInBytes);
    }

    public static DeviceMemoryBuffer allocate(long bytes) {
        return new DeviceMemoryBuffer(Rmm.alloc(bytes, 0L), bytes);
    }

    public void copyFromHostBuffer(HostMemoryBuffer hostBuffer) {
        this.addressOutOfBoundsCheck(this.address, hostBuffer.length, "copy range dest");
        assert (!hostBuffer.closed);
        Cuda.memcpy(this.address, hostBuffer.address, hostBuffer.length, CudaMemcpyKind.HOST_TO_DEVICE);
    }

    @Override
    protected void doClose() {
        Rmm.free(this.address, 0L);
    }
}

