/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.UnsafeMemoryAccessor;

public class HostMemoryBuffer
extends MemoryBuffer {
    HostMemoryBuffer(long address, long length) {
        super(address, length);
    }

    public static HostMemoryBuffer allocate(long bytes) {
        return new HostMemoryBuffer(UnsafeMemoryAccessor.allocate(bytes), bytes);
    }

    public final void copyFromHostBuffer(long destOffset, HostMemoryBuffer srcData, long srcOffset, long length) {
        this.addressOutOfBoundsCheck(this.address + destOffset, length, "copy from dest");
        srcData.addressOutOfBoundsCheck(srcData.address + srcOffset, length, "copy from source");
        UnsafeMemoryAccessor.copyMemory(null, srcData.address + srcOffset, null, this.address + destOffset, length);
    }

    public final byte getByte(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "getByte");
        return UnsafeMemoryAccessor.getByte(requestedAddress);
    }

    public final void setByte(long offset, byte value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "setByte");
        UnsafeMemoryAccessor.setByte(requestedAddress, value);
    }

    public final void getBytes(byte[] dst, long dstOffset, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)dst.length - dstOffset);
        assert (srcOffset >= 0L);
        long requestedAddress = this.address + srcOffset;
        this.addressOutOfBoundsCheck(requestedAddress, len, "getBytes");
        UnsafeMemoryAccessor.getBytes(dst, dstOffset, requestedAddress, len);
    }

    public final void setBytes(long offset, byte[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        assert (srcOffset >= 0L);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len, "setBytes");
        UnsafeMemoryAccessor.setBytes(requestedAddress, data, srcOffset, len);
    }

    final short getShort(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 2L, "getShort");
        return UnsafeMemoryAccessor.getShort(requestedAddress);
    }

    final void setShort(long offset, short value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 2L, "setShort");
        UnsafeMemoryAccessor.setShort(requestedAddress, value);
    }

    final void setShorts(long offset, short[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 2L, "setShorts");
        UnsafeMemoryAccessor.setShorts(requestedAddress, data, srcOffset, len);
    }

    final int getInt(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "getInt");
        return UnsafeMemoryAccessor.getInt(requestedAddress);
    }

    final void setInt(long offset, int value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "setInt");
        UnsafeMemoryAccessor.setInt(requestedAddress, value);
    }

    final void setInts(long offset, int[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 4L, "setInts");
        UnsafeMemoryAccessor.setInts(requestedAddress, data, srcOffset, len);
    }

    final long getLong(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "setLong");
        return UnsafeMemoryAccessor.getLong(requestedAddress);
    }

    final void setLong(long offset, long value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "getLong");
        UnsafeMemoryAccessor.setLong(requestedAddress, value);
    }

    final void setLongs(long offset, long[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 8L, "setLongs");
        UnsafeMemoryAccessor.setLongs(requestedAddress, data, srcOffset, len);
    }

    final float getFloat(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "getFloat");
        return UnsafeMemoryAccessor.getFloat(requestedAddress);
    }

    final void setFloat(long offset, float value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 4L, "setFloat");
        UnsafeMemoryAccessor.setFloat(requestedAddress, value);
    }

    final void setFloats(long offset, float[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 4L, "setFloats");
        UnsafeMemoryAccessor.setFloats(requestedAddress, data, srcOffset, len);
    }

    final double getDouble(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "getDouble");
        return UnsafeMemoryAccessor.getDouble(requestedAddress);
    }

    final void setDouble(long offset, double value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 8L, "setDouble");
        UnsafeMemoryAccessor.setDouble(requestedAddress, value);
    }

    final void setDoubles(long offset, double[] data, long srcOffset, long len) {
        assert (len > 0L);
        assert (len <= (long)data.length - srcOffset);
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, len * 8L, "setDoubles");
        UnsafeMemoryAccessor.setDoubles(requestedAddress, data, srcOffset, len);
    }

    final boolean getBoolean(long offset) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "getBoolean");
        return UnsafeMemoryAccessor.getBoolean(requestedAddress);
    }

    final void setBoolean(long offset, boolean value) {
        long requestedAddress = this.address + offset;
        this.addressOutOfBoundsCheck(requestedAddress, 1L, "setBoolean");
        UnsafeMemoryAccessor.setBoolean(requestedAddress, value);
    }

    final void setMemory(long offset, long length, byte value) {
        this.addressOutOfBoundsCheck(this.address + offset, length, "set memory");
        UnsafeMemoryAccessor.setMemory(this.address + offset, length, value);
    }

    final void copyFromMemory(long fromAddress, long len) {
        this.addressOutOfBoundsCheck(this.address, len, "copy from memory");
        UnsafeMemoryAccessor.copyMemory(null, fromAddress, null, this.address, len);
    }

    final void copyFromDeviceBuffer(DeviceMemoryBuffer deviceMemoryBuffer) {
        this.addressOutOfBoundsCheck(this.address, deviceMemoryBuffer.length, "copy range dest");
        assert (!deviceMemoryBuffer.closed);
        Cuda.memcpy(this.address, deviceMemoryBuffer.address, deviceMemoryBuffer.length, CudaMemcpyKind.DEVICE_TO_HOST);
    }

    @Override
    protected void doClose() {
        UnsafeMemoryAccessor.free(this.address);
    }
}

