/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

abstract class MemoryBuffer
implements AutoCloseable {
    protected final long address;
    protected final long length;
    protected boolean closed = false;

    protected MemoryBuffer(long address, long length) {
        this.address = address;
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    protected final void addressOutOfBoundsCheck(long address, long size, String type) {
        assert (!this.closed);
        assert (address >= this.address) : "Start address is too low for " + type + " 0x" + Long.toHexString(address) + " < 0x" + Long.toHexString(this.address);
        assert (address + size <= this.address + this.length) : "End address is too high for " + type + " 0x" + Long.toHexString(address + size) + " < 0x" + Long.toHexString(this.address + this.length);
    }

    final long getAddress() {
        return this.address;
    }

    protected abstract void doClose();

    @Override
    public final void close() {
        if (!this.closed) {
            this.doClose();
            this.closed = true;
        }
    }

    public String toString() {
        return "MemoryBuffer{address=0x" + Long.toHexString(this.address) + ", length=" + this.length + '}';
    }
}

