/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum TimeUnit {
    NONE(0),
    SECONDS(1),
    MILLISECONDS(2),
    MICROSECONDS(3),
    NANOSECONDS(4);

    private static final TimeUnit[] TIME_UNITS;
    private final int nativeId;

    private TimeUnit(int nativeId) {
        this.nativeId = nativeId;
    }

    static TimeUnit fromNative(int nativeId) {
        for (TimeUnit type : TIME_UNITS) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a TimeUnit");
    }

    int getNativeId() {
        return this.nativeId;
    }

    static {
        TIME_UNITS = TimeUnit.values();
    }
}

