/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.Cudf;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HashFunction;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.QuantileMethod;
import ai.rapids.cudf.ReductionOp;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.TimeUnit;
import ai.rapids.cudf.UnaryOp;
import ai.rapids.cudf.UnsafeMemoryAccessor;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnVector
implements AutoCloseable,
BinaryOperable {
    static final int OFFSET_SIZE = DType.INT32.sizeInBytes;
    private static final Logger log = LoggerFactory.getLogger(ColumnVector.class);
    private final DType type;
    private final OffHeapState offHeap = new OffHeapState();
    private TimeUnit tsTimeUnit;
    private long rows;
    private long nullCount;
    private int refCount;

    ColumnVector(long nativePointer) {
        assert (nativePointer != 0L);
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.offHeap.nativeCudfColumnHandle = nativePointer;
        this.type = ColumnVector.getDType(nativePointer);
        this.offHeap.setHostData(null);
        this.rows = ColumnVector.getRowCount(nativePointer);
        this.nullCount = ColumnVector.getNullCount(nativePointer);
        this.tsTimeUnit = ColumnVector.getTimeUnit(nativePointer);
        DeviceMemoryBuffer data = null;
        if (this.type != DType.STRING) {
            data = new DeviceMemoryBuffer(ColumnVector.getDataPtr(nativePointer), this.rows * (long)this.type.sizeInBytes);
        }
        DeviceMemoryBuffer valid = null;
        long validPtr = ColumnVector.getValidPtr(nativePointer);
        if (validPtr != 0L) {
            valid = new DeviceMemoryBuffer(validPtr, BitVectorHelper.getValidityLengthInBytes(this.rows));
        }
        this.offHeap.setDeviceData(new BufferEncapsulator<Object>(data, valid, null));
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, long nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer) {
        this(type, tsTimeUnit, rows, nullCount, hostDataBuffer, hostValidityBuffer, null);
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, long nullCount, HostMemoryBuffer hostDataBuffer, HostMemoryBuffer hostValidityBuffer, HostMemoryBuffer offsetBuffer) {
        if (nullCount > 0L && hostValidityBuffer == null) {
            throw new IllegalStateException("Buffer cannot have a nullCount without a validity buffer");
        }
        if (type == DType.STRING_CATEGORY || type == DType.STRING) {
            assert (offsetBuffer != null) : "offsets must be provided for STRING and STRING_CATEGORY";
        } else assert (offsetBuffer == null) : "offsets are only supported for STRING and STRING_CATEGORY";
        this.tsTimeUnit = type == DType.TIMESTAMP ? (tsTimeUnit == TimeUnit.NONE ? TimeUnit.MILLISECONDS : tsTimeUnit) : TimeUnit.NONE;
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.offHeap.setHostData(new BufferEncapsulator<HostMemoryBuffer>(hostDataBuffer, hostValidityBuffer, offsetBuffer));
        this.offHeap.setDeviceData(null);
        this.rows = rows;
        this.nullCount = nullCount;
        this.type = type;
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    ColumnVector(DType type, TimeUnit tsTimeUnit, long rows, long nullCount, DeviceMemoryBuffer dataBuffer, DeviceMemoryBuffer validityBuffer, HostMemoryBuffer offsetBuffer, boolean resetOffsetsFromFirst) {
        if (type == DType.STRING_CATEGORY || type == DType.STRING) {
            assert (offsetBuffer != null) : "offsets must be provided for STRING and STRING_CATEGORY";
        } else assert (offsetBuffer == null) : "offsets are only supported for STRING and STRING_CATEGORY";
        this.tsTimeUnit = type == DType.TIMESTAMP ? (tsTimeUnit == TimeUnit.NONE ? TimeUnit.MILLISECONDS : tsTimeUnit) : TimeUnit.NONE;
        MemoryCleaner.register(this, (MemoryCleaner.Cleaner)this.offHeap);
        this.offHeap.setHostData(null);
        this.rows = rows;
        this.nullCount = nullCount;
        this.type = type;
        if (type == DType.STRING || type == DType.STRING_CATEGORY) {
            if (type == DType.STRING_CATEGORY) {
                this.offHeap.setDeviceData(new BufferEncapsulator<Object>(DeviceMemoryBuffer.allocate(rows * (long)type.sizeInBytes), validityBuffer, null));
            } else {
                this.offHeap.setDeviceData(new BufferEncapsulator<Object>(null, validityBuffer, null));
            }
            this.offHeap.nativeCudfColumnHandle = ColumnVector.allocateCudfColumn();
            ColumnVector.cudfColumnViewStrings(this.offHeap.nativeCudfColumnHandle, dataBuffer.getAddress(), false, offsetBuffer.getAddress(), resetOffsetsFromFirst, nullCount > 0L ? ((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).getAddress() : 0L, this.offHeap.getDeviceData().data == null ? 0L : ((DeviceMemoryBuffer)this.offHeap.getDeviceData().data).getAddress(), (int)rows, type.nativeId, (int)this.getNullCount());
            dataBuffer.close();
            offsetBuffer.close();
        } else {
            this.offHeap.setDeviceData(new BufferEncapsulator<Object>(dataBuffer, validityBuffer, null));
        }
        this.refCount = 0;
        this.incRefCountInternal(true);
    }

    public final void noWarnLeakExpected() {
        this.offHeap.noWarnLeakExpected();
        if (this.offHeap.getHostData() != null) {
            this.offHeap.getHostData().noWarnLeakExpected();
        }
        if (this.offHeap.getDeviceData() != null) {
            this.offHeap.getDeviceData().noWarnLeakExpected();
        }
    }

    @Override
    public final void close() {
        --this.refCount;
        this.offHeap.delRef();
        if (this.refCount == 0) {
            this.offHeap.clean(false);
        } else if (this.refCount < 0) {
            log.error("Close called too many times on {}", (Object)this);
            this.offHeap.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times");
        }
    }

    public String toString() {
        return "ColumnVector{rows=" + this.rows + ", type=" + (Object)((Object)this.type) + ", hostData=" + this.offHeap.getHostData() + ", deviceData=" + this.offHeap.getDeviceData() + ", nullCount=" + this.nullCount + ", cudfColumn=" + this.offHeap.nativeCudfColumnHandle + '}';
    }

    public ColumnVector incRefCount() {
        return this.incRefCountInternal(false);
    }

    private ColumnVector incRefCountInternal(boolean isFirstTime) {
        this.offHeap.addRef();
        if (this.refCount <= 0 && !isFirstTime) {
            this.offHeap.logRefCountDebug("INC AFTER CLOSE " + this);
            throw new IllegalStateException("Column is already closed");
        }
        ++this.refCount;
        return this;
    }

    public long getRowCount() {
        return this.rows;
    }

    public ColumnVector getLengths() {
        assert (DType.STRING == this.type) : "length only available for String type";
        return new ColumnVector(ColumnVector.cudfLengths(this.getNativeCudfColumnAddress()));
    }

    public ColumnVector hash() {
        return new ColumnVector(ColumnVector.hash(this.getNativeCudfColumnAddress(), HashFunction.MURMUR3.nativeId));
    }

    public ColumnVector hash(HashFunction func) {
        assert (this.type != DType.STRING && this.type != DType.STRING_CATEGORY) : "Strings are not supported for specific hash functions";
        return new ColumnVector(ColumnVector.hash(this.getNativeCudfColumnAddress(), func.nativeId));
    }

    public ColumnVector murmur3() {
        return this.hash(HashFunction.MURMUR3);
    }

    public ColumnVector identityHash() {
        return this.hash(HashFunction.IDENTITY);
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public long getNullCount() {
        return this.nullCount;
    }

    int getRefCount() {
        return this.refCount;
    }

    public ColumnVector getByteCount() {
        assert (this.type == DType.STRING) : "type has to be a String";
        return new ColumnVector(ColumnVector.cudfByteCount(this.getNativeCudfColumnAddress()));
    }

    public boolean hasValidityVector() {
        boolean ret = this.offHeap.getHostData() != null ? this.offHeap.getHostData().valid != null : this.offHeap.getDeviceData().valid != null;
        return ret;
    }

    public boolean hasNulls() {
        return this.getNullCount() > 0L;
    }

    public TimeUnit getTimeUnit() {
        return this.tsTimeUnit;
    }

    private void checkHasDeviceData() {
        if (this.offHeap.getDeviceData() == null && this.rows != 0L) {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Vector was already closed.");
            }
            throw new IllegalStateException("Vector not on Device");
        }
    }

    private void checkHasHostData() {
        if (this.offHeap.getHostData() == null && this.rows != 0L) {
            throw new IllegalStateException("Vector not on Host");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureOnDevice() {
        if (this.offHeap.getDeviceData() == null && this.rows != 0L) {
            this.checkHasHostData();
            if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) assert (this.offHeap.getHostData().offsets != null);
            DeviceMemoryBuffer deviceDataBuffer = null;
            MemoryBuffer deviceValidityBuffer = null;
            if (this.type == DType.STRING_CATEGORY) {
                deviceDataBuffer = DeviceMemoryBuffer.allocate(this.rows * (long)this.type.sizeInBytes);
            } else if (this.type != DType.STRING) {
                deviceDataBuffer = DeviceMemoryBuffer.allocate(((HostMemoryBuffer)this.offHeap.getHostData().data).getLength());
            }
            boolean needsCleanup = true;
            try {
                if (this.hasNulls()) {
                    deviceValidityBuffer = DeviceMemoryBuffer.allocate(((HostMemoryBuffer)this.offHeap.getHostData().valid).getLength());
                }
                this.offHeap.setDeviceData(new BufferEncapsulator<Object>(deviceDataBuffer, deviceValidityBuffer, null));
                needsCleanup = false;
            }
            finally {
                if (needsCleanup) {
                    if (deviceDataBuffer != null) {
                        deviceDataBuffer.close();
                    }
                    if (deviceValidityBuffer != null) {
                        deviceValidityBuffer.close();
                    }
                }
            }
            if (this.offHeap.getDeviceData().valid != null) {
                ((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).copyFromHostBuffer((HostMemoryBuffer)this.offHeap.getHostData().valid);
            }
            if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) {
                this.offHeap.nativeCudfColumnHandle = ColumnVector.allocateCudfColumn();
                ColumnVector.cudfColumnViewStrings(this.offHeap.nativeCudfColumnHandle, ((HostMemoryBuffer)this.offHeap.getHostData().data).getAddress(), true, ((HostMemoryBuffer)this.offHeap.getHostData().offsets).getAddress(), false, this.offHeap.getHostData().valid == null ? 0L : ((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).getAddress(), this.offHeap.getDeviceData().data == null ? 0L : ((DeviceMemoryBuffer)this.offHeap.getDeviceData().data).getAddress(), (int)this.rows, this.type.nativeId, (int)this.getNullCount());
            } else {
                ((DeviceMemoryBuffer)this.offHeap.getDeviceData().data).copyFromHostBuffer((HostMemoryBuffer)this.offHeap.getHostData().data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureOnHost() {
        if (this.offHeap.getHostData() == null && this.rows != 0L) {
            this.checkHasDeviceData();
            MemoryBuffer hostDataBuffer = null;
            MemoryBuffer hostValidityBuffer = null;
            HostMemoryBuffer hostOffsetsBuffer = null;
            boolean needsCleanup = true;
            try {
                if (this.offHeap.getDeviceData().valid != null) {
                    hostValidityBuffer = HostMemoryBuffer.allocate(((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).getLength());
                }
                if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) {
                    long[] vals = ColumnVector.getStringDataAndOffsetsBack(this.getNativeCudfColumnAddress());
                    hostDataBuffer = new HostMemoryBuffer(vals[0], vals[1]);
                    hostOffsetsBuffer = new HostMemoryBuffer(vals[2], vals[3]);
                } else {
                    hostDataBuffer = HostMemoryBuffer.allocate(((DeviceMemoryBuffer)this.offHeap.getDeviceData().data).getLength());
                }
                this.offHeap.setHostData(new BufferEncapsulator<Object>(hostDataBuffer, hostValidityBuffer, hostOffsetsBuffer));
                needsCleanup = false;
            }
            finally {
                if (needsCleanup) {
                    if (hostDataBuffer != null) {
                        hostDataBuffer.close();
                    }
                    if (hostValidityBuffer != null) {
                        hostValidityBuffer.close();
                    }
                }
            }
            if (this.type != DType.STRING && this.type != DType.STRING_CATEGORY) {
                ((HostMemoryBuffer)this.offHeap.getHostData().data).copyFromDeviceBuffer((DeviceMemoryBuffer)this.offHeap.getDeviceData().data);
            }
            if (this.offHeap.getHostData().valid != null) {
                ((HostMemoryBuffer)this.offHeap.getHostData().valid).copyFromDeviceBuffer((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid);
            }
        }
    }

    public boolean isNull(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        if (this.hasNulls()) {
            this.checkHasHostData();
            return BitVectorHelper.isNull((HostMemoryBuffer)this.offHeap.getHostData().valid, index);
        }
        return false;
    }

    boolean isNullExtendedRange(long index) {
        long maxNullRow = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows) * 8L;
        assert (index >= 0L && index < maxNullRow) : "TEST: index is out of range 0 <= " + index + " < " + maxNullRow;
        if (this.hasNulls()) {
            this.checkHasHostData();
            return BitVectorHelper.isNull((HostMemoryBuffer)this.offHeap.getHostData().valid, index);
        }
        return false;
    }

    void copyHostBufferBytes(byte[] dst, int dstOffset, BufferType src, long srcOffset, int length) {
        HostMemoryBuffer srcBuffer;
        assert (dstOffset >= 0);
        assert (srcOffset >= 0L);
        assert (length >= 0);
        assert (dstOffset + length <= dst.length);
        switch (src) {
            case VALIDITY: {
                srcBuffer = (HostMemoryBuffer)this.offHeap.getHostData().valid;
                break;
            }
            case OFFSET: {
                srcBuffer = (HostMemoryBuffer)this.offHeap.getHostData().offsets;
                break;
            }
            case DATA: {
                srcBuffer = (HostMemoryBuffer)this.offHeap.getHostData().data;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)src) + " is not a supported buffer type.");
            }
        }
        assert (srcOffset + (long)length <= srcBuffer.length);
        UnsafeMemoryAccessor.getBytes(dst, dstOffset, srcBuffer.getAddress() + srcOffset, length);
    }

    public ColumnVector isNotNull() {
        return this.validityAsBooleanVector();
    }

    public ColumnVector isNull() {
        ColumnVector res = null;
        try (ColumnVector boolValidity = this.validityAsBooleanVector();){
            res = boolValidity.not();
        }
        return res;
    }

    public ColumnVector replaceNulls(Scalar scalar) {
        return new ColumnVector(Cudf.replaceNulls(this, scalar));
    }

    private ColumnVector validityAsBooleanVector() {
        if (this.getRowCount() == 0L) {
            return ColumnVector.fromBoxedBooleans(new Boolean[0]);
        }
        ColumnVector cv = ColumnVector.fromScalar(Scalar.fromBool(true), (int)this.getRowCount());
        if (this.getNullCount() == 0L) {
            return cv;
        }
        ColumnVector result = null;
        try {
            this.checkHasDeviceData();
            ColumnVector.cudfColumnViewAugmented(cv.offHeap.nativeCudfColumnHandle, ((DeviceMemoryBuffer)cv.offHeap.getDeviceData().data).address, ((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).address, (int)this.getRowCount(), DType.BOOL8.nativeId, (int)this.getNullCount(), TimeUnit.NONE.getNativeId());
            cv.nullCount = this.getNullCount();
            result = cv.replaceNulls(Scalar.fromBool(false));
        }
        finally {
            if (cv != null) {
                if (cv.offHeap.getDeviceData().data != null) {
                    ((DeviceMemoryBuffer)cv.offHeap.getDeviceData().data).close();
                }
                cv.offHeap.setDeviceData(null);
                cv.close();
            }
        }
        return result;
    }

    private void assertsForGet(long index) {
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (this.offHeap.getHostData() != null) : "data is not on the host";
        assert (!this.isNull(index)) : " value at " + index + " is null";
    }

    public byte getByte(long index) {
        assert (this.type == DType.INT8 || this.type == DType.BOOL8);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getByte(index * (long)this.type.sizeInBytes);
    }

    public final short getShort(long index) {
        assert (this.type == DType.INT16);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getShort(index * (long)this.type.sizeInBytes);
    }

    public final int getInt(long index) {
        assert (this.type == DType.INT32 || this.type == DType.DATE32);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getInt(index * (long)this.type.sizeInBytes);
    }

    long getStartStringOffset(long index) {
        assert (this.type == DType.STRING_CATEGORY || this.type == DType.STRING);
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (this.offHeap.getHostData() != null) : "data is not on the host";
        return ((HostMemoryBuffer)this.offHeap.getHostData().offsets).getInt(index * 4L);
    }

    long getEndStringOffset(long index) {
        assert (this.type == DType.STRING_CATEGORY || this.type == DType.STRING);
        assert (index >= 0L && index < this.rows) : "index is out of range 0 <= " + index + " < " + this.rows;
        assert (this.offHeap.getHostData() != null) : "data is not on the host";
        return ((HostMemoryBuffer)this.offHeap.getHostData().offsets).getInt((index + 1L) * 4L);
    }

    public final long getLong(long index) {
        assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getLong(index * (long)this.type.sizeInBytes);
    }

    public final float getFloat(long index) {
        assert (this.type == DType.FLOAT32);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getFloat(index * (long)this.type.sizeInBytes);
    }

    public final double getDouble(long index) {
        assert (this.type == DType.FLOAT64);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getDouble(index * (long)this.type.sizeInBytes);
    }

    public final boolean getBoolean(long index) {
        assert (this.type == DType.BOOL8);
        this.assertsForGet(index);
        return ((HostMemoryBuffer)this.offHeap.getHostData().data).getBoolean(index * (long)this.type.sizeInBytes);
    }

    public String getJavaString(long index) {
        assert (this.type == DType.STRING || this.type == DType.STRING_CATEGORY);
        this.assertsForGet(index);
        int start = ((HostMemoryBuffer)this.offHeap.getHostData().offsets).getInt(index * (long)OFFSET_SIZE);
        int size = ((HostMemoryBuffer)this.offHeap.getHostData().offsets).getInt((index + 1L) * (long)OFFSET_SIZE) - start;
        byte[] rawData = new byte[size];
        if (size > 0) {
            ((HostMemoryBuffer)this.offHeap.getHostData().data).getBytes(rawData, 0L, start, size);
        }
        return new String(rawData, StandardCharsets.UTF_8);
    }

    public ColumnVector year() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeYear(this));
    }

    public ColumnVector month() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeMonth(this));
    }

    public ColumnVector day() {
        assert (this.type == DType.DATE32 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeDay(this));
    }

    public ColumnVector hour() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeHour(this));
    }

    public ColumnVector minute() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeMinute(this));
    }

    public ColumnVector second() {
        assert (this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
        return new ColumnVector(Cudf.gdfExtractDatetimeSecond(this));
    }

    public ColumnVector unaryOp(UnaryOp op) {
        return new ColumnVector(Cudf.gdfUnaryMath(this, op, this.type));
    }

    public ColumnVector sin() {
        return this.unaryOp(UnaryOp.SIN);
    }

    public ColumnVector cos() {
        return this.unaryOp(UnaryOp.COS);
    }

    public ColumnVector tan() {
        return this.unaryOp(UnaryOp.TAN);
    }

    public ColumnVector arcsin() {
        return this.unaryOp(UnaryOp.ARCSIN);
    }

    public ColumnVector arccos() {
        return this.unaryOp(UnaryOp.ARCCOS);
    }

    public ColumnVector arctan() {
        return this.unaryOp(UnaryOp.ARCTAN);
    }

    public ColumnVector exp() {
        return this.unaryOp(UnaryOp.EXP);
    }

    public ColumnVector log() {
        return this.unaryOp(UnaryOp.LOG);
    }

    public ColumnVector sqrt() {
        return this.unaryOp(UnaryOp.SQRT);
    }

    public ColumnVector ceil() {
        return this.unaryOp(UnaryOp.CEIL);
    }

    public ColumnVector floor() {
        return this.unaryOp(UnaryOp.FLOOR);
    }

    public ColumnVector abs() {
        return this.unaryOp(UnaryOp.ABS);
    }

    public ColumnVector bitInvert() {
        return this.unaryOp(UnaryOp.BIT_INVERT);
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnVector) {
            ColumnVector cvRhs = (ColumnVector)rhs;
            assert (this.rows == cvRhs.getRowCount());
            return new ColumnVector(Cudf.gdfBinaryOp(this, cvRhs, op, outType));
        }
        if (rhs instanceof Scalar) {
            Scalar sRhs = (Scalar)rhs;
            return new ColumnVector(Cudf.gdfBinaryOp(this, sRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with ColumnVector");
    }

    public ColumnVector[] slice(int ... indices) {
        return this.slice(ColumnVector.fromInts(indices));
    }

    public ColumnVector[] slice(ColumnVector indices) {
        long[] nativeHandles = this.cudfSlice(this.getNativeCudfColumnAddress(), indices.getNativeCudfColumnAddress());
        ColumnVector[] columnVectors = new ColumnVector[nativeHandles.length];
        IntStream.range(0, nativeHandles.length).forEach(i -> {
            columnVectors[i] = new ColumnVector(nativeHandles[i]);
        });
        return columnVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fill(Scalar scalar) throws IllegalArgumentException {
        assert (scalar.getType() == this.getType());
        if (this.getType() == DType.STRING || this.getType() == DType.STRING_CATEGORY) {
            throw new IllegalStateException("DType of STRING, or STRING_CATEGORY not supported");
        }
        if (this.getRowCount() == 0L) {
            return;
        }
        this.checkHasDeviceData();
        BufferEncapsulator<DeviceMemoryBuffer> newDeviceData = null;
        boolean needsCleanup = true;
        try {
            if (!scalar.isValid()) {
                if (this.getNullCount() == this.getRowCount()) {
                    return;
                }
                this.nullCount = this.rows;
                if (this.offHeap.getDeviceData().valid == null) {
                    long validitySizeInBytes = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows);
                    newDeviceData = new BufferEncapsulator<Object>(this.offHeap.getDeviceData().data, DeviceMemoryBuffer.allocate(validitySizeInBytes), null);
                    this.offHeap.setDeviceData(newDeviceData);
                } else {
                    newDeviceData = this.offHeap.getDeviceData();
                }
                needsCleanup = false;
                Cuda.memset(((DeviceMemoryBuffer)newDeviceData.valid).getAddress(), (byte)0, BitVectorHelper.getValidityLengthInBytes(this.rows));
                ColumnVector.cudfColumnViewAugmented(this.getNativeCudfColumnAddress(), ((DeviceMemoryBuffer)newDeviceData.data).address, ((DeviceMemoryBuffer)newDeviceData.valid).address, (int)this.getRowCount(), this.getType().nativeId, (int)this.nullCount, this.getTimeUnit().getNativeId());
            } else {
                this.nullCount = 0L;
                newDeviceData = this.offHeap.getDeviceData();
                needsCleanup = false;
                if (newDeviceData.valid != null) {
                    ((DeviceMemoryBuffer)newDeviceData.valid).close();
                    newDeviceData = new BufferEncapsulator<Object>(newDeviceData.data, null, null);
                    this.offHeap.setDeviceData(newDeviceData);
                }
                ColumnVector.cudfColumnViewAugmented(this.getNativeCudfColumnAddress(), ((DeviceMemoryBuffer)newDeviceData.data).address, 0L, (int)this.getRowCount(), this.getType().nativeId, (int)this.nullCount, this.getTimeUnit().getNativeId());
                Cudf.fill(this, scalar);
            }
            if (this.offHeap.getHostData() != null) {
                this.offHeap.getHostData().close();
                this.offHeap.setHostData(null);
                this.ensureOnHost();
            }
        }
        finally {
            if (needsCleanup && newDeviceData != null) {
                ((DeviceMemoryBuffer)newDeviceData.valid).close();
            }
        }
    }

    public Scalar sum() {
        return this.sum(this.type);
    }

    public Scalar sum(DType outType) {
        return this.reduce(ReductionOp.SUM, outType);
    }

    public Scalar min() {
        return this.min(this.type);
    }

    public Scalar min(DType outType) {
        return this.reduce(ReductionOp.MIN, outType);
    }

    public Scalar max() {
        return this.max(this.type);
    }

    public Scalar max(DType outType) {
        return this.reduce(ReductionOp.MAX, outType);
    }

    public Scalar product() {
        return this.product(this.type);
    }

    public Scalar product(DType outType) {
        return this.reduce(ReductionOp.PRODUCT, outType);
    }

    public Scalar sumOfSquares() {
        return this.sumOfSquares(this.type);
    }

    public Scalar sumOfSquares(DType outType) {
        return this.reduce(ReductionOp.SUMOFSQUARES, outType);
    }

    public Scalar standardDeviation() {
        if (this.type != DType.FLOAT32) {
            this.standardDeviation(DType.FLOAT64);
        }
        return this.standardDeviation(this.type);
    }

    public Scalar standardDeviation(DType outType) {
        return this.reduce(ReductionOp.STD, outType);
    }

    public Scalar reduce(ReductionOp op) {
        return this.reduce(op, this.type);
    }

    public Scalar reduce(ReductionOp op, DType outType) {
        return Cudf.reduce(this, op, outType);
    }

    public ColumnVector not() {
        return this.unaryOp(UnaryOp.NOT);
    }

    public ColumnVector castTo(DType type, TimeUnit unit) {
        if (this.type == type && this.tsTimeUnit == unit) {
            return this.incRefCount();
        }
        return new ColumnVector(Cudf.gdfCast(this, type, unit));
    }

    public ColumnVector asBytes() {
        return this.castTo(DType.INT8, TimeUnit.NONE);
    }

    public ColumnVector asShorts() {
        return this.castTo(DType.INT16, TimeUnit.NONE);
    }

    public ColumnVector asInts() {
        return this.castTo(DType.INT32, TimeUnit.NONE);
    }

    public ColumnVector asLongs() {
        return this.castTo(DType.INT64, TimeUnit.NONE);
    }

    public ColumnVector asFloats() {
        return this.castTo(DType.FLOAT32, TimeUnit.NONE);
    }

    public ColumnVector asDoubles() {
        return this.castTo(DType.FLOAT64, TimeUnit.NONE);
    }

    public ColumnVector asDate32() {
        return this.castTo(DType.DATE32, TimeUnit.NONE);
    }

    public ColumnVector asDate64() {
        return this.castTo(DType.DATE64, TimeUnit.NONE);
    }

    public ColumnVector asTimestamp(TimeUnit unit) {
        return this.castTo(DType.TIMESTAMP, unit);
    }

    public ColumnVector asStrings() {
        return this.castTo(DType.STRING, TimeUnit.NONE);
    }

    public ColumnVector asStringCategories() {
        return this.castTo(DType.STRING_CATEGORY, TimeUnit.NONE);
    }

    public Scalar getCategoryIndex(Scalar s) {
        if (s.getType() != DType.STRING) {
            throw new IllegalArgumentException("scalar must be a string type");
        }
        return Scalar.fromInt(Cudf.getCategoryIndex(this, s));
    }

    public final long getNativeCudfColumnAddress() {
        if (this.offHeap.nativeCudfColumnHandle == 0L) {
            assert (this.rows <= Integer.MAX_VALUE);
            assert (this.getNullCount() <= Integer.MAX_VALUE);
            this.checkHasDeviceData();
            this.offHeap.nativeCudfColumnHandle = ColumnVector.allocateCudfColumn();
            long dataAddr = 0L;
            long validAddr = 0L;
            if (this.rows != 0L) {
                dataAddr = ((DeviceMemoryBuffer)this.offHeap.getDeviceData().data).getAddress();
                if (this.offHeap.getDeviceData().valid != null) {
                    validAddr = ((DeviceMemoryBuffer)this.offHeap.getDeviceData().valid).getAddress();
                }
            }
            ColumnVector.cudfColumnViewAugmented(this.offHeap.nativeCudfColumnHandle, dataAddr, validAddr, (int)this.rows, this.type.nativeId, (int)this.getNullCount(), this.tsTimeUnit.getNativeId());
        }
        return this.offHeap.nativeCudfColumnHandle;
    }

    private static native long allocateCudfColumn() throws CudfException;

    private static native long cudfByteCount(long var0) throws CudfException;

    private static native void cudfColumnViewAugmented(long var0, long var2, long var4, int var6, int var7, int var8, int var9) throws CudfException;

    private native long[] cudfSlice(long var1, long var3) throws CudfException;

    private static native void cudfColumnViewStrings(long var0, long var2, boolean var4, long var5, boolean var7, long var8, long var10, int var12, int var13, int var14);

    private native Scalar exactQuantile(long var1, int var3, double var4) throws CudfException;

    private native Scalar approxQuantile(long var1, double var3) throws CudfException;

    private static native long cudfLengths(long var0) throws CudfException;

    private static native long hash(long var0, int var2) throws CudfException;

    private static native long[] getStringDataAndOffsetsBack(long var0);

    static native void freeCudfColumn(long var0, boolean var2) throws CudfException;

    private static native long getDataPtr(long var0) throws CudfException;

    private static native long getValidPtr(long var0) throws CudfException;

    private static native int getRowCount(long var0) throws CudfException;

    private static DType getDType(long cudfColumnHandle) throws CudfException {
        return DType.fromNative(ColumnVector.getDTypeInternal(cudfColumnHandle));
    }

    private static native int getDTypeInternal(long var0) throws CudfException;

    private static TimeUnit getTimeUnit(long cudfColumnHandle) throws CudfException {
        return TimeUnit.fromNative(ColumnVector.getTimeUnitInternal(cudfColumnHandle));
    }

    private static native int getTimeUnitInternal(long var0) throws CudfException;

    private static native int getNullCount(long var0) throws CudfException;

    private static native long concatenate(long[] var0) throws CudfException;

    public static Builder builder(DType type, int rows) {
        return new Builder(type, TimeUnit.NONE, rows, 0L);
    }

    public static Builder builder(DType type, TimeUnit tsTimeUnit, int rows) {
        return new Builder(type, tsTimeUnit, rows, 0L);
    }

    public static Builder builder(DType type, int rows, long stringBufferSize) {
        assert (type == DType.STRING_CATEGORY || type == DType.STRING);
        return new Builder(type, TimeUnit.NONE, rows, stringBufferSize);
    }

    public static ColumnVector build(DType type, int rows, Consumer<Builder> init) {
        return ColumnVector.build(type, TimeUnit.NONE, rows, init);
    }

    public static ColumnVector build(DType type, TimeUnit tsTimeUnit, int rows, Consumer<Builder> init) {
        try (Builder builder = ColumnVector.builder(type, tsTimeUnit, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.build();
            return columnVector;
        }
    }

    public static ColumnVector build(DType type, int rows, long stringBufferSize, Consumer<Builder> init) {
        try (Builder builder = ColumnVector.builder(type, rows, stringBufferSize);){
            init.accept(builder);
            ColumnVector columnVector = builder.build();
            return columnVector;
        }
    }

    public static ColumnVector buildOnHost(DType type, int rows, Consumer<Builder> init) {
        return ColumnVector.buildOnHost(type, TimeUnit.NONE, rows, init);
    }

    public static ColumnVector buildOnHost(DType type, TimeUnit tsTimeUnit, int rows, Consumer<Builder> init) {
        try (Builder builder = ColumnVector.builder(type, tsTimeUnit, rows);){
            init.accept(builder);
            ColumnVector columnVector = builder.buildOnHost();
            return columnVector;
        }
    }

    public static ColumnVector boolFromBytes(byte ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromBytes(byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromShorts(short ... values) {
        return ColumnVector.build(DType.INT16, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromInts(int ... values) {
        return ColumnVector.build(DType.INT32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromLongs(long ... values) {
        return ColumnVector.build(DType.INT64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromFloats(float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector fromDoubles(double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector datesFromInts(int ... values) {
        return ColumnVector.build(DType.DATE32, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector datesFromLongs(long ... values) {
        return ColumnVector.build(DType.DATE64, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector timestampsFromLongs(long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, values.length, b -> b.appendArray(values));
    }

    public static ColumnVector timestampsFromLongs(TimeUnit tsTimeUnit, long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, tsTimeUnit, values.length, (Builder b) -> b.appendArray(values));
    }

    private static ColumnVector fromStrings(DType type, String ... values) {
        assert (type == DType.STRING || type == DType.STRING_CATEGORY);
        int rows = values.length;
        long nullCount = 0L;
        long bufferSize = 0L;
        for (String s : values) {
            if (s == null) {
                ++nullCount;
                continue;
            }
            bufferSize += (long)s.getBytes(StandardCharsets.UTF_8).length;
        }
        if (nullCount > 0L) {
            return ColumnVector.build(type, rows, bufferSize, (Builder b) -> b.appendBoxed(values));
        }
        return ColumnVector.build(type, rows, bufferSize, (Builder b) -> {
            for (String s : values) {
                b.append(s);
            }
        });
    }

    public static ColumnVector categoryFromStrings(String ... values) {
        return ColumnVector.fromStrings(DType.STRING_CATEGORY, values);
    }

    public static ColumnVector fromStrings(String ... values) {
        return ColumnVector.fromStrings(DType.STRING, values);
    }

    public static ColumnVector fromBoxedBooleans(Boolean ... values) {
        return ColumnVector.build(DType.BOOL8, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedBytes(Byte ... values) {
        return ColumnVector.build(DType.INT8, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedShorts(Short ... values) {
        return ColumnVector.build(DType.INT16, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.INT32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.INT64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedFloats(Float ... values) {
        return ColumnVector.build(DType.FLOAT32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector fromBoxedDoubles(Double ... values) {
        return ColumnVector.build(DType.FLOAT64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector datesFromBoxedInts(Integer ... values) {
        return ColumnVector.build(DType.DATE32, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector datesFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.DATE64, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector timestampsFromBoxedLongs(Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, values.length, b -> b.appendBoxed(values));
    }

    public static ColumnVector timestampsFromBoxedLongs(TimeUnit tsTimeUnit, Long ... values) {
        return ColumnVector.build(DType.TIMESTAMP, tsTimeUnit, values.length, (Builder b) -> b.appendBoxed(values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnVector fromScalar(Scalar scalar, int rows) {
        if (scalar.getType() == DType.STRING || scalar.getType() == DType.STRING_CATEGORY) {
            throw new IllegalArgumentException("STRING and STRING_CATEGORY are not supported scalars");
        }
        DeviceMemoryBuffer dataBuffer = null;
        ColumnVector cv = null;
        boolean needsCleanup = true;
        try {
            dataBuffer = DeviceMemoryBuffer.allocate(scalar.type.sizeInBytes * rows);
            cv = new ColumnVector(scalar.getType(), scalar.getTimeUnit(), rows, 0L, dataBuffer, null, null, false);
            dataBuffer = null;
            ColumnVector.cudfColumnViewAugmented(cv.getNativeCudfColumnAddress(), ((DeviceMemoryBuffer)cv.offHeap.getDeviceData().data).address, 0L, (int)cv.getRowCount(), cv.getType().nativeId, 0, cv.getTimeUnit().getNativeId());
            cv.fill(scalar);
            needsCleanup = false;
            ColumnVector columnVector = cv;
            return columnVector;
        }
        finally {
            if (needsCleanup) {
                if (dataBuffer != null) {
                    dataBuffer.close();
                }
                if (cv != null) {
                    cv.close();
                }
            }
        }
    }

    public static ColumnVector concatenate(ColumnVector ... columns) {
        if (columns.length < 2) {
            throw new IllegalArgumentException("Concatenate requires 2 or more columns");
        }
        long[] columnHandles = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnHandles[i] = columns[i].getNativeCudfColumnAddress();
        }
        return new ColumnVector(ColumnVector.concatenate(columnHandles));
    }

    public Scalar exactQuantile(QuantileMethod method, double quantile) {
        return this.exactQuantile(this.getNativeCudfColumnAddress(), method.nativeId, quantile);
    }

    public Scalar approxQuantile(double quantile) {
        return this.approxQuantile(this.getNativeCudfColumnAddress(), quantile);
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class Builder
    implements AutoCloseable {
        private final long rows;
        private final DType type;
        private final TimeUnit tsTimeUnit;
        private HostMemoryBuffer data;
        private HostMemoryBuffer valid;
        private HostMemoryBuffer offsets;
        private long currentIndex = 0L;
        private long nullCount;
        private long stringBufferSize = 0L;
        private int currentStringByteIndex = 0;
        private boolean built;

        Builder(DType type, TimeUnit tsTimeUnit, long rows, long stringBufferSize) {
            this.type = type;
            this.tsTimeUnit = tsTimeUnit;
            this.rows = rows;
            if (type == DType.STRING || type == DType.STRING_CATEGORY) {
                if (stringBufferSize <= 0L) {
                    stringBufferSize = 1L;
                }
                this.data = HostMemoryBuffer.allocate(stringBufferSize);
                this.offsets = HostMemoryBuffer.allocate((rows + 1L) * (long)OFFSET_SIZE);
                this.offsets.setInt(0L, 0);
                this.stringBufferSize = stringBufferSize;
            } else {
                this.data = HostMemoryBuffer.allocate(rows * (long)type.sizeInBytes);
            }
        }

        Builder(DType type, TimeUnit tsTimeUnit, long rows, HostMemoryBuffer testData, HostMemoryBuffer testValid, HostMemoryBuffer testOffsets) {
            this.type = type;
            this.tsTimeUnit = tsTimeUnit;
            this.rows = rows;
            this.data = testData;
            this.valid = testValid;
        }

        public final Builder append(boolean value) {
            assert (this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value ? (byte)1 : 0);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value) {
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            assert (this.currentIndex < this.rows);
            this.data.setByte(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(byte value, long count) {
            assert (count + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setMemory(this.currentIndex * (long)this.type.sizeInBytes, count, value);
            this.currentIndex += count;
            return this;
        }

        public final Builder append(short value) {
            assert (this.type == DType.INT16);
            assert (this.currentIndex < this.rows);
            this.data.setShort(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(int value) {
            assert (this.type == DType.INT32 || this.type == DType.DATE32);
            assert (this.currentIndex < this.rows);
            this.data.setInt(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(long value) {
            assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
            assert (this.currentIndex < this.rows);
            this.data.setLong(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(float value) {
            assert (this.type == DType.FLOAT32);
            assert (this.currentIndex < this.rows);
            this.data.setFloat(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public final Builder append(double value) {
            assert (this.type == DType.FLOAT64);
            assert (this.currentIndex < this.rows);
            this.data.setDouble(this.currentIndex * (long)this.type.sizeInBytes, value);
            ++this.currentIndex;
            return this;
        }

        public Builder append(String value) {
            assert (value != null) : "appendNull must be used to append null strings";
            return this.appendUTF8String(value.getBytes(StandardCharsets.UTF_8));
        }

        public Builder appendUTF8String(byte[] value) {
            return this.appendUTF8String(value, 0, value.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder appendUTF8String(byte[] value, int offset, int length) {
            long oldLen;
            long newLen;
            assert (value != null) : "appendNull must be used to append null strings";
            assert (offset >= 0);
            assert (length >= 0);
            assert (value.length + offset <= length);
            assert (this.type == DType.STRING_CATEGORY || this.type == DType.STRING);
            assert (this.currentIndex < this.rows);
            for (newLen = oldLen = this.data.getLength(); (long)(this.currentStringByteIndex + length) > newLen; newLen *= 2L) {
            }
            if (newLen > Integer.MAX_VALUE) {
                throw new IllegalStateException("A string buffer is not supported over 2GB in size");
            }
            if (newLen != oldLen) {
                try (HostMemoryBuffer newData = HostMemoryBuffer.allocate(newLen);){
                    newData.copyFromHostBuffer(0L, this.data, 0L, this.currentStringByteIndex);
                    this.data.close();
                    this.data = newData;
                    newData = null;
                }
            }
            if (length > 0) {
                this.data.setBytes(this.currentStringByteIndex, value, offset, length);
            }
            this.currentStringByteIndex += length;
            ++this.currentIndex;
            this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            return this;
        }

        public Builder appendArray(byte ... values) {
            assert ((long)values.length + this.currentIndex <= this.rows);
            assert (this.type == DType.INT8 || this.type == DType.BOOL8);
            this.data.setBytes(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(short ... values) {
            assert (this.type == DType.INT16);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setShorts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(int ... values) {
            assert (this.type == DType.INT32 || this.type == DType.DATE32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setInts(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(long ... values) {
            assert (this.type == DType.INT64 || this.type == DType.DATE64 || this.type == DType.TIMESTAMP);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setLongs(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(float ... values) {
            assert (this.type == DType.FLOAT32);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setFloats(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public Builder appendArray(double ... values) {
            assert (this.type == DType.FLOAT64);
            assert ((long)values.length + this.currentIndex <= this.rows);
            this.data.setDoubles(this.currentIndex * (long)this.type.sizeInBytes, values, 0L, values.length);
            this.currentIndex += (long)values.length;
            return this;
        }

        public final Builder appendBoxed(Byte ... values) throws IndexOutOfBoundsException {
            for (Byte b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Boolean ... values) throws IndexOutOfBoundsException {
            for (Boolean b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b != false ? (byte)1 : 0);
            }
            return this;
        }

        public final Builder appendBoxed(Short ... values) throws IndexOutOfBoundsException {
            for (Short b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Integer ... values) throws IndexOutOfBoundsException {
            for (Integer b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Long ... values) throws IndexOutOfBoundsException {
            for (Long b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(Float ... values) throws IndexOutOfBoundsException {
            for (Float b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b.floatValue());
            }
            return this;
        }

        public final Builder appendBoxed(Double ... values) throws IndexOutOfBoundsException {
            for (Double b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder appendBoxed(String ... values) throws IndexOutOfBoundsException {
            for (String b : values) {
                if (b == null) {
                    this.appendNull();
                    continue;
                }
                this.append(b);
            }
            return this;
        }

        public final Builder append(ColumnVector columnVector) {
            assert (columnVector.rows <= this.rows - this.currentIndex);
            assert (columnVector.type == this.type);
            assert (columnVector.offHeap.getHostData() != null);
            if (this.type == DType.STRING_CATEGORY || this.type == DType.STRING) {
                throw new UnsupportedOperationException("Appending a string column vector client side is not currently supported");
            }
            this.data.copyFromHostBuffer(this.currentIndex * (long)this.type.sizeInBytes, (HostMemoryBuffer)((ColumnVector)columnVector).offHeap.getHostData().data, 0L, columnVector.getRowCount() * (long)this.type.sizeInBytes);
            if (columnVector.nullCount != 0L) {
                if (this.valid == null) {
                    this.allocateBitmaskAndSetDefaultValues();
                }
                BitVectorHelper.append((HostMemoryBuffer)((ColumnVector)columnVector).offHeap.getHostData().valid, this.valid, this.currentIndex, columnVector.rows);
                this.nullCount += columnVector.nullCount;
            }
            this.currentIndex += columnVector.rows;
            return this;
        }

        private void allocateBitmaskAndSetDefaultValues() {
            long bitmaskSize = BitVectorHelper.getValidityAllocationSizeInBytes(this.rows);
            this.valid = HostMemoryBuffer.allocate(bitmaskSize);
            this.valid.setMemory(0L, bitmaskSize, (byte)-1);
        }

        public final Builder appendNull() {
            this.setNullAt(this.currentIndex);
            ++this.currentIndex;
            if (this.type == DType.STRING || this.type == DType.STRING_CATEGORY) {
                this.offsets.setInt(this.currentIndex * (long)OFFSET_SIZE, this.currentStringByteIndex);
            }
            return this;
        }

        public final Builder setNullAt(long index) {
            assert (index < this.rows);
            if (this.valid == null) {
                this.allocateBitmaskAndSetDefaultValues();
            }
            this.nullCount += (long)BitVectorHelper.setNullAt(this.valid, index);
            return this;
        }

        public final ColumnVector build() {
            if (this.built) {
                throw new IllegalStateException("Cannot reuse a builder.");
            }
            ColumnVector cv = new ColumnVector(this.type, this.tsTimeUnit, this.currentIndex, this.nullCount, this.data, this.valid, this.offsets);
            try {
                cv.ensureOnDevice();
                this.built = true;
            }
            finally {
                if (!this.built) {
                    cv.close();
                }
            }
            return cv;
        }

        public final ColumnVector buildOnHost() {
            if (this.built) {
                throw new IllegalStateException("Cannot reuse a builder.");
            }
            ColumnVector cv = new ColumnVector(this.type, this.tsTimeUnit, this.currentIndex, this.nullCount, this.data, this.valid, this.offsets);
            this.built = true;
            return cv;
        }

        @Override
        public final void close() {
            if (!this.built) {
                this.data.close();
                this.data = null;
                if (this.valid != null) {
                    this.valid.close();
                    this.valid = null;
                }
                if (this.offsets != null) {
                    this.offsets.close();
                    this.offsets = null;
                }
                this.built = true;
            }
        }

        public String toString() {
            return "Builder{data=" + this.data + "type=" + (Object)((Object)this.type) + ", valid=" + this.valid + ", currentIndex=" + this.currentIndex + ", nullCount=" + this.nullCount + ", rows=" + this.rows + ", built=" + this.built + '}';
        }
    }

    protected static final class OffHeapState
    extends MemoryCleaner.Cleaner {
        private BufferEncapsulator<HostMemoryBuffer> hostData;
        private BufferEncapsulator<DeviceMemoryBuffer> deviceData;
        private long nativeCudfColumnHandle = 0L;

        protected OffHeapState() {
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.getHostData() != null) {
                this.getHostData().close();
                this.setHostData(null);
                neededCleanup = true;
            }
            if (this.getDeviceData() != null) {
                this.getDeviceData().close();
                this.setDeviceData(null);
                neededCleanup = true;
            }
            if (this.nativeCudfColumnHandle != 0L) {
                ColumnVector.freeCudfColumn(this.nativeCudfColumnHandle, false);
                this.nativeCudfColumnHandle = 0L;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("YOU LEAKED A COLUMN VECTOR!!!!");
                this.logRefCountDebug("Leaked vector");
            }
            return neededCleanup;
        }

        public BufferEncapsulator<HostMemoryBuffer> getHostData() {
            return this.hostData;
        }

        public void setHostData(BufferEncapsulator<HostMemoryBuffer> hostData) {
            if (this.isLeakExpected() && hostData != null) {
                hostData.noWarnLeakExpected();
            }
            this.hostData = hostData;
        }

        public BufferEncapsulator<DeviceMemoryBuffer> getDeviceData() {
            return this.deviceData;
        }

        public void setDeviceData(BufferEncapsulator<DeviceMemoryBuffer> deviceData) {
            if (this.isLeakExpected() && deviceData != null) {
                deviceData.noWarnLeakExpected();
            }
            this.deviceData = deviceData;
        }
    }

    private static final class BufferEncapsulator<T extends MemoryBuffer>
    implements AutoCloseable {
        public final T data;
        public final T valid;
        public final T offsets;

        BufferEncapsulator(T data, T valid, T offsets) {
            this.data = data;
            this.valid = valid;
            this.offsets = offsets;
        }

        public String toString() {
            T type = this.data == null ? this.valid : this.data;
            type = type == null ? this.offsets : type;
            String t = "UNKNOWN";
            if (type != null) {
                t = type.getClass().getSimpleName();
            }
            return "BufferEncapsulator{type= " + t + ", data= " + this.data + ", valid= " + this.valid + ", offsets= " + this.offsets + "}";
        }

        @Override
        public void close() {
            if (this.data != null) {
                ((MemoryBuffer)this.data).close();
            }
            if (this.valid != null) {
                ((MemoryBuffer)this.valid).close();
            }
            if (this.offsets != null) {
                ((MemoryBuffer)this.offsets).close();
            }
        }

        public void noWarnLeakExpected() {
            if (this.data != null) {
                ((MemoryBuffer)this.data).noWarnLeakExpected();
            }
            if (this.valid != null) {
                ((MemoryBuffer)this.valid).noWarnLeakExpected();
            }
            if (this.offsets != null) {
                ((MemoryBuffer)this.offsets).noWarnLeakExpected();
            }
        }
    }

    static enum BufferType {
        VALIDITY,
        OFFSET,
        DATA;

    }
}

