/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.CudaException;
import ai.rapids.cudf.CudaMemInfo;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.NativeDepsLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cuda {
    static final int CPU_DEVICE_ID = -1;
    private static final Logger log = LoggerFactory.getLogger(Cuda.class);
    private static Boolean isCompat = null;

    public static native CudaMemInfo memGetInfo() throws CudaException;

    static void memcpy(long dst, long src, long count, CudaMemcpyKind kind) {
        Cuda.memcpy(dst, src, count, kind.getValue());
    }

    private static native void memcpy(long var0, long var2, long var4, int var6) throws CudaException;

    public static native void memset(long var0, byte var2, long var3) throws CudaException;

    public static native int getDevice() throws CudaException;

    public static synchronized boolean isEnvCompatibleForTesting() {
        if (isCompat == null) {
            if (NativeDepsLoader.libraryLoaded()) {
                try {
                    int device = Cuda.getDevice();
                    if (device >= 0) {
                        isCompat = true;
                        return isCompat;
                    }
                }
                catch (Throwable e) {
                    log.error("Error trying to detect device", e);
                }
            }
            isCompat = false;
        }
        return isCompat;
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }
}

