/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.ReductionOp;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.TimeUnit;
import ai.rapids.cudf.UnaryOp;

class Cudf {
    Cudf() {
    }

    static long gdfUnaryMath(ColumnVector input, UnaryOp op, DType outputType) {
        return Cudf.gdfUnaryMath(input.getNativeCudfColumnAddress(), op.nativeId, outputType.nativeId);
    }

    private static native long gdfUnaryMath(long var0, int var2, int var3);

    static long gdfBinaryOp(ColumnVector lhs, ColumnVector rhs, BinaryOp op, DType outputType) {
        return Cudf.gdfBinaryOpVV(lhs.getNativeCudfColumnAddress(), rhs.getNativeCudfColumnAddress(), op.nativeId, outputType.nativeId);
    }

    private static native long gdfBinaryOpVV(long var0, long var2, int var4, int var5);

    static long gdfBinaryOp(Scalar lhs, ColumnVector rhs, BinaryOp op, DType outputType) {
        if (rhs.getType() == DType.STRING_CATEGORY && lhs.getType() == DType.STRING && BinaryOp.COMPARISON.contains((Object)op)) {
            lhs = rhs.getCategoryIndex(lhs);
        }
        return Cudf.gdfBinaryOpSV(lhs.intTypeStorage, lhs.floatTypeStorage, lhs.doubleTypeStorage, lhs.isValid, lhs.type.nativeId, rhs.getNativeCudfColumnAddress(), op.nativeId, outputType.nativeId);
    }

    private static native long gdfBinaryOpSV(long var0, float var2, double var3, boolean var5, int var6, long var7, int var9, int var10);

    static long gdfBinaryOp(ColumnVector lhs, Scalar rhs, BinaryOp op, DType outputType) {
        if (lhs.getType() == DType.STRING_CATEGORY && rhs.getType() == DType.STRING && BinaryOp.COMPARISON.contains((Object)op)) {
            rhs = lhs.getCategoryIndex(rhs);
        }
        return Cudf.gdfBinaryOpVS(lhs.getNativeCudfColumnAddress(), rhs.intTypeStorage, rhs.floatTypeStorage, rhs.doubleTypeStorage, rhs.isValid, rhs.type.nativeId, op.nativeId, outputType.nativeId);
    }

    private static native long gdfBinaryOpVS(long var0, long var2, float var4, double var5, boolean var7, int var8, int var9, int var10);

    static long replaceNulls(ColumnVector input, Scalar replacement) {
        return Cudf.replaceNulls(input.getNativeCudfColumnAddress(), replacement.intTypeStorage, replacement.floatTypeStorage, replacement.doubleTypeStorage, replacement.isValid, replacement.type.nativeId);
    }

    private static native long replaceNulls(long var0, long var2, float var4, double var5, boolean var7, int var8);

    static void fill(ColumnVector input, Scalar value) {
        Cudf.fill(input.getNativeCudfColumnAddress(), value.intTypeStorage, value.floatTypeStorage, value.doubleTypeStorage, value.isValid, value.type.nativeId);
    }

    private static native void fill(long var0, long var2, float var4, double var5, boolean var7, int var8);

    static Scalar reduce(ColumnVector v, ReductionOp op, DType outType) {
        return Cudf.reduce(v.getNativeCudfColumnAddress(), op.nativeId, outType.nativeId);
    }

    private static native Scalar reduce(long var0, int var2, int var3);

    static long gdfExtractDatetimeYear(ColumnVector input) {
        return Cudf.gdfExtractDatetimeYear(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeYear(long var0) throws CudfException;

    static long gdfExtractDatetimeMonth(ColumnVector input) {
        return Cudf.gdfExtractDatetimeMonth(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeMonth(long var0) throws CudfException;

    static long gdfExtractDatetimeDay(ColumnVector input) {
        return Cudf.gdfExtractDatetimeDay(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeDay(long var0) throws CudfException;

    static long gdfExtractDatetimeHour(ColumnVector input) {
        return Cudf.gdfExtractDatetimeHour(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeHour(long var0) throws CudfException;

    static long gdfExtractDatetimeMinute(ColumnVector input) {
        return Cudf.gdfExtractDatetimeMinute(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeMinute(long var0) throws CudfException;

    static long gdfExtractDatetimeSecond(ColumnVector input) {
        return Cudf.gdfExtractDatetimeSecond(input.getNativeCudfColumnAddress());
    }

    private static native long gdfExtractDatetimeSecond(long var0) throws CudfException;

    static long gdfCast(ColumnVector input, DType outType, TimeUnit outUnit) {
        return Cudf.gdfCast(input.getNativeCudfColumnAddress(), outType.nativeId, outUnit.getNativeId());
    }

    private static native long gdfCast(long var0, int var2, int var3) throws CudfException;

    static int getCategoryIndex(ColumnVector category, Scalar str) {
        return Cudf.getCategoryIndex(category.getNativeCudfColumnAddress(), str.stringTypeStorage);
    }

    private static native int getCategoryIndex(long var0, byte[] var2);

    static {
        NativeDepsLoader.loadNativeDeps();
    }
}

