/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.CudaMemcpyKind;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.MemoryCleaner;
import ai.rapids.cudf.Rmm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeviceMemoryBuffer
extends MemoryBuffer {
    private static final Logger log = LoggerFactory.getLogger(DeviceMemoryBuffer.class);

    DeviceMemoryBuffer(long address, long lengthInBytes) {
        super(address, lengthInBytes, new DeviceBufferCleaner(address));
    }

    private DeviceMemoryBuffer(long address, long lengthInBytes, DeviceMemoryBuffer parent) {
        super(address, lengthInBytes, parent);
    }

    public static DeviceMemoryBuffer allocate(long bytes) {
        return new DeviceMemoryBuffer(Rmm.alloc(bytes, 0L), bytes);
    }

    final void copyFromHostBuffer(HostMemoryBuffer hostBuffer) {
        this.addressOutOfBoundsCheck(this.address, hostBuffer.length, "copy range dest");
        assert (!hostBuffer.closed);
        Cuda.memcpy(this.address, hostBuffer.address, hostBuffer.length, CudaMemcpyKind.HOST_TO_DEVICE);
    }

    final DeviceMemoryBuffer slice(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        ++this.refCount;
        this.cleaner.addRef();
        return new DeviceMemoryBuffer(this.getAddress() + offset, len, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final DeviceMemoryBuffer sliceWithCopy(long offset, long len) {
        this.addressOutOfBoundsCheck(this.address + offset, len, "slice");
        DeviceMemoryBuffer ret = null;
        boolean success = false;
        try {
            ret = DeviceMemoryBuffer.allocate(len);
            Cuda.memcpy(ret.getAddress(), this.getAddress() + offset, len, CudaMemcpyKind.DEVICE_TO_DEVICE);
            success = true;
            DeviceMemoryBuffer deviceMemoryBuffer = ret;
            return deviceMemoryBuffer;
        }
        finally {
            if (!success && ret != null) {
                ret.close();
            }
        }
    }

    private static final class DeviceBufferCleaner
    extends MemoryCleaner.Cleaner {
        private long address;

        DeviceBufferCleaner(long address) {
            this.address = address;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.address != 0L) {
                Rmm.free(this.address, 0L);
                this.address = 0L;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("WE LEAKED A DEVICE BUFFER!!!!");
                this.logRefCountDebug("Leaked device buffer");
            }
            return neededCleanup;
        }
    }
}

