/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BitVectorHelper;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.Table;
import ai.rapids.cudf.TimeUnit;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JCudfSerialization {
    private static final int SER_FORMAT_MAGIC_NUMBER = 1129661510;
    private static final short VERSION_NUMBER = 0;

    private static long padFor64bitAlignment(long orig) {
        return (orig + 7L) / 8L * 8L;
    }

    private static long padFor64bitAlignment(DataOutputStream out, long bytes) throws IOException {
        long paddedBytes = JCudfSerialization.padFor64bitAlignment(bytes);
        while (paddedBytes > bytes) {
            out.writeByte(0);
            ++bytes;
        }
        return paddedBytes;
    }

    public static long getSerializedSizeInBytes(ColumnVector[] columns, long rowOffset, long numRows) {
        return JCudfSerialization.getSerializedDataSizeInBytes(columns, rowOffset, numRows) + 12L + 2L;
    }

    private static long getSerializedDataSizeInBytes(ColumnVector[] columns, long rowOffset, long numRows) {
        long total = 0L;
        for (int i = 0; i < columns.length; ++i) {
            total += JCudfSerialization.getSerializedDataSizeInBytes(columns[i], rowOffset, numRows);
        }
        return total;
    }

    private static long getSerializedDataSizeInBytes(ColumnVector column, long rowOffset, long numRows) {
        DType type = column.getType();
        long total = 0L;
        if (column.getNullCount() > 0L) {
            total += JCudfSerialization.padFor64bitAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
        }
        if (type == DType.STRING || type == DType.STRING_CATEGORY) {
            total += JCudfSerialization.padFor64bitAlignment((numRows + 1L) * 4L);
            long start = column.getStartStringOffset(rowOffset);
            long end = column.getEndStringOffset(rowOffset + numRows - 1L);
            total += JCudfSerialization.padFor64bitAlignment(end - start);
        } else {
            total += JCudfSerialization.padFor64bitAlignment((long)column.getType().sizeInBytes * numRows);
        }
        return total;
    }

    public static void writeToStream(Table t, OutputStream out, long rowOffset, long numRows) throws IOException {
        JCudfSerialization.writeToStream(t.getColumns(), out, rowOffset, numRows);
    }

    public static void writeToStream(ColumnVector[] columns, OutputStream out, long rowOffset, long numRows) throws IOException {
        if (!(out instanceof DataOutputStream)) {
            out = new DataOutputStream(new BufferedOutputStream(out));
        }
        JCudfSerialization.writeToDataStream(columns, (DataOutputStream)out, rowOffset, numRows);
    }

    private static void writeToDataStream(ColumnVector[] columns, DataOutputStream out, long rowOffset, long numRows) throws IOException {
        int i;
        assert (rowOffset >= 0L);
        assert (numRows >= 0L);
        for (i = 0; i < columns.length; ++i) {
            long rows = columns[i].getRowCount();
            assert (rowOffset + numRows <= rows);
            long nc = columns[i].getNullCount();
            assert (nc == (long)((int)nc)) : "can only support an int for indexes";
            assert (rows == (long)((int)rows)) : "can only support an int for indexes";
        }
        out.writeInt(1129661510);
        out.writeShort(0);
        out.writeInt(columns.length);
        out.writeInt((int)numRows);
        for (i = 0; i < columns.length; ++i) {
            out.writeInt(columns[i].getType().nativeId);
            long nc = columns[i].getNullCount();
            if (nc != 0L && (rowOffset != 0L || numRows != columns[i].getRowCount())) {
                nc = 1L;
            }
            out.writeInt((int)nc);
            out.writeInt(columns[i].getTimeUnit().getNativeId());
        }
        out.writeLong(JCudfSerialization.getSerializedDataSizeInBytes(columns, rowOffset, numRows));
        for (i = 0; i < columns.length; ++i) {
            JCudfSerialization.writeColumnToDataStream(out, columns[i], rowOffset, numRows);
        }
        out.flush();
    }

    private static void writeColumnToDataStream(DataOutputStream out, ColumnVector column, long rowOffset, long numRows) throws IOException {
        DType type;
        column.ensureOnHost();
        byte[] arrayBuffer = new byte[131072];
        if (column.getNullCount() > 0L) {
            JCudfSerialization.copyValidityData(out, column, rowOffset, numRows, arrayBuffer);
        }
        if ((type = column.getType()) == DType.STRING || type == DType.STRING_CATEGORY) {
            JCudfSerialization.copyStringOffsets(out, column, rowOffset, numRows, arrayBuffer);
            JCudfSerialization.copyStringData(out, column, rowOffset, numRows, arrayBuffer);
        } else {
            JCudfSerialization.copyBasicData(out, column, rowOffset, numRows, arrayBuffer);
        }
    }

    static long copyValidityData(DataOutputStream out, ColumnVector column, long rowOffset, long numRows, byte[] arrayBuffer) throws IOException {
        assert (arrayBuffer.length > 1);
        long validityLen = BitVectorHelper.getValidityLengthInBytes(numRows);
        long maxValidityLen = BitVectorHelper.getValidityLengthInBytes(column.getRowCount());
        long byteOffset = rowOffset / 8L;
        long bytesLeft = validityLen;
        int lshift = (int)rowOffset % 8;
        if (lshift == 0) {
            while (bytesLeft > 0L) {
                int amountToCopy = (int)Math.min(bytesLeft, (long)arrayBuffer.length);
                column.copyHostBufferBytes(arrayBuffer, 0, ColumnVector.BufferType.VALIDITY, byteOffset, amountToCopy);
                out.write(arrayBuffer, 0, amountToCopy);
                bytesLeft -= (long)amountToCopy;
                byteOffset += (long)amountToCopy;
            }
        } else {
            int rshift = 8 - lshift;
            while (bytesLeft > 0L) {
                int amountToCopy = (int)Math.min(bytesLeft, (long)(arrayBuffer.length - 1));
                int amountToCopyWithSpill = amountToCopy + 1;
                if ((long)amountToCopyWithSpill + byteOffset > maxValidityLen) {
                    amountToCopyWithSpill = amountToCopy;
                    arrayBuffer[amountToCopy] = 0;
                }
                column.copyHostBufferBytes(arrayBuffer, 0, ColumnVector.BufferType.VALIDITY, byteOffset, amountToCopyWithSpill);
                byte currentByte = arrayBuffer[0];
                for (int byteIndex = 0; byteIndex < amountToCopy; ++byteIndex) {
                    byte nextByte = arrayBuffer[byteIndex + 1];
                    arrayBuffer[byteIndex] = (byte)(nextByte << rshift | (0xFF & currentByte) >> lshift);
                    currentByte = nextByte;
                }
                out.write(arrayBuffer, 0, amountToCopy);
                bytesLeft -= (long)amountToCopy;
                byteOffset += (long)amountToCopy;
            }
        }
        return JCudfSerialization.padFor64bitAlignment(out, validityLen);
    }

    private static long copyAndPad(DataOutputStream out, ColumnVector column, ColumnVector.BufferType buffer, long offset, long length, byte[] tmpBuffer) throws IOException {
        long left = length;
        long at = offset;
        while (left > 0L) {
            int amountToCopy = (int)Math.min(left, (long)tmpBuffer.length);
            column.copyHostBufferBytes(tmpBuffer, 0, buffer, at, amountToCopy);
            out.write(tmpBuffer, 0, amountToCopy);
            left -= (long)amountToCopy;
            at += (long)amountToCopy;
        }
        return JCudfSerialization.padFor64bitAlignment(out, length);
    }

    private static long copyBasicData(DataOutputStream out, ColumnVector column, long rowOffset, long numRows, byte[] arrayBuffer) throws IOException {
        DType type = column.getType();
        long bytesToCopy = numRows * (long)type.sizeInBytes;
        long srcOffset = rowOffset * (long)type.sizeInBytes;
        return JCudfSerialization.copyAndPad(out, column, ColumnVector.BufferType.DATA, srcOffset, bytesToCopy, arrayBuffer);
    }

    private static long copyStringData(DataOutputStream out, ColumnVector column, long rowOffset, long numRows, byte[] arrayBuffer) throws IOException {
        long startByteOffset = column.getStartStringOffset(rowOffset);
        long endByteOffset = column.getEndStringOffset(rowOffset + numRows - 1L);
        long bytesToCopy = endByteOffset - startByteOffset;
        long srcOffset = startByteOffset;
        return JCudfSerialization.copyAndPad(out, column, ColumnVector.BufferType.DATA, srcOffset, bytesToCopy, arrayBuffer);
    }

    private static long copyStringOffsets(DataOutputStream out, ColumnVector column, long rowOffset, long numRows, byte[] arrayBuffer) throws IOException {
        long bytesToCopy = (numRows + 1L) * 4L;
        long srcOffset = rowOffset * 4L;
        return JCudfSerialization.copyAndPad(out, column, ColumnVector.BufferType.OFFSET, srcOffset, bytesToCopy, arrayBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnVector[] sliceOffColumnVectors(DType[] dataTypes, long[] nullCounts, TimeUnit[] timeUnits, long numRows, DeviceMemoryBuffer combinedBuffer, HostMemoryBuffer combinedBufferOnHost) {
        int numColumns = dataTypes.length;
        long combinedBufferOffset = 0L;
        ColumnVector[] vectors = new ColumnVector[numColumns];
        boolean tableSuccess = false;
        MemoryBuffer validity = null;
        MemoryBuffer data = null;
        MemoryBuffer offsets = null;
        try {
            for (int column = 0; column < numColumns; ++column) {
                DType type = dataTypes[column];
                long nullCount = nullCounts[column];
                TimeUnit tu = timeUnits[column];
                if (nullCount > 0L) {
                    long len = JCudfSerialization.padFor64bitAlignment(BitVectorHelper.getValidityLengthInBytes(numRows));
                    validity = combinedBuffer.slice(combinedBufferOffset, len);
                    combinedBufferOffset += len;
                }
                if (type == DType.STRING || type == DType.STRING_CATEGORY) {
                    long offsetsLen = JCudfSerialization.padFor64bitAlignment((numRows + 1L) * 4L);
                    offsets = combinedBufferOnHost.slice(combinedBufferOffset, offsetsLen);
                    int startStringOffset = ((HostMemoryBuffer)offsets).getInt(0L);
                    int endStringOffset = ((HostMemoryBuffer)offsets).getInt(numRows * 4L);
                    long deviceDataLen = JCudfSerialization.padFor64bitAlignment(endStringOffset - startStringOffset);
                    data = deviceDataLen == 0L ? DeviceMemoryBuffer.allocate(1L) : combinedBuffer.slice(combinedBufferOffset += offsetsLen, deviceDataLen);
                    combinedBufferOffset += deviceDataLen;
                } else {
                    long deviceDataLen = JCudfSerialization.padFor64bitAlignment((long)type.sizeInBytes * numRows);
                    data = combinedBuffer.slice(combinedBufferOffset, deviceDataLen);
                    combinedBufferOffset += deviceDataLen;
                }
                vectors[column] = new ColumnVector(type, tu, numRows, nullCount, (DeviceMemoryBuffer)data, (DeviceMemoryBuffer)validity, (HostMemoryBuffer)offsets, true);
                validity = null;
                data = null;
                offsets = null;
            }
            tableSuccess = true;
            ColumnVector[] columnVectorArray = vectors;
            return columnVectorArray;
        }
        finally {
            if (validity != null) {
                validity.close();
            }
            if (data != null) {
                data.close();
            }
            if (offsets != null) {
                offsets.close();
            }
            if (!tableSuccess) {
                for (ColumnVector cv : vectors) {
                    if (cv == null) continue;
                    cv.close();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Table readTableFrom(InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

