/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.MemoryCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MemoryBuffer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MemoryBuffer.class);
    protected final long address;
    protected final long length;
    protected boolean closed = false;
    protected int refCount = 0;
    protected final MemoryCleaner.Cleaner cleaner;

    public void noWarnLeakExpected() {
        this.cleaner.noWarnLeakExpected();
    }

    protected MemoryBuffer(long address, long length, MemoryCleaner.Cleaner cleaner) {
        this.address = address;
        this.length = length;
        this.cleaner = cleaner;
        ++this.refCount;
        cleaner.addRef();
        MemoryCleaner.register(this, cleaner);
    }

    protected MemoryBuffer(long address, long length, MemoryBuffer parent) {
        this.address = address;
        this.length = length;
        this.cleaner = new SlicedBufferCleaner(parent);
        ++this.refCount;
        this.cleaner.addRef();
        MemoryCleaner.register(this, this.cleaner);
    }

    public final long getLength() {
        return this.length;
    }

    protected final void addressOutOfBoundsCheck(long address, long size, String type) {
        assert (!this.closed) : "Buffer is already closed " + Long.toHexString(this.address);
        assert (address >= this.address) : "Start address is too low for " + type + " 0x" + Long.toHexString(address) + " < 0x" + Long.toHexString(this.address);
        assert (address + size <= this.address + this.length) : "End address is too high for " + type + " 0x" + Long.toHexString(address + size) + " < 0x" + Long.toHexString(this.address + this.length);
    }

    final long getAddress() {
        return this.address;
    }

    @Override
    public final void close() {
        --this.refCount;
        this.cleaner.delRef();
        if (this.refCount == 0) {
            this.cleaner.clean(false);
            this.closed = true;
        } else if (this.refCount < 0) {
            log.error("Close called too many times on {}", (Object)this);
            this.cleaner.logRefCountDebug("double free " + this);
            throw new IllegalStateException("Close called too many times");
        }
    }

    public String toString() {
        return "MemoryBuffer{address=0x" + Long.toHexString(this.address) + ", length=" + this.length + '}';
    }

    private static final class SlicedBufferCleaner
    extends MemoryCleaner.Cleaner {
        private MemoryBuffer parent;

        SlicedBufferCleaner(MemoryBuffer parent) {
            this.parent = parent;
        }

        @Override
        protected boolean cleanImpl(boolean logErrorIfNotClean) {
            boolean neededCleanup = false;
            if (this.parent != null) {
                this.parent.close();
                this.parent = null;
                neededCleanup = true;
            }
            if (neededCleanup && logErrorIfNotClean) {
                log.error("WE LEAKED A SLICED BUFFER!!!!");
                this.logRefCountDebug("Leaked sliced buffer");
            }
            return neededCleanup;
        }
    }
}

