/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.MemoryBuffer;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemoryCleaner {
    private static final boolean REF_COUNT_DEBUG = Boolean.getBoolean("ai.rapids.refcount.debug");
    private static Logger log = LoggerFactory.getLogger(MemoryCleaner.class);
    static final AtomicLong leakCount = new AtomicLong();
    private static final Set<CleanerWeakReference> all = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Thread t = new Thread(() -> {
        try {
            while (true) {
                Thread.sleep(100L);
                MemoryCleaner.doCleanup();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }, "Cleaner Thread");

    MemoryCleaner() {
    }

    private static synchronized void doCleanup() {
        Iterator<CleanerWeakReference> it = all.iterator();
        while (it.hasNext()) {
            CleanerWeakReference ref = it.next();
            if (ref.get() != null) continue;
            ref.clean();
            it.remove();
        }
    }

    public static synchronized void register(ColumnVector vec, Cleaner cleaner) {
        all.add(new CleanerWeakReference<ColumnVector>(vec, cleaner));
    }

    public static synchronized void register(MemoryBuffer buf, Cleaner cleaner) {
        all.add(new CleanerWeakReference<MemoryBuffer>(buf, cleaner));
    }

    static <T> String stringJoin(String delim, Iterable<T> it) {
        return String.join((CharSequence)delim, StreamSupport.stream(it.spliterator(), false).map(i -> i.toString()).collect(Collectors.toList()));
    }

    static {
        t.setDaemon(true);
        t.start();
        if (REF_COUNT_DEBUG) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.gc();
                Class<MemoryCleaner> clazz = MemoryCleaner.class;
                synchronized (MemoryCleaner.class) {
                    MemoryCleaner.doCleanup();
                    for (CleanerWeakReference cwr : all) {
                        cwr.clean();
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            }));
        }
    }

    static final class RefCountDebugItem {
        final StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        final long timeMs = System.currentTimeMillis();
        final String op;

        public RefCountDebugItem(String op) {
            this.op = op;
        }

        public String toString() {
            Date date = new Date(this.timeMs);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS z");
            return dateFormat.format(date) + ": " + this.op + "\n" + MemoryCleaner.stringJoin("\n", Arrays.asList(this.stackTrace)) + "\n";
        }
    }

    private static class CleanerWeakReference<T>
    extends WeakReference<T> {
        private final Cleaner cleaner;

        public CleanerWeakReference(T orig, Cleaner cleaner) {
            super(orig);
            this.cleaner = cleaner;
        }

        public void clean() {
            if (this.cleaner.clean(true)) {
                leakCount.incrementAndGet();
            }
        }
    }

    public static abstract class Cleaner {
        private final List<RefCountDebugItem> refCountDebug = MemoryCleaner.access$000() ? new LinkedList<RefCountDebugItem>() : null;
        private boolean leakExpected = false;

        public final void addRef() {
            if (REF_COUNT_DEBUG) {
                this.refCountDebug.add(new RefCountDebugItem("INC"));
            }
        }

        public final void delRef() {
            if (REF_COUNT_DEBUG) {
                this.refCountDebug.add(new RefCountDebugItem("DEC"));
            }
        }

        public final void logRefCountDebug(String message) {
            if (REF_COUNT_DEBUG) {
                log.error("{}: {}", (Object)message, (Object)MemoryCleaner.stringJoin("\n", this.refCountDebug));
            }
        }

        public final boolean clean(boolean logErrorIfNotClean) {
            return this.cleanImpl(logErrorIfNotClean && !this.leakExpected);
        }

        public final boolean isLeakExpected() {
            return this.leakExpected;
        }

        protected abstract boolean cleanImpl(boolean var1);

        public void noWarnLeakExpected() {
            this.leakExpected = true;
        }
    }
}

