/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeDepsLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeDepsLoader.class);
    private static final String[] loadOrder = new String[]{"boost_filesystem", "rmm", "NVStrings", "NVCategory", "cudf", "cudfjni"};
    private static ClassLoader loader = NativeDepsLoader.class.getClassLoader();
    private static boolean loaded = false;

    static synchronized void loadNativeDeps() {
        if (!loaded) {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            try {
                for (String toLoad : loadOrder) {
                    NativeDepsLoader.loadDep(os, arch, toLoad);
                }
                loaded = true;
            }
            catch (Throwable t) {
                log.error("Could not load cudf jni library...", t);
            }
        }
    }

    private static void loadDep(String os, String arch, String baseName) throws IOException {
        File loc;
        String path = arch + "/" + os + "/" + System.mapLibraryName(baseName);
        URL resource = loader.getResource(path);
        if (resource == null) {
            File f = new File("./target/native-deps/" + path);
            if (!f.exists()) {
                throw new FileNotFoundException("Could not locate native dependency " + path);
            }
            resource = f.toURL();
        }
        try (InputStream in = resource.openStream();){
            loc = File.createTempFile(baseName, ".so");
            try (FileOutputStream out = new FileOutputStream(loc);){
                byte[] buffer = new byte[16384];
                int read = 0;
                while ((read = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
        }
        loc.deleteOnExit();
        System.load(loc.getAbsolutePath());
        loc.delete();
    }

    public static boolean libraryLoaded() {
        if (!loaded) {
            NativeDepsLoader.loadNativeDeps();
        }
        return loaded;
    }
}

