/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.BinaryOp;
import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.Cudf;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.TimeUnit;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public final class Scalar
implements BinaryOperable {
    public static final Scalar NULL = new Scalar(DType.INT8, TimeUnit.NONE);
    private static final EnumSet<DType> INTEGRAL_TYPES = EnumSet.of(DType.BOOL8, new DType[]{DType.INT8, DType.INT16, DType.INT32, DType.INT64, DType.DATE32, DType.DATE64, DType.TIMESTAMP});
    final long intTypeStorage;
    final float floatTypeStorage;
    final double doubleTypeStorage;
    final byte[] stringTypeStorage;
    final DType type;
    final boolean isValid;
    final TimeUnit timeUnit;

    private Scalar(long value, DType type, TimeUnit unit) {
        this.intTypeStorage = value;
        this.floatTypeStorage = 0.0f;
        this.doubleTypeStorage = 0.0;
        this.stringTypeStorage = null;
        this.type = type;
        this.isValid = true;
        this.timeUnit = unit;
    }

    private Scalar(float value, DType type, TimeUnit unit) {
        this.intTypeStorage = 0L;
        this.floatTypeStorage = value;
        this.doubleTypeStorage = 0.0;
        this.stringTypeStorage = null;
        this.type = type;
        this.isValid = true;
        this.timeUnit = unit;
    }

    private Scalar(double value, DType type, TimeUnit unit) {
        this.intTypeStorage = 0L;
        this.floatTypeStorage = 0.0f;
        this.doubleTypeStorage = value;
        this.stringTypeStorage = null;
        this.type = type;
        this.isValid = true;
        this.timeUnit = unit;
    }

    private Scalar(byte[] value, DType type, TimeUnit unit) {
        this.intTypeStorage = 0L;
        this.floatTypeStorage = 0.0f;
        this.doubleTypeStorage = 0.0;
        this.stringTypeStorage = value;
        this.type = type;
        this.isValid = value != null;
        this.timeUnit = unit;
    }

    private Scalar(DType type, TimeUnit unit) {
        this.intTypeStorage = 0L;
        this.floatTypeStorage = 0.0f;
        this.doubleTypeStorage = 0.0;
        this.stringTypeStorage = null;
        this.type = type;
        this.isValid = false;
        this.timeUnit = unit;
    }

    static Scalar fromNull(int dtype) {
        return new Scalar(DType.fromNative(dtype), TimeUnit.NONE);
    }

    static Scalar timestampFromNull(int nativeTimeUnit) {
        return Scalar.timestampFromNull(TimeUnit.fromNative(nativeTimeUnit));
    }

    static Scalar timestampFromLong(long value, int nativeTimeUnit) {
        return Scalar.timestampFromLong(value, TimeUnit.fromNative(nativeTimeUnit));
    }

    public static Scalar fromNull(DType dtype) {
        return new Scalar(dtype, TimeUnit.NONE);
    }

    public static Scalar timestampFromNull(TimeUnit timeUnit) {
        return new Scalar(DType.TIMESTAMP, timeUnit);
    }

    public static Scalar fromBool(boolean value) {
        return new Scalar(value ? 1L : 0L, DType.BOOL8, TimeUnit.NONE);
    }

    public static Scalar fromByte(byte value) {
        return new Scalar(value, DType.INT8, TimeUnit.NONE);
    }

    public static Scalar fromShort(short value) {
        return new Scalar(value, DType.INT16, TimeUnit.NONE);
    }

    public static Scalar fromInt(int value) {
        return new Scalar(value, DType.INT32, TimeUnit.NONE);
    }

    public static Scalar dateFromInt(int value) {
        return new Scalar(value, DType.DATE32, TimeUnit.NONE);
    }

    public static Scalar fromLong(long value) {
        return new Scalar(value, DType.INT64, TimeUnit.NONE);
    }

    public static Scalar dateFromLong(long value) {
        return new Scalar(value, DType.DATE64, TimeUnit.NONE);
    }

    public static Scalar timestampFromLong(long value) {
        return new Scalar(value, DType.TIMESTAMP, TimeUnit.MILLISECONDS);
    }

    public static Scalar timestampFromLong(long value, TimeUnit unit) {
        if (unit == TimeUnit.NONE) {
            unit = TimeUnit.MILLISECONDS;
        }
        return new Scalar(value, DType.TIMESTAMP, unit);
    }

    public static Scalar fromFloat(float value) {
        return new Scalar(value, DType.FLOAT32, TimeUnit.NONE);
    }

    public static Scalar fromDouble(double value) {
        return new Scalar(value, DType.FLOAT64, TimeUnit.NONE);
    }

    public static Scalar fromString(String value) {
        return new Scalar(value.getBytes(StandardCharsets.UTF_8), DType.STRING, TimeUnit.NONE);
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public DType getType() {
        return this.type;
    }

    public boolean getBoolean() {
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return this.intTypeStorage != 0L;
        }
        if (this.type == DType.FLOAT32) {
            return this.floatTypeStorage != 0.0f;
        }
        if (this.type == DType.FLOAT64) {
            return this.doubleTypeStorage != 0.0;
        }
        if (this.type == DType.STRING) {
            return Boolean.parseBoolean(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public byte getByte() {
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return (byte)this.intTypeStorage;
        }
        if (this.type == DType.FLOAT32) {
            return (byte)this.floatTypeStorage;
        }
        if (this.type == DType.FLOAT64) {
            return (byte)this.doubleTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Byte.parseByte(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public short getShort() {
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return (short)this.intTypeStorage;
        }
        if (this.type == DType.FLOAT32) {
            return (short)this.floatTypeStorage;
        }
        if (this.type == DType.FLOAT64) {
            return (short)this.doubleTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Short.parseShort(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public int getInt() {
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return (int)this.intTypeStorage;
        }
        if (this.type == DType.FLOAT32) {
            return (int)this.floatTypeStorage;
        }
        if (this.type == DType.FLOAT64) {
            return (int)this.doubleTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Integer.parseInt(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public long getLong() {
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return this.intTypeStorage;
        }
        if (this.type == DType.FLOAT32) {
            return (long)this.floatTypeStorage;
        }
        if (this.type == DType.FLOAT64) {
            return (long)this.doubleTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Long.parseLong(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public float getFloat() {
        if (this.type == DType.FLOAT32) {
            return this.floatTypeStorage;
        }
        if (this.type == DType.FLOAT64) {
            return (float)this.doubleTypeStorage;
        }
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return this.intTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Float.parseFloat(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public double getDouble() {
        if (this.type == DType.FLOAT64) {
            return this.doubleTypeStorage;
        }
        if (this.type == DType.FLOAT32) {
            return this.floatTypeStorage;
        }
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return this.intTypeStorage;
        }
        if (this.type == DType.STRING) {
            return Double.parseDouble(this.getJavaString());
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getJavaString() {
        if (this.type == DType.STRING) {
            return new String(this.stringTypeStorage, StandardCharsets.UTF_8);
        }
        if (INTEGRAL_TYPES.contains((Object)this.type)) {
            return Long.toString(this.intTypeStorage);
        }
        if (this.type == DType.FLOAT32) {
            return Float.toString(this.floatTypeStorage);
        }
        if (this.type == DType.FLOAT64) {
            return Double.toString(this.doubleTypeStorage);
        }
        throw new IllegalStateException("Unexpected scalar type: " + (Object)((Object)this.type));
    }

    public byte[] getUTF8() {
        if (this.type == DType.STRING) {
            return this.stringTypeStorage;
        }
        return this.getJavaString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public ColumnVector binaryOp(BinaryOp op, BinaryOperable rhs, DType outType) {
        if (rhs instanceof ColumnVector) {
            ColumnVector cvRhs = (ColumnVector)rhs;
            return new ColumnVector(Cudf.gdfBinaryOp(this, cvRhs, op, outType));
        }
        throw new IllegalArgumentException(rhs.getClass() + " is not supported as a binary op with Scalar");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scalar scalar = (Scalar)o;
        return this.intTypeStorage == scalar.intTypeStorage && Float.compare(scalar.floatTypeStorage, this.floatTypeStorage) == 0 && Double.compare(scalar.doubleTypeStorage, this.doubleTypeStorage) == 0 && this.isValid == scalar.isValid && this.type == scalar.type && this.timeUnit == scalar.timeUnit && Arrays.equals(this.stringTypeStorage, scalar.stringTypeStorage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.intTypeStorage, Float.valueOf(this.floatTypeStorage), this.doubleTypeStorage, this.stringTypeStorage, this.type, this.isValid, this.timeUnit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Scalar{type=");
        sb.append((Object)this.type);
        sb.append(" value=");
        switch (this.type) {
            case BOOL8: {
                sb.append(this.getBoolean());
                break;
            }
            case INT8: {
                sb.append(this.getByte());
                break;
            }
            case INT16: {
                sb.append(this.getShort());
                break;
            }
            case INT32: 
            case DATE32: {
                sb.append(this.getInt());
                break;
            }
            case INT64: 
            case DATE64: {
                sb.append(this.getLong());
                break;
            }
            case FLOAT32: {
                sb.append(this.getFloat());
                break;
            }
            case FLOAT64: {
                sb.append(this.getDouble());
                break;
            }
            case TIMESTAMP: {
                sb.append(this.getLong());
                sb.append(" unit=");
                sb.append((Object)this.getTimeUnit());
                break;
            }
            case STRING: {
                sb.append('\"');
                sb.append(this.getJavaString());
                sb.append('\"');
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown scalar type: " + (Object)((Object)this.type));
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

