/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.DType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Schema {
    public static final Schema INFERRED = new Schema();
    private final List<String> names;
    private final List<String> types;

    private Schema(List<String> names, List<String> types) {
        this.names = new ArrayList<String>(names);
        this.types = new ArrayList<String>(types);
    }

    private Schema() {
        this.names = null;
        this.types = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String[] getColumnNames() {
        if (this.names == null) {
            return null;
        }
        return this.names.toArray(new String[this.names.size()]);
    }

    String[] getTypesAsStrings() {
        if (this.types == null) {
            return null;
        }
        return this.types.toArray(new String[this.types.size()]);
    }

    public static class Builder {
        private List<String> names = new LinkedList<String>();
        private List<String> types = new LinkedList<String>();

        public Builder column(DType type, String name) {
            this.types.add(type.simpleName);
            this.names.add(name);
            return this;
        }

        public Schema build() {
            return new Schema(this.names, this.types);
        }
    }
}

