/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.Aggregate;
import ai.rapids.cudf.CSVOptions;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.CudfException;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.GroupByOptions;
import ai.rapids.cudf.HashFunction;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.ORCOptions;
import ai.rapids.cudf.ParquetOptions;
import ai.rapids.cudf.PartitionedTable;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.TimeUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class Table
implements AutoCloseable {
    private final long rows;
    private long nativeHandle;
    private ColumnVector[] columns;

    public Table(ColumnVector ... columns) {
        assert (columns != null) : "ColumnVectors can't be null";
        this.rows = columns[0].getRowCount();
        for (ColumnVector columnVector : columns) {
            assert (null != columnVector) : "ColumnVectors can't be null";
            assert (this.rows == columnVector.getRowCount()) : "All columns should have the same number of rows " + (Object)((Object)columnVector.getType());
        }
        this.columns = new ColumnVector[columns.length];
        long[] cudfColumnPointers = new long[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns[i] = columns[i];
            columns[i].incRefCount();
            cudfColumnPointers[i] = columns[i].getNativeCudfColumnAddress();
        }
        this.nativeHandle = Table.createCudfTable(cudfColumnPointers);
    }

    private Table(long[] cudfColumns) {
        assert (cudfColumns != null) : "CudfColumns can't be null";
        this.columns = new ColumnVector[cudfColumns.length];
        try {
            for (int i = 0; i < cudfColumns.length; ++i) {
                this.columns[i] = new ColumnVector(cudfColumns[i]);
            }
            this.nativeHandle = Table.createCudfTable(cudfColumns);
            this.rows = this.columns[0].getRowCount();
        }
        catch (Throwable t) {
            for (int i = 0; i < cudfColumns.length; ++i) {
                if (this.columns[i] != null) {
                    this.columns[i].close();
                    continue;
                }
                ColumnVector.freeCudfColumn(cudfColumns[i], true);
            }
            throw t;
        }
    }

    ColumnVector[] getColumns() {
        return this.columns;
    }

    public ColumnVector getColumn(int index) {
        assert (index < this.columns.length);
        return this.columns[index];
    }

    public final long getRowCount() {
        return this.rows;
    }

    public final int getNumberOfColumns() {
        return this.columns.length;
    }

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            Table.freeCudfTable(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].close();
                this.columns[i] = null;
            }
            this.columns = null;
        }
    }

    public String toString() {
        return "Table{columns=" + Arrays.toString(this.columns) + ", cudfTable=" + this.nativeHandle + ", rows=" + this.rows + '}';
    }

    private static native long[] gdfPartition(long var0, int[] var2, int var3, int var4, int[] var5) throws CudfException;

    private static native long createCudfTable(long[] var0) throws CudfException;

    private static native void freeCudfTable(long var0) throws CudfException;

    private static native long[] gdfReadCSV(String[] var0, String[] var1, String[] var2, String var3, long var4, long var6, int var8, byte var9, byte var10, byte var11, String[] var12, String[] var13, String[] var14) throws CudfException;

    private static native long[] gdfReadParquet(String[] var0, String var1, long var2, long var4) throws CudfException;

    private static native long[] gdfReadORC(String[] var0, String var1, long var2, long var4, boolean var6) throws CudfException;

    private static native long[] gdfGroupByAggregate(long var0, int[] var2, int[] var3, int[] var4, boolean var5) throws CudfException;

    private static native long[] gdfOrderBy(long var0, long[] var2, boolean[] var3, boolean var4) throws CudfException;

    private static native long[] gdfLeftJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] gdfInnerJoin(long var0, int[] var2, long var3, int[] var5) throws CudfException;

    private static native long[] concatenate(long[] var0) throws CudfException;

    private static native long[] gdfFilter(long var0, long var2);

    public static Table readCSV(Schema schema, File path) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, path);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, File path) {
        return new Table(Table.gdfReadCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readCSV(Schema schema, byte[] buffer) {
        return Table.readCSV(schema, CSVOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer) {
        return Table.readCSV(schema, opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readCSV(Schema schema, CSVOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readCSV(schema, opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readCSV(Schema schema, CSVOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.gdfReadCSV(schema.getColumnNames(), schema.getTypesAsStrings(), opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.getHeaderRow(), opts.getDelim(), opts.getQuote(), opts.getComment(), opts.getNullValues(), opts.getTrueValues(), opts.getFalseValues()));
    }

    public static Table readParquet(File path) {
        return Table.readParquet(ParquetOptions.DEFAULT, path);
    }

    public static Table readParquet(ParquetOptions opts, File path) {
        return new Table(Table.gdfReadParquet(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L));
    }

    public static Table readParquet(byte[] buffer) {
        return Table.readParquet(ParquetOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer) {
        return Table.readParquet(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readParquet(ParquetOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readParquet(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readParquet(ParquetOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.gdfReadParquet(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len));
    }

    public static Table readORC(File path) {
        return Table.readORC(ORCOptions.DEFAULT, path);
    }

    public static Table readORC(ORCOptions opts, File path) {
        return new Table(Table.gdfReadORC(opts.getIncludeColumnNames(), path.getAbsolutePath(), 0L, 0L, opts.usingNumPyTypes()));
    }

    public static Table readORC(byte[] buffer) {
        return Table.readORC(ORCOptions.DEFAULT, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer) {
        return Table.readORC(opts, buffer, 0L, (long)buffer.length);
    }

    public static Table readORC(ORCOptions opts, byte[] buffer, long offset, long len) {
        if (len <= 0L) {
            len = (long)buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= (long)buffer.length - offset);
        assert (offset >= 0L && offset < (long)buffer.length);
        try (HostMemoryBuffer newBuf = HostMemoryBuffer.allocate(len);){
            newBuf.setBytes(0L, buffer, offset, len);
            Table table = Table.readORC(opts, newBuf, 0L, len);
            return table;
        }
    }

    public static Table readORC(ORCOptions opts, HostMemoryBuffer buffer, long offset, long len) {
        if (len <= 0L) {
            len = buffer.length - offset;
        }
        assert (len > 0L);
        assert (len <= buffer.getLength() - offset);
        assert (offset >= 0L && offset < buffer.length);
        return new Table(Table.gdfReadORC(opts.getIncludeColumnNames(), null, buffer.getAddress() + offset, len, opts.usingNumPyTypes()));
    }

    public static Table concatenate(Table ... tables) {
        if (tables.length < 2) {
            throw new IllegalArgumentException("concatenate requires 2 or more tables");
        }
        int numColumns = tables[0].getNumberOfColumns();
        long[] tableHandles = new long[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            tableHandles[i] = tables[i].nativeHandle;
            assert (tables[i].getNumberOfColumns() == numColumns) : "all tables must have the same schema";
        }
        return new Table(Table.concatenate(tableHandles));
    }

    public Table orderBy(boolean areNullsSmallest, OrderByArg ... args) {
        assert (args.length <= this.columns.length);
        long[] sortKeys = new long[args.length];
        boolean[] isDescending = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = args[i].index;
            assert (index >= 0 && index < this.columns.length) : "index is out of range 0 <= " + index + " < " + this.columns.length;
            isDescending[i] = args[i].isDescending;
            sortKeys[i] = this.columns[index].getNativeCudfColumnAddress();
        }
        return new Table(Table.gdfOrderBy(this.nativeHandle, sortKeys, isDescending, areNullsSmallest));
    }

    public static OrderByArg asc(int index) {
        return new OrderByArg(index, false);
    }

    public static OrderByArg desc(int index) {
        return new OrderByArg(index, true);
    }

    public static Aggregate count(int index) {
        return Aggregate.count(index);
    }

    public static Aggregate max(int index) {
        return Aggregate.max(index);
    }

    public static Aggregate min(int index) {
        return Aggregate.min(index);
    }

    public static Aggregate sum(int index) {
        return Aggregate.sum(index);
    }

    public static Aggregate mean(int index) {
        return Aggregate.mean(index);
    }

    public AggregateOperation groupBy(GroupByOptions groupByOptions, int ... indices) {
        return this.groupByInternal(groupByOptions, indices);
    }

    public AggregateOperation groupBy(int ... indices) {
        return this.groupByInternal(GroupByOptions.builder().withIgnoreNullKeys(false).build(), indices);
    }

    private AggregateOperation groupByInternal(GroupByOptions groupByOptions, int[] indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new AggregateOperation(this, groupByOptions, operationIndicesArray);
    }

    public TableOperation onColumns(int ... indices) {
        int[] operationIndicesArray = this.copyAndValidate(indices);
        return new TableOperation(this, operationIndicesArray);
    }

    private int[] copyAndValidate(int[] indices) {
        int[] operationIndicesArray = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            operationIndicesArray[i] = indices[i];
            assert (operationIndicesArray[i] >= 0 && operationIndicesArray[i] < this.columns.length) : "operation index is out of range 0 <= " + operationIndicesArray[i] + " < " + this.columns.length;
        }
        return operationIndicesArray;
    }

    public Table filter(ColumnVector mask) {
        assert (mask.getType() == DType.BOOL8) : "Mask column must be of type BOOL8";
        assert (this.getRowCount() == 0L || this.getRowCount() == mask.getRowCount()) : "Mask column has incorrect size";
        for (ColumnVector col : this.getColumns()) {
            assert (col.getType() != DType.STRING) : "STRING type must be converted to a STRING_CATEGORY for filter";
        }
        return new Table(Table.gdfFilter(this.nativeHandle, mask.getNativeCudfColumnAddress()));
    }

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static final class TestBuilder {
        private final List<DType> types = new ArrayList<DType>();
        private final List<TimeUnit> units = new ArrayList<TimeUnit>();
        private final List<Object> typeErasedData = new ArrayList<Object>();

        public TestBuilder column(String ... values) {
            this.types.add(DType.STRING);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Boolean ... values) {
            this.types.add(DType.BOOL8);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Byte ... values) {
            this.types.add(DType.INT8);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Short ... values) {
            this.types.add(DType.INT16);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Integer ... values) {
            this.types.add(DType.INT32);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Long ... values) {
            this.types.add(DType.INT64);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Float ... values) {
            this.types.add(DType.FLOAT32);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder column(Double ... values) {
            this.types.add(DType.FLOAT64);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder date32Column(Integer ... values) {
            this.types.add(DType.DATE32);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder date64Column(Long ... values) {
            this.types.add(DType.DATE64);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampColumn(Long ... values) {
            this.types.add(DType.TIMESTAMP);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder categoryColumn(String ... values) {
            this.types.add(DType.STRING_CATEGORY);
            this.units.add(TimeUnit.NONE);
            this.typeErasedData.add(values);
            return this;
        }

        public TestBuilder timestampColumn(TimeUnit unit, Long ... values) {
            this.types.add(DType.TIMESTAMP);
            this.units.add(unit);
            this.typeErasedData.add(values);
            return this;
        }

        private static ColumnVector from(DType type, TimeUnit unit, Object dataArray) {
            ColumnVector ret;
            switch (type) {
                case STRING: {
                    ret = ColumnVector.fromStrings((String[])dataArray);
                    break;
                }
                case STRING_CATEGORY: {
                    ret = ColumnVector.categoryFromStrings((String[])dataArray);
                    break;
                }
                case BOOL8: {
                    ret = ColumnVector.fromBoxedBooleans((Boolean[])dataArray);
                    break;
                }
                case INT8: {
                    ret = ColumnVector.fromBoxedBytes((Byte[])dataArray);
                    break;
                }
                case INT16: {
                    ret = ColumnVector.fromBoxedShorts((Short[])dataArray);
                    break;
                }
                case INT32: {
                    ret = ColumnVector.fromBoxedInts((Integer[])dataArray);
                    break;
                }
                case INT64: {
                    ret = ColumnVector.fromBoxedLongs((Long[])dataArray);
                    break;
                }
                case DATE32: {
                    ret = ColumnVector.datesFromBoxedInts((Integer[])dataArray);
                    break;
                }
                case DATE64: {
                    ret = ColumnVector.datesFromBoxedLongs((Long[])dataArray);
                    break;
                }
                case TIMESTAMP: {
                    ret = ColumnVector.timestampsFromBoxedLongs(unit, (Long[])dataArray);
                    break;
                }
                case FLOAT32: {
                    ret = ColumnVector.fromBoxedFloats((Float[])dataArray);
                    break;
                }
                case FLOAT64: {
                    ret = ColumnVector.fromBoxedDoubles((Double[])dataArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)type) + " is not supported yet");
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Table build() {
            ArrayList<ColumnVector> columns = new ArrayList<ColumnVector>(this.types.size());
            try {
                for (int i = 0; i < this.types.size(); ++i) {
                    columns.add(TestBuilder.from(this.types.get(i), this.units.get(i), this.typeErasedData.get(i)));
                }
                for (ColumnVector cv : columns) {
                    cv.ensureOnDevice();
                }
                Table table = new Table(columns.toArray(new ColumnVector[columns.size()]));
                return table;
            }
            finally {
                for (ColumnVector cv : columns) {
                    cv.close();
                }
            }
        }
    }

    public static final class TableOperation {
        private final Operation operation;

        TableOperation(Table table, int ... indices) {
            this.operation = new Operation(table, indices);
        }

        public Table leftJoin(TableOperation rightJoinIndices) {
            return new Table(Table.gdfLeftJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public Table innerJoin(TableOperation rightJoinIndices) {
            return new Table(Table.gdfInnerJoin(this.operation.table.nativeHandle, this.operation.indices, rightJoinIndices.operation.table.nativeHandle, rightJoinIndices.operation.indices));
        }

        public PartitionedTable partition(int numberOfPartitions, HashFunction hashFunction) {
            int[] partitionOffsets = new int[numberOfPartitions];
            return new PartitionedTable(new Table(Table.gdfPartition(this.operation.table.nativeHandle, this.operation.indices, hashFunction.nativeId, partitionOffsets.length, partitionOffsets)), partitionOffsets);
        }
    }

    public static final class AggregateOperation {
        private final Operation operation;
        private final GroupByOptions groupByOptions;

        AggregateOperation(Table table, GroupByOptions groupByOptions, int ... indices) {
            this.operation = new Operation(table, indices);
            this.groupByOptions = groupByOptions;
        }

        public Table aggregate(Aggregate ... aggregates) {
            assert (aggregates != null && aggregates.length > 0);
            ArrayList<Integer> aggregateColumnIndices = new ArrayList<Integer>();
            ArrayList<Integer> ops = new ArrayList<Integer>();
            ArrayList<ColumnOp> finalAggColumns = new ArrayList<ColumnOp>();
            HashMap<ColumnOp, Integer> aggToCudfColumn = new HashMap<ColumnOp, Integer>();
            int uniqueAggIndex = this.operation.indices.length;
            for (int aggregateIndex = 0; aggregateIndex < aggregates.length; ++aggregateIndex) {
                Aggregate agg = aggregates[aggregateIndex];
                int origColumnIndex = agg.getIndex();
                int origOpNativeId = agg.getNativeId();
                ColumnOp cop = new ColumnOp(this.operation.table.getColumn(origColumnIndex).getNativeCudfColumnAddress(), origOpNativeId);
                if (!aggToCudfColumn.containsKey(cop)) {
                    aggregateColumnIndices.add(agg.getIndex());
                    ops.add(agg.getNativeId());
                    aggToCudfColumn.put(cop, uniqueAggIndex++);
                }
                finalAggColumns.add(cop);
            }
            Table aggregate = new Table(Table.gdfGroupByAggregate(this.operation.table.nativeHandle, this.operation.indices, aggregateColumnIndices.stream().mapToInt(i -> i).toArray(), ops.stream().mapToInt(i -> i).toArray(), this.groupByOptions.getIgnoreNullKeys()));
            ColumnVector[] finalCols = new ColumnVector[this.operation.indices.length + aggregates.length];
            int aggIndex = 0;
            for (int groupIndex : this.operation.indices) {
                finalCols[groupIndex] = aggregate.getColumn(groupIndex);
                ++aggIndex;
            }
            Object origOpNativeId = finalAggColumns.iterator();
            while (origOpNativeId.hasNext()) {
                ColumnOp cop = (ColumnOp)origOpNativeId.next();
                int originalIndex = (Integer)aggToCudfColumn.get(cop);
                finalCols[aggIndex] = aggregate.getColumn(originalIndex);
                ++aggIndex;
            }
            Table tbl = new Table(finalCols);
            aggregate.close();
            return tbl;
        }
    }

    private static final class ColumnOp {
        private final long colNativeId;
        private final int opNativeId;

        ColumnOp(long column, int opNativeId) {
            this.colNativeId = column;
            this.opNativeId = opNativeId;
        }

        public boolean equals(Object other) {
            if (other instanceof ColumnOp) {
                ColumnOp otherCop = (ColumnOp)other;
                return otherCop.colNativeId == this.colNativeId && otherCop.opNativeId == this.opNativeId;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.colNativeId, this.opNativeId);
        }
    }

    private static final class Operation {
        final int[] indices;
        final Table table;

        Operation(Table table, int ... indices) {
            this.indices = indices;
            this.table = table;
        }
    }

    public static final class OrderByArg {
        final int index;
        final boolean isDescending;

        OrderByArg(int index, boolean isDescending) {
            this.index = index;
            this.isDescending = isDescending;
        }
    }
}

