/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

public enum UnaryOp {
    SIN(0),
    COS(1),
    TAN(2),
    ARCSIN(3),
    ARCCOS(4),
    ARCTAN(5),
    EXP(6),
    LOG(7),
    SQRT(8),
    CEIL(9),
    FLOOR(10),
    ABS(11),
    BIT_INVERT(12),
    NOT(13);

    private static final UnaryOp[] OPS;
    final int nativeId;

    private UnaryOp(int nativeId) {
        this.nativeId = nativeId;
    }

    static UnaryOp fromNative(int nativeId) {
        for (UnaryOp type : OPS) {
            if (type.nativeId != nativeId) continue;
            return type;
        }
        throw new IllegalArgumentException("Could not translate " + nativeId + " into a UnaryOp");
    }

    static {
        OPS = UnaryOp.values();
    }
}

