/*
 * Decompiled with CFR 0.152.
 */
package ai.rapids.cudf;

import ai.rapids.cudf.AggregationOnColumn;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.NaNEquality;
import ai.rapids.cudf.NativeDepsLoader;
import ai.rapids.cudf.NullEquality;
import ai.rapids.cudf.NullPolicy;
import ai.rapids.cudf.QuantileMethod;
import ai.rapids.cudf.RollingAggregation;
import java.util.Arrays;

public abstract class Aggregation {
    protected final Kind kind;

    protected Aggregation(Kind kind) {
        this.kind = kind;
    }

    public <T extends Aggregation> AggregationOnColumn<T> onColumn(int columnIndex) {
        return new AggregationOnColumn<Aggregation>(this, columnIndex);
    }

    long getDefaultOutput() {
        return 0L;
    }

    abstract long createNativeInstance();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static void close(long[] ptrs) {
        for (long ptr : ptrs) {
            if (ptr == 0L) continue;
            Aggregation.close(ptr);
        }
    }

    static native void close(long var0);

    public static SumAggregation sum() {
        return new SumAggregation();
    }

    public static ProductAggregation product() {
        return new ProductAggregation();
    }

    public static MinAggregation min() {
        return new MinAggregation();
    }

    public static MaxAggregation max() {
        return new MaxAggregation();
    }

    public static CountAggregation count() {
        return Aggregation.count(NullPolicy.EXCLUDE);
    }

    public static CountAggregation count(NullPolicy nullPolicy) {
        return new CountAggregation(nullPolicy);
    }

    public static AnyAggregation any() {
        return new AnyAggregation();
    }

    public static AllAggregation all() {
        return new AllAggregation();
    }

    public static SumOfSquaresAggregation sumOfSquares() {
        return new SumOfSquaresAggregation();
    }

    public static MeanAggregation mean() {
        return new MeanAggregation();
    }

    public static VarianceAggregation variance() {
        return Aggregation.variance(1);
    }

    public static VarianceAggregation variance(int ddof) {
        return new VarianceAggregation(ddof);
    }

    public static StandardDeviationAggregation standardDeviation() {
        return Aggregation.standardDeviation(1);
    }

    public static StandardDeviationAggregation standardDeviation(int ddof) {
        return new StandardDeviationAggregation(ddof);
    }

    public static MedianAggregation median() {
        return new MedianAggregation();
    }

    public static QuantileAggregation quantile(double ... quantiles) {
        return Aggregation.quantile(QuantileMethod.LINEAR, quantiles);
    }

    public static QuantileAggregation quantile(QuantileMethod method, double ... quantiles) {
        return new QuantileAggregation(method, quantiles);
    }

    public static ArgMaxAggregation argMax() {
        return new ArgMaxAggregation();
    }

    public static ArgMinAggregation argMin() {
        return new ArgMinAggregation();
    }

    public static NuniqueAggregation nunique() {
        return Aggregation.nunique(NullPolicy.EXCLUDE);
    }

    public static NuniqueAggregation nunique(NullPolicy nullPolicy) {
        return new NuniqueAggregation(nullPolicy);
    }

    public static NthAggregation nth(int offset) {
        return Aggregation.nth(offset, NullPolicy.INCLUDE);
    }

    public static NthAggregation nth(int offset, NullPolicy nullPolicy) {
        return new NthAggregation(offset, nullPolicy);
    }

    public static RowNumberAggregation rowNumber() {
        return new RowNumberAggregation();
    }

    public static CollectListAggregation collectList() {
        return Aggregation.collectList(NullPolicy.EXCLUDE);
    }

    public static CollectListAggregation collectList(NullPolicy nullPolicy) {
        return new CollectListAggregation(nullPolicy);
    }

    public static CollectSetAggregation collectSet() {
        return new CollectSetAggregation(NullPolicy.EXCLUDE, NullEquality.UNEQUAL, NaNEquality.UNEQUAL);
    }

    public static CollectSetAggregation collectSet(NullPolicy nullPolicy, NullEquality nullEquality, NaNEquality nanEquality) {
        return new CollectSetAggregation(nullPolicy, nullEquality, nanEquality);
    }

    public static LeadAggregation lead(int offset) {
        return Aggregation.lead(offset, null);
    }

    public static LeadAggregation lead(int offset, ColumnVector defaultOutput) {
        return new LeadAggregation(offset, defaultOutput);
    }

    public static LagAggregation lag(int offset) {
        return Aggregation.lag(offset, null);
    }

    public static LagAggregation lag(int offset, ColumnVector defaultOutput) {
        return new LagAggregation(offset, defaultOutput);
    }

    private static native long createNoParamAgg(int var0);

    private static native long createNthAgg(int var0, boolean var1);

    private static native long createDdofAgg(int var0, int var1);

    private static native long createCountLikeAgg(int var0, boolean var1);

    private static native long createQuantAgg(int var0, double[] var1);

    private static native long createLeadLagAgg(int var0, int var1);

    private static native long createCollectListAgg(boolean var0);

    private static native long createCollectSetAgg(boolean var0, boolean var1, boolean var2);

    static {
        NativeDepsLoader.loadNativeDeps();
    }

    public static class LagAggregation
    extends LeadLagAggregation
    implements RollingAggregation<LagAggregation> {
        private LagAggregation(int offset, ColumnVector defaultOutput) {
            super(Kind.LAG, offset, defaultOutput);
        }
    }

    public static class LeadAggregation
    extends LeadLagAggregation
    implements RollingAggregation<LeadAggregation> {
        private LeadAggregation(int offset, ColumnVector defaultOutput) {
            super(Kind.LEAD, offset, defaultOutput);
        }
    }

    public static class RowNumberAggregation
    extends NoParamAggregation
    implements RollingAggregation<RowNumberAggregation> {
        private RowNumberAggregation() {
            super(Kind.ROW_NUMBER);
        }
    }

    public static class NuniqueAggregation
    extends CountLikeAggregation {
        private NuniqueAggregation(NullPolicy nullPolicy) {
            super(Kind.NUNIQUE, nullPolicy);
        }
    }

    public static class ArgMinAggregation
    extends NoParamAggregation
    implements RollingAggregation<ArgMinAggregation> {
        private ArgMinAggregation() {
            super(Kind.ARGMIN);
        }
    }

    public static class ArgMaxAggregation
    extends NoParamAggregation
    implements RollingAggregation<ArgMaxAggregation> {
        private ArgMaxAggregation() {
            super(Kind.ARGMAX);
        }
    }

    public static class MedianAggregation
    extends NoParamAggregation {
        private MedianAggregation() {
            super(Kind.MEDIAN);
        }
    }

    public static class StandardDeviationAggregation
    extends DdofAggregation {
        private StandardDeviationAggregation(int ddof) {
            super(Kind.STD, ddof);
        }
    }

    public static class VarianceAggregation
    extends DdofAggregation {
        private VarianceAggregation(int ddof) {
            super(Kind.VARIANCE, ddof);
        }
    }

    public static class MeanAggregation
    extends NoParamAggregation
    implements RollingAggregation<MeanAggregation> {
        private MeanAggregation() {
            super(Kind.MEAN);
        }
    }

    public static class SumOfSquaresAggregation
    extends NoParamAggregation {
        private SumOfSquaresAggregation() {
            super(Kind.SUM_OF_SQUARES);
        }
    }

    public static class AllAggregation
    extends NoParamAggregation {
        private AllAggregation() {
            super(Kind.ALL);
        }
    }

    public static class AnyAggregation
    extends NoParamAggregation {
        private AnyAggregation() {
            super(Kind.ANY);
        }
    }

    public static class CountAggregation
    extends CountLikeAggregation
    implements RollingAggregation<CountAggregation> {
        private CountAggregation(NullPolicy nullPolicy) {
            super(Kind.COUNT, nullPolicy);
        }
    }

    public static class MaxAggregation
    extends NoParamAggregation
    implements RollingAggregation<MaxAggregation> {
        private MaxAggregation() {
            super(Kind.MAX);
        }
    }

    public static class MinAggregation
    extends NoParamAggregation
    implements RollingAggregation<MinAggregation> {
        private MinAggregation() {
            super(Kind.MIN);
        }
    }

    public static class ProductAggregation
    extends NoParamAggregation {
        private ProductAggregation() {
            super(Kind.PRODUCT);
        }
    }

    public static class SumAggregation
    extends NoParamAggregation
    implements RollingAggregation<SumAggregation> {
        private SumAggregation() {
            super(Kind.SUM);
        }
    }

    private static final class CollectSetAggregation
    extends Aggregation {
        private final NullPolicy nullPolicy;
        private final NullEquality nullEquality;
        private final NaNEquality nanEquality;

        public CollectSetAggregation(NullPolicy nullPolicy, NullEquality nullEquality, NaNEquality nanEquality) {
            super(Kind.COLLECT_SET);
            this.nullPolicy = nullPolicy;
            this.nullEquality = nullEquality;
            this.nanEquality = nanEquality;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createCollectSetAgg(this.nullPolicy.includeNulls, this.nullEquality.nullsEqual, this.nanEquality.nansEqual);
        }

        @Override
        public int hashCode() {
            return 31 * this.kind.hashCode() + Boolean.hashCode(this.nullPolicy.includeNulls) + Boolean.hashCode(this.nullEquality.nullsEqual) + Boolean.hashCode(this.nanEquality.nansEqual);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof CollectSetAggregation) {
                CollectSetAggregation o = (CollectSetAggregation)other;
                return o.nullPolicy == this.nullPolicy && o.nullEquality == this.nullEquality && o.nanEquality == this.nanEquality;
            }
            return false;
        }
    }

    public static final class CollectListAggregation
    extends Aggregation
    implements RollingAggregation<CollectListAggregation> {
        private final NullPolicy nullPolicy;

        private CollectListAggregation(NullPolicy nullPolicy) {
            super(Kind.COLLECT_LIST);
            this.nullPolicy = nullPolicy;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createCollectListAgg(this.nullPolicy.includeNulls);
        }

        @Override
        public int hashCode() {
            return 31 * this.kind.hashCode() + this.nullPolicy.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof CollectListAggregation) {
                CollectListAggregation o = (CollectListAggregation)other;
                return o.nullPolicy == this.nullPolicy;
            }
            return false;
        }
    }

    private static class LeadLagAggregation
    extends Aggregation {
        private final int offset;
        private final ColumnVector defaultOutput;

        LeadLagAggregation(Kind kind, int offset, ColumnVector defaultOutput) {
            super(kind);
            this.offset = offset;
            this.defaultOutput = defaultOutput;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createLeadLagAgg(this.kind.nativeId, this.offset);
        }

        @Override
        public int hashCode() {
            int ret = 31 * this.kind.hashCode() + this.offset;
            if (this.defaultOutput != null) {
                ret = 31 * ret + this.defaultOutput.hashCode();
            }
            return ret;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LeadLagAggregation) {
                boolean ret;
                LeadLagAggregation o = (LeadLagAggregation)other;
                boolean bl = ret = o.kind == this.kind && this.offset == o.offset;
                if (this.defaultOutput != null) {
                    ret = ret && this.defaultOutput.equals(o.defaultOutput);
                } else if (o.defaultOutput != null) {
                    ret = false;
                }
                return ret;
            }
            return false;
        }

        @Override
        long getDefaultOutput() {
            return this.defaultOutput == null ? 0L : this.defaultOutput.getNativeView();
        }
    }

    private static class QuantileAggregation
    extends Aggregation {
        private final QuantileMethod method;
        private final double[] quantiles;

        public QuantileAggregation(QuantileMethod method, double[] quantiles) {
            super(Kind.QUANTILE);
            this.method = method;
            this.quantiles = quantiles;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createQuantAgg(this.method.nativeId, this.quantiles);
        }

        @Override
        public int hashCode() {
            return 31 * (31 * this.kind.hashCode() + this.method.hashCode()) + Arrays.hashCode(this.quantiles);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof QuantileAggregation) {
                QuantileAggregation o = (QuantileAggregation)other;
                return this.method == o.method && Arrays.equals(this.quantiles, o.quantiles);
            }
            return false;
        }
    }

    private static class CountLikeAggregation
    extends Aggregation {
        private final NullPolicy nullPolicy;

        public CountLikeAggregation(Kind kind, NullPolicy nullPolicy) {
            super(kind);
            this.nullPolicy = nullPolicy;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createCountLikeAgg(this.kind.nativeId, this.nullPolicy.includeNulls);
        }

        @Override
        public int hashCode() {
            return 31 * this.kind.hashCode() + this.nullPolicy.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof CountLikeAggregation) {
                CountLikeAggregation o = (CountLikeAggregation)other;
                return o.nullPolicy == this.nullPolicy;
            }
            return false;
        }
    }

    private static class DdofAggregation
    extends Aggregation {
        private final int ddof;

        public DdofAggregation(Kind kind, int ddof) {
            super(kind);
            this.ddof = ddof;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createDdofAgg(this.kind.nativeId, this.ddof);
        }

        @Override
        public int hashCode() {
            return 31 * this.kind.hashCode() + this.ddof;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DdofAggregation) {
                DdofAggregation o = (DdofAggregation)other;
                return o.ddof == this.ddof;
            }
            return false;
        }
    }

    public static final class NthAggregation
    extends Aggregation {
        private final int offset;
        private final NullPolicy nullPolicy;

        private NthAggregation(int offset, NullPolicy nullPolicy) {
            super(Kind.NTH_ELEMENT);
            this.offset = offset;
            this.nullPolicy = nullPolicy;
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createNthAgg(this.offset, this.nullPolicy.includeNulls);
        }

        @Override
        public int hashCode() {
            return 31 * this.offset + this.nullPolicy.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof NthAggregation) {
                NthAggregation o = (NthAggregation)other;
                return o.offset == this.offset && o.nullPolicy == this.nullPolicy;
            }
            return false;
        }
    }

    private static class NoParamAggregation
    extends Aggregation {
        public NoParamAggregation(Kind kind) {
            super(kind);
        }

        @Override
        long createNativeInstance() {
            return Aggregation.createNoParamAgg(this.kind.nativeId);
        }

        @Override
        public int hashCode() {
            return this.kind.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof NoParamAggregation) {
                NoParamAggregation o = (NoParamAggregation)other;
                return o.kind.equals((Object)this.kind);
            }
            return false;
        }
    }

    static enum Kind {
        SUM(0),
        PRODUCT(1),
        MIN(2),
        MAX(3),
        COUNT(4),
        ANY(5),
        ALL(6),
        SUM_OF_SQUARES(7),
        MEAN(8),
        VARIANCE(9),
        STD(10),
        MEDIAN(11),
        QUANTILE(12),
        ARGMAX(13),
        ARGMIN(14),
        NUNIQUE(15),
        NTH_ELEMENT(16),
        ROW_NUMBER(17),
        COLLECT_LIST(18),
        COLLECT_SET(19),
        LEAD(20),
        LAG(21),
        PTX(22),
        CUDA(23);

        final int nativeId;

        private Kind(int nativeId) {
            this.nativeId = nativeId;
        }
    }
}

